/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.util.MultiValuedMap;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class MultiValuedHashMap
implements MultiValuedMap {
    private Hashtable mm_keysToValues;

    public MultiValuedHashMap() {
        this(2);
    }

    public MultiValuedHashMap(int initialCapacity) {
        this.mm_keysToValues = new Hashtable(initialCapacity);
    }

    public void put(Object key, Object value) {
        MultiValuedHashMap multiValuedHashMap = this;
        synchronized (multiValuedHashMap) {
            HashSet<Object> values = (HashSet<Object>)this.mm_keysToValues.get(key);
            if (values == null) {
                values = new HashSet<Object>(1);
                values.add(value);
                this.mm_keysToValues.put(key, values);
            } else {
                values.add(value);
            }
        }
    }

    public void remove(Object key) {
        MultiValuedHashMap multiValuedHashMap = this;
        synchronized (multiValuedHashMap) {
            this.remove(key, null);
        }
    }

    public void remove(Object key, Object value) {
        MultiValuedHashMap multiValuedHashMap = this;
        synchronized (multiValuedHashMap) {
            if (value == null) {
                this.mm_keysToValues.remove(key);
            } else {
                HashSet values = (HashSet)this.mm_keysToValues.get(key);
                if (values != null) {
                    values.remove(value);
                }
            }
        }
    }

    public Enumeration getKeysEnumeration() {
        return this.mm_keysToValues.keys();
    }

    public void getKeys(Object[] keys) {
        this.mm_keysToValues.keySet().toArray(keys);
    }

    public int size() {
        return this.mm_keysToValues.size();
    }

    public int getValueCount(Object key) {
        HashSet values = (HashSet)this.mm_keysToValues.get(key);
        if (values != null) {
            return values.size();
        }
        return 0;
    }

    public Iterator getValuesIterator(Object key) {
        HashSet values = (HashSet)this.mm_keysToValues.get(key);
        if (values != null) {
            return values.iterator();
        }
        return null;
    }

    public void getValues(Object key, Object[] values) {
        MultiValuedHashMap multiValuedHashMap = this;
        synchronized (multiValuedHashMap) {
            HashSet myvalues = (HashSet)this.mm_keysToValues.get(key);
            if (myvalues != null) {
                ((AbstractCollection)myvalues).toArray(values);
            }
        }
    }

    public Object getValue(Object key) {
        Iterator it = this.getValuesIterator(key);
        if (it != null && it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public void clear() {
        this.mm_keysToValues.clear();
    }
}

