/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.logger.ILogger;
import java.util.Arrays;

public class FiFoList {
    private final Object[] CONTENT;
    private final int POOL_SIZE;
    private final int MAX_INDEX;
    private int mm_begin;
    private int mm_end;
    private boolean mm_full;
    private ILogger mm_logger = null;

    public FiFoList(int size) {
        this.POOL_SIZE = size;
        this.MAX_INDEX = this.POOL_SIZE - 1;
        this.CONTENT = new Object[this.POOL_SIZE];
        this.mm_begin = 0;
        this.mm_end = 0;
        this.mm_full = false;
    }

    public void setLogger(ILogger logger) {
        this.mm_logger = logger;
    }

    public synchronized Object get() {
        Object item = null;
        if (!this.isEmpty()) {
            item = this.CONTENT[this.mm_begin];
            ++this.mm_begin;
            if (this.mm_begin > this.MAX_INDEX) {
                this.mm_begin = 0;
            }
            this.mm_full = false;
        }
        return item;
    }

    public synchronized Object put(Object item) {
        Object overwrittenItem = null;
        if (this.POOL_SIZE == 0) {
            return item;
        }
        if (this.mm_full) {
            overwrittenItem = this.CONTENT[this.mm_end];
            ++this.mm_begin;
            if (this.mm_begin > this.MAX_INDEX) {
                this.mm_begin = 0;
            }
        }
        this.CONTENT[this.mm_end] = item;
        ++this.mm_end;
        if (this.mm_end > this.MAX_INDEX) {
            this.mm_end = 0;
        }
        if (this.mm_end == this.mm_begin) {
            this.mm_full = true;
        }
        return overwrittenItem;
    }

    public synchronized Object lookupNext() {
        Object item = null;
        if (!this.isEmpty()) {
            item = this.CONTENT[this.mm_begin];
        }
        return item;
    }

    public synchronized int getNumberOfItems() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.mm_begin == this.mm_end) {
            return this.POOL_SIZE;
        }
        if (this.mm_begin < this.mm_end) {
            return this.mm_end - this.mm_begin;
        }
        return this.POOL_SIZE - this.mm_begin + this.mm_end;
    }

    public synchronized boolean isEmpty() {
        return this.mm_begin == this.mm_end && !this.mm_full;
    }

    public String toString() {
        return "begin: " + this.mm_begin + ", end: " + this.mm_end + ", full: " + this.mm_full + ", content: " + Arrays.asList(this.CONTENT) + ", hash code: " + this.hashCode();
    }
}

