/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.runtime;

import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class PortalRuntimeException
extends RuntimeException {
    private Throwable mm_cause = null;
    private static boolean mm_javaVersion1_3OrBelow = true;

    public PortalRuntimeException(String s) {
        super(s);
    }

    public PortalRuntimeException(Throwable exception) {
        super("PortalRuntimeException");
        this.setException(exception);
    }

    public PortalRuntimeException(String s, Throwable exception) {
        super(s);
        this.setException(exception);
    }

    public Throwable getException() {
        return this.mm_cause;
    }

    public void setException(Throwable t) {
        this.mm_cause = t;
    }

    public void setCause(Throwable cause) {
        this.mm_cause = cause;
    }

    public Throwable getCause() {
        return this.mm_cause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (mm_javaVersion1_3OrBelow && this.mm_cause != null) {
            s.print("Caused by: ");
            this.mm_cause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (mm_javaVersion1_3OrBelow && this.mm_cause != null) {
            s.print("Caused by: ");
            this.mm_cause.printStackTrace(s);
        }
    }

    public String toHTML() {
        return "<pre>" + StringUtils.escapeToHTML(this.toText()) + "</pre>";
    }

    public String toText() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printstream = new PrintStream(baos, true);
        this.printStackTrace(printstream);
        String stacktrace = baos.toString();
        return stacktrace;
    }

    static {
        String javaVersion = null;
        try {
            javaVersion = System.getProperty("java.version");
            if (Character.digit(javaVersion.charAt(2), 10) > 3) {
                mm_javaVersion1_3OrBelow = false;
            }
        }
        catch (Exception e) {
            PortalRuntime.getLogger().warning(e, "Java version could not be detected. Property 'java.version': " + javaVersion);
        }
    }
}

