/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.resource;

import com.sapportals.portal.prt.resource.IResource;
import com.sapportals.portal.prt.runtime.PortalRuntimeException;

public class ResourceException
extends PortalRuntimeException {
    private String mm_docBase = null;
    private String mm_properties = null;
    private String mm_componentName = null;
    private String mm_className = null;
    private String mm_resourceType = null;
    private String mm_resourceName = null;

    public ResourceException(String s) {
        super(s);
    }

    public ResourceException(Throwable exception) {
        super("ResourceException", exception);
    }

    public ResourceException(String s, Throwable exception) {
        super(s, exception);
    }

    public void setDetail(String docBase, IResource resource) {
        this.mm_docBase = docBase;
        if (resource != null) {
            this.mm_properties = resource.getResourceInformation().getSource();
        }
    }

    public void setResourceType(String resourceType) {
        this.mm_resourceType = resourceType;
    }

    public void setClassName(String className) {
        this.mm_className = className;
    }

    public void setComponentName(String componentName) {
        this.mm_componentName = componentName;
    }

    public void setResourceName(String resourceName) {
        this.mm_resourceName = resourceName;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.mm_resourceType != null) {
            message = message + "\r\nComponent name : " + this.mm_componentName;
            message = message + "\r\nResource type : " + this.mm_resourceType;
            message = message + "\r\nClass for this type : " + this.mm_className;
            message = message + "\r\nResource name : " + this.mm_resourceName;
        } else {
            if (this.mm_docBase != null) {
                message = message + "\r\nCheck the web server dependent path : " + this.mm_docBase;
            }
            if (this.mm_properties != null) {
                message = message + "\r\nCheck portal properties path : " + this.mm_properties;
            }
        }
        return message;
    }
}

