/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.logger;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Level
implements Serializable {
    private int mm_level;
    private String mm_name;
    public static final int OFF_ID = 0;
    public static final Level OFF = new Level("OFF", 0);
    public static final int SEVERE_ID = 1;
    public static final Level SEVERE = new Level("SEVERE", 1);
    public static final int WARNING_ID = 2;
    public static final Level WARNING = new Level("WARNING", 2);
    public static final int INFO_ID = 3;
    public static final Level INFO = new Level("INFO", 3);
    public static final int ALL_ID = 4;
    public static final Level ALL = new Level("ALL", 4);
    public static final int SYSTEM_ID = -1;
    public static final Level SYSTEM = new Level("SYSTEM", -1);

    protected Level(String name, int value) {
        this.mm_name = name;
        this.mm_level = value;
    }

    public boolean equals(Object levelObject) {
        Level aLevel;
        boolean isEqual = false;
        if (levelObject instanceof Level && (aLevel = (Level)levelObject).intValue() == this.intValue()) {
            isEqual = true;
        }
        return isEqual;
    }

    public final int intValue() {
        return this.mm_level;
    }

    public final String toString() {
        return this.mm_name;
    }

    public static Level parse(String name) throws IllegalArgumentException {
        if (name.compareTo(WARNING.toString()) >= 0) {
            return WARNING;
        }
        if (name.compareTo(SEVERE.toString()) >= 0) {
            return SEVERE;
        }
        if (name.compareTo(OFF.toString()) >= 0) {
            return OFF;
        }
        if (name.compareTo(INFO.toString()) >= 0) {
            return INFO;
        }
        if (name.compareTo(ALL.toString()) >= 0) {
            return ALL;
        }
        throw new IllegalArgumentException("Name value is not one of the known names or integer.");
    }

    public static Enumeration getAllLevels() {
        Vector<Level> allLevels = new Vector<Level>(5);
        allLevels.add(ALL);
        allLevels.add(INFO);
        allLevels.add(OFF);
        allLevels.add(SEVERE);
        allLevels.add(WARNING);
        return allLevels.elements();
    }
}

