/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.component;

import com.sapportals.portal.prt.component.CachingLevel;
import com.sapportals.portal.prt.component.IEventListenerComponent;
import com.sapportals.portal.prt.component.IPortalComponent;
import com.sapportals.portal.prt.component.IPortalComponentConfig;
import com.sapportals.portal.prt.component.IPortalComponentContext;
import com.sapportals.portal.prt.component.IPortalComponentInit;
import com.sapportals.portal.prt.component.IPortalComponentInitContext;
import com.sapportals.portal.prt.component.IPortalComponentProfile;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.PortalComponentException;
import com.sapportals.portal.prt.component.PortalComponentRequestType;
import com.sapportals.portal.prt.event.IPortalComponentEvent;
import com.sapportals.portal.prt.event.IPortalRequestEvent;
import com.sapportals.portal.prt.pom.EventType;
import com.sapportals.portal.prt.pom.IEvent;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractPortalComponent
implements IPortalComponent,
IPortalComponentInit,
IEventListenerComponent {
    private static final Class[] ComponentServiceFormalParams = new Class[]{class$com$sapportals$portal$prt$component$IPortalComponentRequest == null ? (class$com$sapportals$portal$prt$component$IPortalComponentRequest = AbstractPortalComponent.class$("com.sapportals.portal.prt.component.IPortalComponentRequest")) : class$com$sapportals$portal$prt$component$IPortalComponentRequest, class$com$sapportals$portal$prt$component$IPortalComponentResponse == null ? (class$com$sapportals$portal$prt$component$IPortalComponentResponse = AbstractPortalComponent.class$("com.sapportals.portal.prt.component.IPortalComponentResponse")) : class$com$sapportals$portal$prt$component$IPortalComponentResponse};
    private static final Class[] ComponentEventHandlerFormalParams = new Class[]{class$com$sapportals$portal$prt$component$IPortalComponentRequest == null ? (class$com$sapportals$portal$prt$component$IPortalComponentRequest = AbstractPortalComponent.class$("com.sapportals.portal.prt.component.IPortalComponentRequest")) : class$com$sapportals$portal$prt$component$IPortalComponentRequest, class$com$sapportals$portal$prt$event$IPortalComponentEvent == null ? (class$com$sapportals$portal$prt$event$IPortalComponentEvent = AbstractPortalComponent.class$("com.sapportals.portal.prt.event.IPortalComponentEvent")) : class$com$sapportals$portal$prt$event$IPortalComponentEvent};
    private static final Class[] RequestEventHandlerFormalParams = new Class[]{class$com$sapportals$portal$prt$component$IPortalComponentRequest == null ? (class$com$sapportals$portal$prt$component$IPortalComponentRequest = AbstractPortalComponent.class$("com.sapportals.portal.prt.component.IPortalComponentRequest")) : class$com$sapportals$portal$prt$component$IPortalComponentRequest, class$com$sapportals$portal$prt$event$IPortalRequestEvent == null ? (class$com$sapportals$portal$prt$event$IPortalRequestEvent = AbstractPortalComponent.class$("com.sapportals.portal.prt.event.IPortalRequestEvent")) : class$com$sapportals$portal$prt$event$IPortalRequestEvent};
    static /* synthetic */ Class class$com$sapportals$portal$prt$component$IPortalComponentRequest;
    static /* synthetic */ Class class$com$sapportals$portal$prt$component$IPortalComponentResponse;
    static /* synthetic */ Class class$com$sapportals$portal$prt$event$IPortalComponentEvent;
    static /* synthetic */ Class class$com$sapportals$portal$prt$event$IPortalRequestEvent;

    public void destroy() {
    }

    public void init() {
    }

    public void init(IPortalComponentInitContext context) throws PortalComponentException {
        this.init(context.getComponentConfig());
    }

    public void init(IPortalComponentConfig config) throws PortalComponentException {
    }

    public void service(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) throws PortalComponentException {
        NodeMode nodeMode = aRequest.getNode().getNodeMode();
        if (!this.serviceDeprecated(aRequest, aResponse, nodeMode)) {
            String modeName = nodeMode.toString();
            boolean success = false;
            if (modeName != null && modeName.length() > 0) {
                String methodName = "do" + Character.toUpperCase(modeName.charAt(0)) + modeName.substring(1);
                try {
                    Method theMethod = this.getClass().getMethod(methodName, ComponentServiceFormalParams);
                    if (theMethod != null) {
                        theMethod.invoke((Object)this, aRequest, aResponse);
                        success = true;
                    }
                }
                catch (InvocationTargetException e) {
                    throw new PortalRuntimeException(e.getTargetException());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!success) {
                this.doContent(aRequest, aResponse);
            }
        }
    }

    private boolean serviceDeprecated(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse, NodeMode nodeMode) {
        if (aRequest.getRequestType() == PortalComponentRequestType.PREVIEW || nodeMode == NodeMode.PREVIEW_MODE) {
            this.doPreview(aRequest, aResponse);
            return true;
        }
        if (aRequest.getRequestType() == PortalComponentRequestType.EDIT || nodeMode == NodeMode.EDIT_MODE) {
            this.doEdit(aRequest, aResponse);
            return true;
        }
        if (aRequest.getRequestType() == PortalComponentRequestType.ABOUT || nodeMode == NodeMode.ABOUT_MODE) {
            this.doAbout(aRequest, aResponse);
            return true;
        }
        if (aRequest.getRequestType() == PortalComponentRequestType.HELP || nodeMode == NodeMode.HELP_MODE) {
            this.doHelp(aRequest, aResponse);
            return true;
        }
        if (aRequest.getRequestType() == PortalComponentRequestType.REFRESH || nodeMode == NodeMode.REFRESH_MODE) {
            this.doRefresh(aRequest, aResponse);
            return true;
        }
        if (aRequest.getRequestType() == PortalComponentRequestType.CONTENT && nodeMode == NodeMode.DEFAULT_MODE) {
            boolean loggerIsOn = aRequest.getLogger().isActive();
            this.doContent(aRequest, aResponse);
            return true;
        }
        return false;
    }

    protected abstract void doContent(IPortalComponentRequest var1, IPortalComponentResponse var2);

    protected void doPreview(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) {
        this.doContent(aRequest, aResponse);
    }

    protected void doAbout(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) {
        IPortalComponentContext context = aRequest.getComponentContext();
        String componentName = "n.a.";
        String contextName = "n.a.";
        if (context != null) {
            componentName = context.getComponentName();
            contextName = context.getContextName();
        }
        aResponse.write("<p>Name: " + StringUtils.escapeToHTML(componentName) + "</p>");
        aResponse.write("<p>Context: " + StringUtils.escapeToHTML(contextName) + "</p>");
    }

    protected void doHelp(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) {
        this.doContent(aRequest, aResponse);
    }

    protected void doEdit(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) {
        IPortalComponent delegateComponent = this.getPersonalizationDelegate(aRequest);
        if (delegateComponent != null) {
            Class<?> c = delegateComponent.getClass();
            try {
                Method doEditMethod = c.getDeclaredMethod("doEdit", ComponentServiceFormalParams);
                delegateComponent.service(aRequest, aResponse);
            }
            catch (NoSuchMethodException e) {}
        } else {
            this.doContent(aRequest, aResponse);
        }
    }

    protected void doRefresh(IPortalComponentRequest aRequest, IPortalComponentResponse aResponse) {
        this.doContent(aRequest, aResponse);
    }

    public void handleEvent(IPortalComponentRequest request, IEvent event) {
        if (event.getType() == EventType.ON_NODE_READY_EVENT) {
            this.doOnNodeReady(request, event);
        } else if (event.getType() == EventType.ON_NODE_REMOVE_EVENT) {
            this.doOnNodeRemove(request, event);
        } else if (event.getType() == EventType.ON_POM_READY_EVENT) {
            this.doOnPOMReady(request, event);
        } else if (event.getType() == EventType.BEFORE_CONTENT_EVENT) {
            this.doBeforeContent(request, event);
        } else if (event.getType() == EventType.AFTER_CONTENT_EVENT) {
            this.doAfterContent(request, event);
        } else if (event.getType() == EventType.COMPONENT_EVENT) {
            this.handleComponentEvent(request, (IPortalComponentEvent)event);
        } else if (event.getType() == EventType.REQUEST_EVENT) {
            this.handleRequestEvent(request, (IPortalRequestEvent)event);
        }
    }

    protected void doOnNodeReady(IPortalComponentRequest request, IEvent event) {
    }

    protected void doOnNodeRemove(IPortalComponentRequest request, IEvent event) {
    }

    protected void doOnPOMReady(IPortalComponentRequest request, IEvent event) {
    }

    protected void doBeforeContent(IPortalComponentRequest request, IEvent event) {
    }

    protected void doAfterContent(IPortalComponentRequest request, IEvent event) {
    }

    protected void doRequestEvent(IPortalComponentRequest aRequest, IPortalRequestEvent event) {
    }

    protected void doComponentEvent(IPortalComponentRequest aRequest, IPortalComponentEvent event) {
    }

    public boolean hasExpired(IPortalComponentRequest request, long creationTime, long currentTime) {
        try {
            String validityPeriodString = request.getComponentContext().getProfile().getProperty("ValidityPeriod");
            if (validityPeriodString != null) {
                long validityPeriod = Long.parseLong(validityPeriodString);
                if (validityPeriod < 0L) {
                    return false;
                }
                if (currentTime - creationTime > validityPeriod) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public CachingLevel getCachingLevel(IPortalComponentRequest request) {
        String levelString = request.getComponentContext().getProfile().getProperty("CachingLevel");
        if (levelString != null) {
            return CachingLevel.parse(levelString);
        }
        return CachingLevel.SESSION;
    }

    public String getCacheDiscriminant(IPortalComponentRequest request) {
        return null;
    }

    public void doHandleEditData(IPortalComponentRequest request, IPortalRequestEvent event) {
        IPortalComponent delegateComponent = this.getPersonalizationDelegate(request);
        if (delegateComponent instanceof IEventListenerComponent) {
            ((IEventListenerComponent)((Object)delegateComponent)).handleEvent(request, event);
        }
    }

    private IPortalComponent getPersonalizationDelegate(IPortalComponentRequest request) {
        IPortalComponentContext context = request.getComponentContext();
        IPortalComponentProfile profile = context.getProfile();
        String delegateClassName = profile.getProperty("PersonalizationClass");
        if (delegateClassName != null) {
            try {
                Class<?> delegateClass = Class.forName(delegateClassName, true, this.getClass().getClassLoader());
                return (IPortalComponent)delegateClass.newInstance();
            }
            catch (Exception e) {
                throw new PortalComponentException("Failed to load personalization delegate " + delegateClassName, e);
            }
        }
        return PortalRuntime.getRuntimeResources().getDefaultPersonalizationDelegate();
    }

    private void handleComponentEvent(IPortalComponentRequest aRequest, IPortalComponentEvent aComponentEvent) {
        String eventName = aComponentEvent.getName();
        boolean called = false;
        if (eventName != null && eventName.length() > 0) {
            String methodName = "do" + Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1);
            try {
                Method theMethod = this.getClass().getDeclaredMethod(methodName, ComponentEventHandlerFormalParams);
                if (theMethod != null) {
                    called = true;
                    theMethod.invoke((Object)this, aRequest, aComponentEvent);
                }
            }
            catch (NoSuchMethodException nsme) {
                called = false;
            }
            catch (InvocationTargetException ite) {
                called = false;
            }
            catch (IllegalAccessException iae) {
                called = false;
            }
        }
        if (!called) {
            this.doComponentEvent(aRequest, aComponentEvent);
        }
    }

    private void handleRequestEvent(IPortalComponentRequest request, IPortalRequestEvent requestEvent) {
        String eventName = requestEvent.getName();
        boolean called = false;
        if (eventName != null && eventName.length() > 0) {
            String methodName = "do" + Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1);
            try {
                Method theMethod = this.getClass().getMethod(methodName, RequestEventHandlerFormalParams);
                if (theMethod != null) {
                    theMethod.invoke((Object)this, request, requestEvent);
                    called = true;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (!called) {
            this.doRequestEvent(request, requestEvent);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

