/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Policy {
    private static String bundleName = "org.eclipse.core.internal.utils.messages";
    private static ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
    private static final int autoBuildOpWork = 70;
    private static final int autoBuildBuildWork = 30;
    private static final int manualBuildOpWork = 99;
    private static final int manualBuildBuildWork = 1;
    public static final boolean buildOnCancel = false;
    public static int opWork;
    public static int buildWork;
    public static int totalWork;
    public static final boolean defaultAutoBuild = true;
    public static final boolean defaultSnapshots = true;
    public static final int defaultOperationsPerSnapshot = 100;
    public static final long defaultSnapshotInterval = 300000L;
    public static final long defaultDeltaExpiration = 2592000000L;
    public static final long defaultFileStateLongevity = 604800000L;
    public static final long defaultMaxFileStateSize = 0x100000L;
    public static final int defaultMaxFileStates = 50;
    public static final int defaultMaxBuildIterations = 10;
    public static boolean DEBUG_BUILD_FAILURE;
    public static boolean DEBUG_NEEDS_BUILD;
    public static boolean DEBUG_BUILD_INVOKING;
    public static boolean DEBUG_BUILD_DELTA;
    public static boolean DEBUG_NATURES;
    public static boolean DEBUG_HISTORY;
    public static boolean MONITOR_BUILDERS;
    public static boolean MONITOR_LISTENERS;
    public static boolean DEBUG_RESTORE;
    public static boolean DEBUG_RESTORE_MARKERS;
    public static boolean DEBUG_RESTORE_SYNCINFO;
    public static boolean DEBUG_RESTORE_TREE;
    public static boolean DEBUG_RESTORE_METAINFO;
    public static boolean DEBUG_RESTORE_SNAPSHOTS;
    public static boolean DEBUG_RESTORE_MASTERTABLE;
    public static boolean DEBUG_SAVE;
    public static boolean DEBUG_SAVE_MARKERS;
    public static boolean DEBUG_SAVE_SYNCINFO;
    public static boolean DEBUG_SAVE_TREE;
    public static boolean DEBUG_SAVE_METAINFO;
    public static boolean DEBUG_SAVE_SNAPSHOTS;
    public static boolean DEBUG_SAVE_MASTERTABLE;

    static {
        DEBUG_BUILD_FAILURE = false;
        DEBUG_NEEDS_BUILD = false;
        DEBUG_BUILD_INVOKING = false;
        DEBUG_BUILD_DELTA = false;
        DEBUG_NATURES = false;
        DEBUG_HISTORY = false;
        MONITOR_BUILDERS = false;
        MONITOR_LISTENERS = false;
        DEBUG_RESTORE = false;
        DEBUG_RESTORE_MARKERS = false;
        DEBUG_RESTORE_SYNCINFO = false;
        DEBUG_RESTORE_TREE = false;
        DEBUG_RESTORE_METAINFO = false;
        DEBUG_RESTORE_SNAPSHOTS = false;
        DEBUG_RESTORE_MASTERTABLE = false;
        DEBUG_SAVE = false;
        DEBUG_SAVE_MARKERS = false;
        DEBUG_SAVE_SYNCINFO = false;
        DEBUG_SAVE_TREE = false;
        DEBUG_SAVE_METAINFO = false;
        DEBUG_SAVE_SNAPSHOTS = false;
        DEBUG_SAVE_MASTERTABLE = false;
        Policy.setupAutoBuildProgress(true);
        if (ResourcesPlugin.getPlugin().isDebugging()) {
            DEBUG_BUILD_FAILURE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/failure"));
            DEBUG_NEEDS_BUILD = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/needbuild"));
            DEBUG_BUILD_INVOKING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/invoking"));
            DEBUG_BUILD_DELTA = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/delta"));
            DEBUG_NATURES = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/natures"));
            DEBUG_HISTORY = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/history"));
            MONITOR_BUILDERS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/monitor/builders"));
            MONITOR_LISTENERS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/monitor/listeners"));
            DEBUG_RESTORE_MARKERS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/markers"));
            DEBUG_RESTORE_SYNCINFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/syncinfo"));
            DEBUG_RESTORE_TREE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/tree"));
            DEBUG_RESTORE_METAINFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/metainfo"));
            DEBUG_RESTORE_SNAPSHOTS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/snapshots"));
            DEBUG_RESTORE_MASTERTABLE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/mastertable"));
            DEBUG_RESTORE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore"));
            DEBUG_SAVE_MARKERS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/markers"));
            DEBUG_SAVE_SYNCINFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/syncinfo"));
            DEBUG_SAVE_TREE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/tree"));
            DEBUG_SAVE_METAINFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/metainfo"));
            DEBUG_SAVE_SNAPSHOTS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/snapshots"));
            DEBUG_SAVE_MASTERTABLE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/mastertable"));
            DEBUG_SAVE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save"));
        }
    }

    public static String bind(String id) {
        return Policy.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] bindings) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        if (bindings == null) {
            return message;
        }
        return MessageFormat.format(message, bindings);
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static void setupAutoBuildProgress(boolean on) {
        opWork = on ? 70 : 99;
        buildWork = on ? 30 : 1;
        totalWork = opWork + buildWork;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks, int style) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks, style);
    }

    public static void debug(boolean includeDate, String message) {
        if (includeDate) {
            message = String.valueOf(new Date(System.currentTimeMillis()).toString()) + " - " + message;
        }
        System.out.println(message);
    }
}

