/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceTreeReader_2
extends WorkspaceTreeReader {
    public WorkspaceTreeReader_2(Workspace workspace) {
        super(workspace);
    }

    protected int getVersion() {
        return 67305986;
    }

    protected void readBuildersPersistentInfo(DataInputStream input, List builders, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            int builderCount = input.readInt();
            int i = 0;
            while (i < builderCount) {
                BuilderPersistentInfo info = new BuilderPersistentInfo();
                info.setProjectName(input.readUTF());
                info.setBuilderName(input.readUTF());
                int n = input.readInt();
                IProject[] projects = new IProject[n];
                int j = 0;
                while (j < n) {
                    projects[j] = this.workspace.getRoot().getProject(input.readUTF());
                    ++j;
                }
                info.setInterestingProjects(projects);
                builders.add(info);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var10_12 = null;
        monitor.done();
    }

    public void readTree(IProject project, DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = Policy.bind("resources.reading");
                monitor.beginTask(message, 10);
                ArrayList infos = new ArrayList(5);
                this.readBuildersPersistentInfo(input, infos, Policy.subMonitorFor(monitor, 1));
                Iterator it = infos.iterator();
                while (it.hasNext()) {
                    BuilderPersistentInfo info = (BuilderPersistentInfo)it.next();
                    info.setProjectName(project.getName());
                }
                ElementTree[] trees = this.readTrees(project.getFullPath(), input, Policy.subMonitorFor(monitor, 8));
                this.linkBuildersToTrees(infos, trees, 0, Policy.subMonitorFor(monitor, 1));
            }
            catch (IOException e) {
                String message = Policy.bind("resources.readProjectTree");
                throw new ResourceException(567, null, message, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var8_12 = null;
        monitor.done();
    }
}

