/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class StoreKey {
    protected byte[] value = null;
    protected boolean matchPrefix = false;
    protected ResourceName resourceName = null;
    protected String qualifier = null;
    protected String localName = null;

    public StoreKey(byte[] bytes) throws CoreException {
        this.value = bytes;
        this.initializeObjects();
    }

    public StoreKey(ResourceName resourceName, String qualifier) throws CoreException {
        this.resourceName = resourceName;
        this.qualifier = qualifier;
        this.initializeBytes();
    }

    public StoreKey(ResourceName resourceName, QualifiedName propertyName) throws CoreException {
        this.resourceName = resourceName;
        this.qualifier = propertyName.getQualifier();
        this.localName = propertyName.getLocalName();
        this.initializeBytes();
    }

    public StoreKey(ResourceName resourceName, boolean matchPrefix) throws CoreException {
        this.resourceName = resourceName;
        this.matchPrefix = matchPrefix;
        this.initializeBytes();
    }

    public String getLocalName() {
        return this.localName;
    }

    public QualifiedName getPropertyName() {
        return new QualifiedName(this.qualifier, this.localName);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    private void initializeBytes() throws CoreException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.writeNullTerminated(buffer, this.resourceName.getQualifier());
            String path = this.resourceName.getPath().toString();
            if (this.matchPrefix) {
                this.writeBytes(buffer, path);
                if (this.qualifier != null || this.localName != null) {
                    String message = Policy.bind("properties.invalidPropName", this.qualifier, this.localName);
                    throw new ResourceException(77, null, message, null);
                }
            } else {
                this.writeNullTerminated(buffer, path);
            }
            if (this.qualifier != null) {
                this.writeNullTerminated(buffer, this.qualifier);
                if (this.localName != null) {
                    this.writeNullTerminated(buffer, this.localName);
                }
            } else if (this.localName != null) {
                String message = Policy.bind("properties.invalidPropName", this.qualifier, this.localName);
                throw new ResourceException(77, null, message, null);
            }
            this.value = buffer.toByteArray();
        }
        catch (IOException e) {
            throw new ResourceException(566, null, Policy.bind("properties.storeProblem"), e);
        }
    }

    protected void initializeObjects() throws CoreException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(this.value);
            String prefix = this.readNullTerminated(stream);
            String path = this.readNullTerminated(stream);
            this.resourceName = new ResourceName(prefix, (IPath)new Path(path));
            this.qualifier = this.readNullTerminated(stream);
            this.localName = this.readNullTerminated(stream);
        }
        catch (IOException e) {
            throw new ResourceException(566, null, Policy.bind("properties.storeProblem"), e);
        }
    }

    public boolean isFullyDefined() {
        return this.resourceName != null && this.qualifier != null && this.localName != null;
    }

    public boolean matchPrefix() {
        return this.matchPrefix;
    }

    private String readNullTerminated(ByteArrayInputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int b = stream.read();
        while (b != 0) {
            buffer.write(b);
            b = stream.read();
        }
        return Convert.fromUTF8(buffer.toByteArray());
    }

    public byte[] toBytes() {
        return this.value;
    }

    public String toString() {
        return new String(this.toBytes());
    }

    private void writeBytes(ByteArrayOutputStream stream, String value) throws IOException {
        byte[] bytes = Convert.toUTF8(value);
        stream.write(bytes);
    }

    private void writeNullTerminated(ByteArrayOutputStream stream, String value) throws IOException {
        this.writeBytes(stream, value);
        stream.write(0);
    }
}

