/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.FieldArray;
import org.eclipse.core.internal.indexing.FieldDef;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.Pointer;

class IndexNode
extends IndexedStoreObject {
    public static final int SIZE = 7612;
    public static final int TYPE = 3;
    private static final int EntriesFieldOffset = 64;
    private static final int EntriesFieldSize = 7548;
    private static final FieldDef NodeType = new FieldDef(2, 2, 2);
    private static final FieldDef AnchorAddress = new FieldDef(5, 4, 4);
    private static final FieldDef ParentAddress = new FieldDef(5, 8, 4);
    private static final FieldDef PreviousAddress = new FieldDef(5, 12, 4);
    private static final FieldDef NextAddress = new FieldDef(5, 16, 4);
    private static final FieldDef NumberOfEntries = new FieldDef(2, 20, 2);
    private static final FieldDef UsedSpace = new FieldDef(2, 22, 2);
    private static final FieldDef UsedSpaceMax = new FieldDef(2, 24, 2);
    private static final FieldDef EntriesField = new FieldDef(5, 64, 7548);
    private int nodeType;
    private ObjectAddress anchorAddress;
    private ObjectAddress parentAddress;
    private ObjectAddress previousAddress;
    private ObjectAddress nextAddress;
    private int numberOfEntries;
    private int usedSpace;
    private int usedSpaceMax;
    private Field entriesField;
    private static final int RootNode = 1;
    private static final int InteriorNode = 2;
    private static final int LeafNode = 3;
    private static final int DescriptorLength = 6;
    private HashSet cursors = new HashSet();

    IndexNode(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        super(f, store, address);
    }

    IndexNode(ObjectAddress anchorAddress) {
        this.anchorAddress = anchorAddress;
        this.parentAddress = ObjectAddress.Null;
        this.previousAddress = ObjectAddress.Null;
        this.nextAddress = ObjectAddress.Null;
        this.usedSpace = 0;
        this.usedSpaceMax = 0;
        this.numberOfEntries = 0;
        this.nodeType = 1;
        this.entriesField = new Field(7548);
    }

    IndexNode(ObjectAddress anchorAddress, ObjectAddress parentAddress) {
        this(anchorAddress);
        this.parentAddress = parentAddress;
        this.nodeType = 2;
    }

    IndexNode(ObjectAddress anchorAddress, ObjectAddress parentAddress, ObjectAddress previousAddress, ObjectAddress nextAddress) {
        this(anchorAddress, parentAddress);
        this.previousAddress = previousAddress;
        this.nextAddress = nextAddress;
        this.nodeType = 3;
    }

    void addCursor(IndexCursor cursor) {
        this.cursors.add(cursor);
    }

    private int compareEntryToKey(int entryNumber, byte[] key) throws IndexedStoreException {
        Field keyField = new Field(key);
        Field entryKeyField = this.getKeyField(entryNumber);
        int result = entryKeyField.compareTo(keyField);
        return result;
    }

    private void compress() throws IndexedStoreException {
        int entriesLength = this.entriesField.length();
        int descriptorBlockSize = this.numberOfEntries * 6;
        Field f2 = new Field(this.entriesField.length());
        IndexNode.copyEntries(this.entriesField, 0, this.numberOfEntries, f2);
        this.entriesField.put(f2.get());
        this.usedSpaceMax = this.usedSpace;
        int freeBlockSize = entriesLength - (descriptorBlockSize + this.usedSpaceMax);
        Field f3 = this.entriesField.subfield(descriptorBlockSize, freeBlockSize);
        f3.clear();
        this.setChanged();
    }

    private void compress(int threshold) throws IndexedStoreException {
        int descriptorBlockSize;
        int entriesLength = this.entriesField.length();
        int freeBlockSize = entriesLength - ((descriptorBlockSize = this.numberOfEntries * 6) + this.usedSpaceMax);
        if (freeBlockSize >= threshold) {
            return;
        }
        this.compress();
    }

    private static int copyEntries(Field sourceField, int sourceIndex, int numberOfEntries, Field targetField) {
        Pointer tDescriptor = targetField.pointTo(0);
        Pointer sDescriptor = sourceField.pointTo(sourceIndex * 6);
        int tEntryOffset = targetField.length();
        int i = 0;
        while (i < numberOfEntries) {
            int sEntryOffset = sDescriptor.getField(0, 2).getUInt();
            int keyLength = sDescriptor.getField(2, 2).getUInt();
            int valueLength = sDescriptor.getField(4, 2).getUInt();
            int entryLength = keyLength + valueLength;
            Field sEntry = sourceField.subfield(sEntryOffset, entryLength);
            Field tEntry = targetField.subfield(tEntryOffset -= entryLength, entryLength);
            tEntry.put(sEntry.get());
            tDescriptor.getField(0, 2).put(tEntryOffset);
            tDescriptor.getField(2, 2).put(keyLength);
            tDescriptor.getField(4, 2).put(valueLength);
            tDescriptor.inc(6);
            sDescriptor.inc(6);
            ++i;
        }
        return targetField.length() - tEntryOffset;
    }

    protected void insertValues(Field f) {
        super.insertValues(f);
        f.put(AnchorAddress, this.anchorAddress);
        f.put(ParentAddress, this.parentAddress);
        f.put(NextAddress, this.nextAddress);
        f.put(PreviousAddress, this.previousAddress);
        f.put(NodeType, this.nodeType);
        f.put(NumberOfEntries, this.numberOfEntries);
        f.put(UsedSpace, this.usedSpace);
        f.put(UsedSpaceMax, this.usedSpaceMax);
        f.put(EntriesField, this.entriesField);
    }

    void destroyChildren() throws IndexedStoreException {
        if (!this.isLeaf()) {
            int i = 0;
            while (i < this.numberOfEntries) {
                ObjectAddress childNodeAddress = new ObjectAddress(this.getValue(i));
                IndexNode childNode = this.acquireNode(childNodeAddress);
                childNode.destroyChildren();
                childNode.release();
                this.removeObject(childNodeAddress);
                ++i;
            }
        }
    }

    void find(byte[] key, IndexCursor cursor) throws IndexedStoreException {
        int i = this.findLastEntryLT(key);
        if (this.isLeaf()) {
            cursor.set(this.address, i + 1);
        } else if (i >= 0) {
            IndexNode childNode = this.acquireNode(new ObjectAddress(this.getValue(i)));
            childNode.find(key, cursor);
            childNode.release();
        } else if (this.numberOfEntries > 0) {
            IndexNode childNode = this.acquireNode(new ObjectAddress(this.getValue(0)));
            childNode.find(key, cursor);
            childNode.release();
        } else {
            cursor.reset();
        }
    }

    void findFirstEntry(IndexCursor cursor) throws IndexedStoreException {
        if (this.numberOfEntries == 0) {
            cursor.reset();
        } else if (!this.isLeaf()) {
            IndexNode childNode = this.acquireNode(new ObjectAddress(this.getValue(0)));
            childNode.findFirstEntry(cursor);
            childNode.release();
        } else {
            cursor.set(this.address, 0);
        }
    }

    private int findFirstEntryGT(byte[] key) throws IndexedStoreException {
        int lo = 0;
        int hi = this.numberOfEntries - 1;
        while (lo <= hi) {
            int i = (lo + hi) / 2;
            int c = this.compareEntryToKey(i, key);
            if (c <= 0) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return lo;
    }

    void findLastEntry(IndexCursor cursor) throws IndexedStoreException {
        if (this.numberOfEntries == 0) {
            cursor.reset();
            return;
        }
        int i = this.numberOfEntries - 1;
        if (!this.isLeaf()) {
            IndexNode childNode = this.acquireNode(new ObjectAddress(this.getValue(i)));
            childNode.findLastEntry(cursor);
            childNode.release();
        } else {
            cursor.set(this.address, i);
        }
    }

    private int findLastEntryLT(byte[] key) throws IndexedStoreException {
        int lo = 0;
        int hi = this.numberOfEntries - 1;
        while (lo <= hi) {
            int i = (lo + hi) / 2;
            int c = this.compareEntryToKey(i, key);
            if (c < 0) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return hi;
    }

    ObjectAddress getAnchorAddress() {
        return this.anchorAddress;
    }

    private Field getDescriptor(int i) {
        return this.entriesField.subfield(i * 6, 6);
    }

    private FieldArray getDescriptorArray() {
        return this.entriesField.pointTo(0).getArray(6, 6, this.numberOfEntries);
    }

    private Field getEntriesField() {
        return this.entriesField;
    }

    byte[] getKey(int i) {
        return this.getKeyField(i).get();
    }

    private Field getKeyField(int i) {
        Field descriptor = this.getDescriptor(i);
        int keyOffset = descriptor.subfield(0, 2).getUInt();
        int keyLength = descriptor.subfield(2, 2).getUInt();
        return this.entriesField.subfield(keyOffset, keyLength);
    }

    private Field getKeyValueField(int i) {
        Field descriptor = this.getDescriptor(i);
        int offset = descriptor.subfield(0, 2).getUInt();
        int keyLength = descriptor.subfield(2, 2).getUInt();
        int valueLength = descriptor.subfield(4, 2).getUInt();
        return this.entriesField.subfield(offset, keyLength + valueLength);
    }

    private byte[] getLowKey() {
        if (this.numberOfEntries == 0) {
            return new byte[0];
        }
        return this.getKey(0);
    }

    protected int getMinimumSize() {
        return 7612;
    }

    ObjectAddress getNextAddress() {
        return this.nextAddress;
    }

    private int getNodeType() {
        return this.nodeType;
    }

    int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    int getNumberOfNodes() throws IndexedStoreException {
        if (this.isLeaf()) {
            return 1;
        }
        int sum = 0;
        int i = 0;
        while (i < this.numberOfEntries) {
            ObjectAddress childAddress = new ObjectAddress(this.getValue(i));
            IndexNode childNode = this.acquireNode(childAddress);
            sum += childNode.getNumberOfNodes();
            childNode.release();
            ++i;
        }
        return sum + 1;
    }

    ObjectAddress getParentAddress() {
        return this.parentAddress;
    }

    ObjectAddress getPreviousAddress() {
        return this.previousAddress;
    }

    protected int getRequiredType() {
        return 3;
    }

    private int getUsedSpace() {
        return this.usedSpace;
    }

    private int getUsedSpaceMax() {
        return this.usedSpaceMax;
    }

    byte[] getValue(int i) {
        return this.getValueField(i).get();
    }

    private Field getValueField(int i) {
        Field descriptor = this.getDescriptor(i);
        int keyOffset = descriptor.subfield(0, 2).getUInt();
        int keyLength = descriptor.subfield(2, 2).getUInt();
        int valueLength = descriptor.subfield(4, 2).getUInt();
        int valueOffset = keyOffset + keyLength;
        return this.entriesField.subfield(valueOffset, valueLength);
    }

    void insertEntry(byte[] key, byte[] value) throws IndexedStoreException {
        int i = this.findFirstEntryGT(key);
        if (this.isLeaf()) {
            this.insertEntryBefore(i, key, value);
            Object[] cursorArray = ((AbstractCollection)this.cursors).toArray();
            int j = 0;
            while (j < cursorArray.length) {
                IndexCursor cursor = (IndexCursor)cursorArray[j];
                cursor.entryInserted(i);
                ++j;
            }
            IndexAnchor anchor = this.acquireAnchor(this.anchorAddress);
            anchor.entryInserted(this);
            anchor.release();
        } else {
            IndexNode childNode;
            ObjectAddress childNodeAddress = null;
            if (this.getNumberOfEntries() == 0) {
                childNode = new IndexNode(this.anchorAddress, this.address, ObjectAddress.Null, ObjectAddress.Null);
                childNodeAddress = this.insertObject(childNode);
            } else {
                childNodeAddress = new ObjectAddress(this.getValue(Math.max(0, i - 1)));
            }
            childNode = this.acquireNode(childNodeAddress);
            childNode.insertEntry(key, value);
            childNode.release();
        }
    }

    private void insertEntryBefore(int i, byte[] key, byte[] value) throws IndexedStoreException {
        int keyValueLength;
        int neededSpace;
        Field entries = this.entriesField;
        int entriesLength = entries.length();
        int freeSpace = entriesLength - (this.numberOfEntries * 6 + this.usedSpace);
        if (freeSpace < (neededSpace = (keyValueLength = key.length + value.length) + 6)) {
            ObjectAddress newNodeAddress = this.split();
            if (i > this.numberOfEntries) {
                if (!this.isLeaf()) {
                    ObjectAddress childAddress = new ObjectAddress(value);
                    IndexNode child = this.acquireNode(childAddress);
                    child.setParentAddress(newNodeAddress);
                    child.release();
                }
                IndexNode newNode = this.acquireNode(newNodeAddress);
                newNode.insertEntryBefore(i - this.getNumberOfEntries(), key, value);
                newNode.release();
            } else {
                this.insertEntryBefore(i, key, value);
            }
            return;
        }
        this.compress(neededSpace);
        Pointer p = entries.pointTo(entriesLength - this.usedSpaceMax);
        p.dec(value.length).put(value);
        p.dec(key.length).put(key);
        this.usedSpaceMax += keyValueLength;
        this.usedSpace += keyValueLength;
        Field newDescriptor = this.getDescriptorArray().insert(i);
        ++this.numberOfEntries;
        newDescriptor.subfield(0, 2).put(entriesLength - this.usedSpaceMax);
        newDescriptor.subfield(2, 2).put(key.length);
        newDescriptor.subfield(4, 2).put(value.length);
        if (i == 0 && !this.parentAddress.isNull()) {
            IndexNode parent = this.acquireNode(this.parentAddress);
            if (this.numberOfEntries == 1) {
                parent.insertKeyForChild(this.address, key);
            } else {
                parent.updateKeyForChild(this.getKey(1), this.address, key);
            }
            parent.release();
        }
        this.setChanged();
    }

    private void insertKeyForChild(ObjectAddress childAddress, byte[] key) throws IndexedStoreException {
        int i = this.findFirstEntryGT(key);
        this.insertEntryBefore(i, key, childAddress.toByteArray());
        if (i == 0 && !this.parentAddress.isNull()) {
            IndexNode parent = this.acquireNode(this.parentAddress);
            parent.updateKeyForChild(this.getKey(1), this.address, key);
            parent.release();
        }
    }

    boolean isInterior() {
        return this.nodeType == 2;
    }

    boolean isLeaf() {
        return this.nodeType == 3;
    }

    boolean isRoot() {
        return this.nodeType == 1;
    }

    protected void extractValues(Field f) throws ObjectStoreException {
        super.extractValues(f);
        this.anchorAddress = new ObjectAddress(f.get(AnchorAddress));
        this.parentAddress = new ObjectAddress(f.get(ParentAddress));
        this.nextAddress = new ObjectAddress(f.get(NextAddress));
        this.previousAddress = new ObjectAddress(f.get(PreviousAddress));
        this.nodeType = f.getInt(NodeType);
        this.numberOfEntries = f.getInt(NumberOfEntries);
        this.usedSpace = f.getInt(UsedSpace);
        this.usedSpaceMax = f.getInt(UsedSpaceMax);
        this.entriesField = new Field(f.get(EntriesField));
    }

    void removeCursor(IndexCursor cursor) {
        this.cursors.remove(cursor);
    }

    void removeEntry(int i) throws IndexedStoreException {
        byte[] key = this.getKey(i);
        Field f = this.getKeyValueField(i);
        f.clear();
        this.usedSpace -= f.length();
        this.getDescriptorArray().remove(i);
        --this.numberOfEntries;
        if (i == 0 && !this.parentAddress.isNull()) {
            IndexNode parent = this.acquireNode(this.parentAddress);
            if (this.numberOfEntries > 0) {
                parent.updateKeyForChild(key, this.address, this.getKey(0));
            } else {
                parent.removeKeyForChild(this.address);
            }
            parent.release();
        }
        Object[] cursorArray = ((AbstractCollection)this.cursors).toArray();
        int j = 0;
        while (j < cursorArray.length) {
            IndexCursor cursor = (IndexCursor)cursorArray[j];
            cursor.entryRemoved(i);
            ++j;
        }
        IndexAnchor anchor = this.acquireAnchor(this.anchorAddress);
        anchor.entryRemoved(this);
        anchor.release();
        this.setChanged();
    }

    private void removeKeyForChild(ObjectAddress childAddress) throws IndexedStoreException {
        Field childAddressField = new Field(childAddress);
        int i = 0;
        while (i < this.numberOfEntries) {
            if (this.getValueField(i).compareTo(childAddressField) == 0) break;
            ++i;
        }
        if (i < this.numberOfEntries) {
            this.removeEntry(i);
        }
    }

    private void setAnchorAddress(ObjectAddress address) {
        this.anchorAddress = address;
        this.setChanged();
    }

    private void setNextAddress(ObjectAddress address) {
        this.nextAddress = address;
        this.setChanged();
    }

    private void setNodeType(int nodeType) {
        this.nodeType = nodeType;
        this.setChanged();
    }

    private void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
        this.setChanged();
    }

    private void setParentAddress(ObjectAddress address) {
        this.parentAddress = address;
        this.setChanged();
    }

    private void setPreviousAddress(ObjectAddress address) {
        this.previousAddress = address;
        this.setChanged();
    }

    private void setUsedSpace(int usedSpace) {
        this.usedSpace = usedSpace;
        this.setChanged();
    }

    private void setUsedSpaceMax(int usedSpaceMax) {
        this.usedSpaceMax = usedSpaceMax;
        this.setChanged();
    }

    private ObjectAddress split() throws IndexedStoreException {
        int n = this.numberOfEntries;
        if (n < 2) {
            throw new IndexedStoreException(7);
        }
        if (this.isRoot()) {
            ObjectAddress newRootNodeAddress;
            this.parentAddress = newRootNodeAddress = this.insertObject(new IndexNode(this.anchorAddress));
            this.nodeType = 2;
            IndexNode newRootNode = this.acquireNode(newRootNodeAddress);
            newRootNode.insertKeyForChild(this.address, this.getLowKey());
            newRootNode.release();
            IndexAnchor anchor = this.acquireAnchor(this.anchorAddress);
            anchor.setRootNodeAddress(newRootNodeAddress);
            anchor.release();
        }
        ObjectAddress newNodeAddress = this.insertObject(new IndexNode(this.anchorAddress, this.parentAddress));
        IndexNode newNode = this.acquireNode(newNodeAddress);
        Field f1 = this.entriesField;
        Field f2 = newNode.getEntriesField();
        int k = n / 2;
        newNode.setUsedSpace(IndexNode.copyEntries(f1, n - k, k, f2));
        newNode.setUsedSpaceMax(newNode.getUsedSpace());
        newNode.setNumberOfEntries(k);
        this.usedSpace -= newNode.getUsedSpace();
        this.numberOfEntries = n - k;
        this.compress();
        if (this.isLeaf()) {
            newNode.setNodeType(3);
            newNode.setNextAddress(this.nextAddress);
            newNode.setPreviousAddress(this.address);
            if (!this.nextAddress.isNull()) {
                IndexNode nextNode = this.acquireNode(this.nextAddress);
                nextNode.setPreviousAddress(newNodeAddress);
                nextNode.release();
            }
            this.nextAddress = newNodeAddress;
        }
        if (!this.isLeaf()) {
            int i = 0;
            while (i < k) {
                ObjectAddress childAddress = new ObjectAddress(newNode.getValue(i));
                IndexNode childNode = this.acquireNode(childAddress);
                childNode.setParentAddress(newNodeAddress);
                childNode.release();
                ++i;
            }
        }
        IndexNode parentNode = this.acquireNode(this.parentAddress);
        parentNode.insertKeyForChild(newNodeAddress, newNode.getLowKey());
        parentNode.release();
        newNode.release();
        Object[] cursorArray = ((AbstractCollection)this.cursors).toArray();
        int j = 0;
        while (j < cursorArray.length) {
            IndexCursor cursor = (IndexCursor)cursorArray[j];
            cursor.nodeSplit();
            ++j;
        }
        this.setChanged();
        return newNodeAddress;
    }

    void unlink() throws IndexedStoreException {
        if (this.isRoot()) {
            IndexAnchor anchor = this.acquireAnchor(this.anchorAddress);
            anchor.setRootNodeAddress(ObjectAddress.Null);
            anchor.release();
        }
        if (!this.parentAddress.isNull()) {
            IndexNode parent = this.acquireNode(this.parentAddress);
            parent.removeKeyForChild(this.address);
            parent.release();
        }
        if (!this.nextAddress.isNull()) {
            IndexNode next = this.acquireNode(this.nextAddress);
            next.setPreviousAddress(this.previousAddress);
            next.release();
        }
        if (!this.previousAddress.isNull()) {
            IndexNode previous = this.acquireNode(this.previousAddress);
            previous.setNextAddress(this.nextAddress);
            previous.release();
        }
    }

    private void updateEntry(int i, byte[] key, byte[] value) throws IndexedStoreException {
        int oldKeyValueLength;
        int newKeyValueLength;
        int neededSpace;
        Field entries = this.entriesField;
        int entriesLength = entries.length();
        int freeSpace = entriesLength - (this.numberOfEntries * 6 + this.usedSpace);
        if (freeSpace < (neededSpace = (newKeyValueLength = key.length + value.length) - (oldKeyValueLength = this.getKeyValueField(i).length()))) {
            ObjectAddress newNodeAddress = this.split();
            if (i >= this.numberOfEntries) {
                IndexNode newNode = this.acquireNode(newNodeAddress);
                newNode.updateEntry(i - this.getNumberOfEntries(), key, value);
                newNode.release();
            } else {
                this.updateEntry(i, key, value);
            }
            return;
        }
        Field keyValueField = this.getKeyValueField(i);
        keyValueField.clear();
        Field descriptor = this.getDescriptor(i);
        descriptor.clear();
        this.usedSpace -= oldKeyValueLength;
        this.compress(newKeyValueLength);
        Pointer p = entries.pointTo(entriesLength - this.usedSpaceMax);
        p.dec(value.length).put(value);
        p.dec(key.length).put(key);
        this.usedSpaceMax += newKeyValueLength;
        this.usedSpace += newKeyValueLength;
        descriptor.subfield(0, 2).put(entriesLength - this.usedSpaceMax);
        descriptor.subfield(2, 2).put(key.length);
        descriptor.subfield(4, 2).put(value.length);
        this.setChanged();
    }

    private void updateKeyAt(int i, byte[] key) throws IndexedStoreException {
        this.updateEntry(i, key, this.getValue(i));
    }

    private void updateKeyForChild(byte[] key, ObjectAddress childAddress, byte[] newKey) throws IndexedStoreException {
        Field childAddressField = new Field(childAddress.toByteArray());
        int i = this.findLastEntryLT(key) + 1;
        while (i < this.numberOfEntries) {
            if (this.getValueField(i).compareTo(childAddressField) == 0) break;
            ++i;
        }
        if (i < this.numberOfEntries) {
            this.updateKeyAt(i, newKey);
            if (i == 0 && !this.parentAddress.isNull()) {
                IndexNode parent = this.acquireNode(this.parentAddress);
                parent.updateKeyForChild(key, this.address, newKey);
                parent.release();
            }
        }
    }

    void updateValueAt(int i, byte[] value) throws IndexedStoreException {
        this.updateEntry(i, this.getKey(i), value);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.isLeaf()) {
            b.append("LeafNode");
        }
        if (this.isRoot()) {
            b.append("RootNode");
        }
        if (this.isInterior()) {
            b.append("InteriorNode");
        }
        b.append("\n  Address = ");
        b.append(this.address);
        b.append("\n  AnchorAddress = ");
        b.append(this.anchorAddress);
        b.append("\n  ParentAddress = ");
        b.append(this.parentAddress);
        b.append("\n  PreviousAddress = ");
        b.append(this.previousAddress);
        b.append("\n  NextAddress = ");
        b.append(this.nextAddress);
        b.append("\n  NumberOfEntries = ");
        b.append(this.numberOfEntries);
        b.append("\n  UsedSpace = ");
        b.append(this.usedSpace);
        b.append("\n  UsedSpaceMax = ");
        b.append(this.usedSpaceMax);
        return b.toString();
    }
}

