/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.DOMOrder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOM2Helper
extends DOMHelper {
    private Document m_doc;

    public void checkNode(Node node) throws TransformerException {
    }

    public Document getDocument() {
        return this.m_doc;
    }

    public Element getElementByID(String id, Document doc) {
        return doc.getElementById(id);
    }

    public String getLocalNameOfNode(Node n) {
        String name = n.getLocalName();
        return name == null ? super.getLocalNameOfNode(n) : name;
    }

    public String getNamespaceOfNode(Node n) {
        return n.getNamespaceURI();
    }

    public static Node getParentOfNode(Node node) {
        Node parent = node.getParentNode();
        if (parent == null && node.getNodeType() == 2) {
            parent = ((Attr)node).getOwnerElement();
        }
        return parent;
    }

    public static boolean isNodeAfter(Node node1, Node node2) {
        if (node1 instanceof DOMOrder && node2 instanceof DOMOrder) {
            int index2;
            int index1 = ((DOMOrder)node1).getUid();
            return index1 <= (index2 = ((DOMOrder)node2).getUid());
        }
        return DOMHelper.isNodeAfter(node1, node2);
    }

    public void parse(InputSource source) throws TransformerException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(true);
            DocumentBuilder parser = builderFactory.newDocumentBuilder();
            parser.setErrorHandler(new DefaultErrorHandler());
            this.setDocument(parser.parse(source));
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        catch (ParserConfigurationException pce) {
            throw new TransformerException(pce);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
    }

    public void setDocument(Document doc) {
        this.m_doc = doc;
    }

    public boolean supportsSAX() {
        return true;
    }
}

