/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.DecimalFormatProperties;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.TemplateList;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private Hashtable m_availElems;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    private ElemTemplate m_startRule;
    XPath m_selectDefault;
    private ComposeState m_composeState;

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = new XPath("node()", (SourceLocator)this, (PrefixResolver)this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException se) {
            throw new TransformerConfigurationException(XSLMessages.createMessage((int)144, null), se);
        }
    }

    public StylesheetRoot(XSLTSchema schema, ErrorListener listener) throws TransformerConfigurationException {
        this(listener);
        this.m_availElems = schema.getElemsAvailable();
    }

    /*
     * Unable to fully structure code
     */
    private void QuickSort2(Vector v, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            midNode = (ElemTemplateElement)v.elementAt((lo0 + hi0) / 2);
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < hi0 && ((ElemTemplateElement)v.elementAt(lo)).compareTo(midNode) < 0) continue block0;
                    while (hi > lo0 && ((ElemTemplateElement)v.elementAt(hi)).compareTo(midNode) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    node = (ElemTemplateElement)v.elementAt(lo);
                    v.setElementAt(v.elementAt(hi), lo);
                    v.setElementAt(node, hi);
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.QuickSort2(v, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort2(v, lo, hi0);
            }
        }
    }

    static /* synthetic */ Vector access$0(StylesheetRoot $0) {
        return $0.m_variables;
    }

    protected void addImports(Stylesheet stylesheet, boolean addToList, Vector importList) {
        int i;
        int n = stylesheet.getImportCount();
        if (n > 0) {
            i = 0;
            while (i < n) {
                StylesheetComposed imported = stylesheet.getImport(i);
                this.addImports(imported, true, importList);
                ++i;
            }
        }
        if ((n = stylesheet.getIncludeCount()) > 0) {
            i = 0;
            while (i < n) {
                Stylesheet included = stylesheet.getInclude(i);
                this.addImports(included, false, importList);
                ++i;
            }
        }
        if (addToList) {
            importList.addElement(stylesheet);
        }
    }

    public boolean canStripWhiteSpace() {
        return this.m_whiteSpaceInfoList != null;
    }

    private void clearComposeState() {
        this.m_composeState = null;
    }

    void composeTemplates(ElemTemplateElement templ) throws TransformerException {
        templ.compose(this);
        ElemTemplateElement child = templ.getFirstChildElem();
        while (child != null) {
            this.composeTemplates(child);
            child = child.getNextSiblingElem();
        }
        templ.endCompose(this);
    }

    public Vector getAttributeSetComposed(QName name) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(name);
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    ComposeState getComposeState() {
        return this.m_composeState;
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName name) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(name);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public StylesheetComposed getGlobalImport(int i) {
        return this.m_globalImportList[i];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed sheet) {
        if (this == sheet) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        int i = 0;
        while (i < n) {
            if (sheet == this.getGlobalImport(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    public NamespaceAlias getNamespaceAliasComposed(String uri) {
        return this.m_namespaceAliasComposed == null ? null : this.m_namespaceAliasComposed.get(uri);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getDefaultOutputProps()).clone();
    }

    public final ElemTemplate getStartRule() {
        return this.m_startRule;
    }

    public ElemTemplate getTemplateComposed(QName qname) {
        return this.m_templateList.getTemplate(qname);
    }

    public ElemTemplate getTemplateComposed(XPathContext xctxt, int targetNode, QName mode, int maxImportLevel, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        return this.m_templateList.getTemplate(xctxt, targetNode, mode, maxImportLevel, quietConflictWarnings, dtm);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public ElemVariable getVariableOrParamComposed(QName qname) {
        if (this.m_variables != null) {
            int n = this.m_variables.size();
            int i = 0;
            while (i < n) {
                ElemVariable var = (ElemVariable)this.m_variables.elementAt(i);
                if (var.getName().equals((Object)qname)) {
                    return var;
                }
                ++i;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext support, int targetElement, DTM dtm) throws TransformerException {
        if (this.m_whiteSpaceInfoList != null) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false, dtm);
        }
        return null;
    }

    void initComposeState() {
        this.m_composeState = new ComposeState(this);
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet((Stylesheet)this);
        XPath defMatch = new XPath("*", (SourceLocator)this, (PrefixResolver)this, 1, errorListener);
        this.m_defaultRule.setMatch(defMatch);
        ElemApplyTemplates childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        childrenElement.setSelect(this.m_selectDefault);
        this.m_defaultRule.appendChild((ElemTemplateElement)childrenElement);
        this.m_startRule = this.m_defaultRule;
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet((Stylesheet)this);
        defMatch = new XPath("text() | @*", (SourceLocator)this, (PrefixResolver)this, 1, errorListener);
        this.m_defaultTextRule.setMatch(defMatch);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild((ElemTemplateElement)elemValueOf);
        XPath selectPattern = new XPath(".", (SourceLocator)this, (PrefixResolver)this, 0, errorListener);
        elemValueOf.setSelect(selectPattern);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet((Stylesheet)this);
        defMatch = new XPath("/", (SourceLocator)this, (PrefixResolver)this, 1, errorListener);
        this.m_defaultRootRule.setMatch(defMatch);
        childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild((ElemTemplateElement)childrenElement);
        childrenElement.setSelect(this.m_selectDefault);
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    public boolean isRoot() {
        return true;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public void recompose() throws TransformerException {
        if (this.m_globalImportList == null) {
            Vector importList = new Vector();
            this.addImports(this, true, importList);
            this.m_globalImportList = new StylesheetComposed[importList.size()];
            int i = importList.size() - 1;
            int j = 0;
            while (i >= 0) {
                this.m_globalImportList[j++] = (StylesheetComposed)importList.elementAt(i);
                --i;
            }
        }
        Vector recomposableElements = new Vector();
        int n = this.getGlobalImportCount();
        int i = 0;
        while (i < n) {
            StylesheetComposed imported = this.getGlobalImport(i);
            imported.recompose(recomposableElements);
            ++i;
        }
        this.QuickSort2(recomposableElements, 0, recomposableElements.size() - 1);
        this.m_outputProperties = new OutputProperties("xml");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_variables = new Vector();
        int i2 = recomposableElements.size() - 1;
        while (i2 >= 0) {
            ((ElemTemplateElement)recomposableElements.elementAt(i2)).recompose(this);
            --i2;
        }
        this.initComposeState();
        this.m_templateList.compose(this);
        this.m_outputProperties.compose(this);
        this.m_outputProperties.endCompose(this);
        n = this.getGlobalImportCount();
        int i3 = 0;
        while (i3 < n) {
            StylesheetComposed imported = this.getGlobalImport(i3);
            int includedCount = imported.getIncludeCountComposed();
            int j = -1;
            while (j < includedCount) {
                Stylesheet included = imported.getIncludeComposed(j);
                this.composeTemplates(included);
                ++j;
            }
            ++i3;
        }
        this.clearComposeState();
    }

    void recomposeAttributeSets(ElemAttributeSet attrSet) {
        Vector<ElemAttributeSet> attrSetList = (Vector<ElemAttributeSet>)this.m_attrSets.get(attrSet.getName());
        if (attrSetList == null) {
            attrSetList = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(attrSet.getName(), attrSetList);
        }
        attrSetList.addElement(attrSet);
    }

    void recomposeDecimalFormats(DecimalFormatProperties dfp) {
        DecimalFormatSymbols oldDfs = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(dfp.getName());
        if (oldDfs == null) {
            this.m_decimalFormatSymbols.put(dfp.getName(), dfp.getDecimalFormatSymbols());
        } else if (!dfp.getDecimalFormatSymbols().equals(oldDfs)) {
            String themsg = dfp.getName().equals((Object)new QName("")) ? XSLMessages.createWarning((int)19, (Object[])new Object[0]) : XSLMessages.createWarning((int)20, (Object[])new Object[]{dfp.getName()});
            this.error(themsg);
        }
    }

    void recomposeKeys(KeyDeclaration keyDecl) {
        this.m_keyDecls.addElement(keyDecl);
    }

    void recomposeNamespaceAliases(NamespaceAlias nsAlias) {
        this.m_namespaceAliasComposed.put(nsAlias.getStylesheetNamespace(), nsAlias);
    }

    void recomposeOutput(OutputProperties oprops) throws TransformerException {
        this.m_outputProperties.copyFrom(oprops);
    }

    void recomposeTemplates(ElemTemplate template) {
        this.m_templateList.setTemplate(template);
    }

    void recomposeVariables(ElemVariable elemVar) {
        if (this.getVariableOrParamComposed(elemVar.getName()) == null) {
            elemVar.setIsTopLevel(true);
            elemVar.setIndex(this.m_variables.size());
            this.m_variables.addElement(elemVar);
        }
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo wsi) {
        if (this.m_whiteSpaceInfoList == null) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate((ElemTemplate)wsi);
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public boolean shouldCheckWhitespace() {
        return this.m_whiteSpaceInfoList != null;
    }

    public boolean shouldStripWhiteSpace(XPathContext support, int targetElement) throws TransformerException {
        if (this.m_whiteSpaceInfoList != null) {
            while (targetElement != -1) {
                DTM dtm = support.getDTM(targetElement);
                WhiteSpaceInfo info = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false, dtm);
                if (info != null) {
                    return info.getShouldStripSpace();
                }
                int parent = dtm.getParent(targetElement);
                targetElement = parent != -1 && dtm.getNodeType(parent) == 1 ? parent : -1;
            }
        }
        return false;
    }
}

