/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.UnImplNode;
import org.apache.xpath.WhitespaceStrippingElementMatcher;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
SourceLocator,
WhitespaceStrippingElementMatcher {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private boolean m_hasTextLitOnly = false;
    protected boolean m_hasVariableDecl = false;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected int m_docOrderNumber = -1;
    protected ElemTemplateElement m_parentNode;
    ElemTemplateElement m_nextSibling;
    ElemTemplateElement m_firstChild;
    private transient Node m_DOMBackPointer;

    void addOrReplaceDecls(XMLNSDecl newDecl) {
        int n = this.m_prefixTable.size();
        int i = n - 1;
        while (i >= 0) {
            XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
            if (decl.getPrefix().equals(newDecl.getPrefix())) {
                return;
            }
            --i;
        }
        this.m_prefixTable.addElement(newDecl);
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elem) {
        if (elem == null) {
            this.error(20, null);
        }
        if (this.m_firstChild == null) {
            this.m_firstChild = elem;
        } else {
            ElemTemplateElement last = this.getLastChildElem();
            last.m_nextSibling = elem;
        }
        elem.setParentElem(this);
        return elem;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (newChild == null) {
            this.error(20, null);
        }
        ElemTemplateElement elem = (ElemTemplateElement)newChild;
        if (this.m_firstChild == null) {
            this.m_firstChild = elem;
        } else {
            ElemTemplateElement last = (ElemTemplateElement)this.getLastChild();
            last.m_nextSibling = elem;
        }
        elem.m_parentNode = this;
        return newChild;
    }

    public boolean canStripWhiteSpace() {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return sroot != null ? sroot.canStripWhiteSpace() : false;
    }

    public int compareTo(Object o) throws ClassCastException {
        ElemTemplateElement ro = (ElemTemplateElement)o;
        int roPrecedence = ro.getStylesheetComposed().getImportCountComposed();
        int myPrecedence = this.getStylesheetComposed().getImportCountComposed();
        if (myPrecedence < roPrecedence) {
            return -1;
        }
        if (myPrecedence > roPrecedence) {
            return 1;
        }
        return this.getUid() - ro.getUid();
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        this.resolvePrefixTables();
        ElemTemplateElement t = this.getFirstChildElem();
        this.m_hasTextLitOnly = t != null && t.getXSLToken() == 78 && t.getNextSiblingElem() == null;
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        cstate.pushStackMark();
    }

    public boolean containsExcludeResultPrefix(String prefix, String uri) {
        ElemTemplateElement parent = this.getParentElem();
        if (parent != null) {
            return parent.containsExcludeResultPrefix(prefix, uri);
        }
        return false;
    }

    public void endCompose(StylesheetRoot sroot) throws TransformerException {
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        cstate.popStackMark();
    }

    public void error(int msg) {
        this.error(msg, null);
    }

    public void error(int msg, Object[] args) {
        String themsg = XSLMessages.createMessage((int)msg, (Object[])args);
        this.error(XSLMessages.createMessage((int)19, (Object[])new Object[]{themsg}));
    }

    public void error(String msg) {
        throw new RuntimeException(msg);
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (uri != null) {
            if (uri.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(uri) || uri.equals("http://xml.apache.org/xslt")) {
                return true;
            }
            if (this.containsExcludeResultPrefix(prefix, uri)) {
                return true;
            }
        }
        return false;
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
    }

    void executeNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (this.m_prefixTable != null) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int i = n - 1;
                while (i >= 0) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (!decl.getIsExcluded()) {
                        rhandler.startPrefixMapping(decl.getPrefix(), decl.getURI(), true);
                    }
                    --i;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement lastChild = null;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            lastChild = node;
            node = node.m_nextSibling;
        }
        return lastChild;
    }

    public ElemTemplateElement getLastChildElem() {
        ElemTemplateElement lastChild = null;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            lastChild = node;
            node = node.m_nextSibling;
        }
        return lastChild;
    }

    public int getLength() {
        int count = 0;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            ++count;
            node = node.m_nextSibling;
        }
        return count;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getNamespaceForPrefix(String prefix) {
        Vector nsDecls = this.m_declaredPrefixes;
        if (nsDecls != null) {
            int n = nsDecls.size();
            int i = 0;
            while (i < n) {
                XMLNSDecl decl = (XMLNSDecl)nsDecls.elementAt(i);
                if (prefix.equals(decl.getPrefix())) {
                    return decl.getURI();
                }
                ++i;
            }
        }
        if (this.m_parentNode != null) {
            return this.m_parentNode.getNamespaceForPrefix(prefix);
        }
        return null;
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        this.error(16, null);
        return null;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public short getNodeType() {
        return 1;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public ElemTemplateElement getParentNodeElem() {
        return this.m_parentNode;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    public Node getPreviousSibling() {
        Node walker = this.getParentNode();
        Node prev = null;
        if (walker != null) {
            walker = walker.getFirstChild();
            while (walker != null) {
                if (walker == this) {
                    return prev;
                }
                prev = walker;
                walker = walker.getNextSibling();
            }
        }
        return null;
    }

    public ElemTemplateElement getPreviousSiblingElem() {
        ElemTemplateElement walker = this.getParentNodeElem();
        ElemTemplateElement prev = null;
        if (walker != null) {
            walker = walker.getFirstChildElem();
            while (walker != null) {
                if (walker == this) {
                    return prev;
                }
                prev = walker;
                walker = walker.getNextSiblingElem();
            }
        }
        return null;
    }

    public String getPublicId() {
        return this.m_parentNode != null ? this.m_parentNode.getPublicId() : null;
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public int getUid() {
        return this.m_docOrderNumber;
    }

    public int getXSLToken() {
        return -1;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public boolean hasChildNodes() {
        return this.m_firstChild != null;
    }

    public boolean hasTextLitOnly() {
        return this.m_hasTextLitOnly;
    }

    public boolean hasVariableDecl() {
        return this.m_hasVariableDecl;
    }

    public boolean isCompiledTemplate() {
        return false;
    }

    protected boolean isValidNCName(String s) {
        int len = s.length();
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        if (len > 0) {
            int i = 1;
            while (i < len) {
                c = s.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public Node item(int index) {
        ElemTemplateElement node = this.m_firstChild;
        int i = 0;
        while (i < index && node != null) {
            node = node.m_nextSibling;
            ++i;
        }
        return node;
    }

    boolean needToCheckExclude() {
        return false;
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
    }

    public ElemTemplateElement removeChild(ElemTemplateElement childETE) {
        if (childETE == null || childETE.m_parentNode != this) {
            return null;
        }
        if (childETE == this.m_firstChild) {
            this.m_firstChild = childETE.m_nextSibling;
        } else {
            ElemTemplateElement prev = childETE.getPreviousSiblingElem();
            prev.m_nextSibling = childETE.m_nextSibling;
        }
        childETE.m_parentNode = null;
        childETE.m_nextSibling = null;
        return childETE;
    }

    public ElemTemplateElement replaceChild(ElemTemplateElement newChildElem, ElemTemplateElement oldChildElem) {
        if (oldChildElem == null || oldChildElem.getParentElem() != this) {
            return null;
        }
        ElemTemplateElement prev = oldChildElem.getPreviousSiblingElem();
        if (prev != null) {
            prev.m_nextSibling = newChildElem;
        }
        if (this.m_firstChild == oldChildElem) {
            this.m_firstChild = newChildElem;
        }
        newChildElem.m_parentNode = this;
        oldChildElem.m_parentNode = null;
        newChildElem.m_nextSibling = oldChildElem.m_nextSibling;
        oldChildElem.m_nextSibling = null;
        return newChildElem;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild == null || oldChild.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement newChildElem = (ElemTemplateElement)newChild;
        ElemTemplateElement oldChildElem = (ElemTemplateElement)oldChild;
        ElemTemplateElement prev = (ElemTemplateElement)oldChildElem.getPreviousSibling();
        if (prev != null) {
            prev.m_nextSibling = newChildElem;
        }
        if (this.m_firstChild == oldChildElem) {
            this.m_firstChild = newChildElem;
        }
        newChildElem.m_parentNode = this;
        oldChildElem.m_parentNode = null;
        newChildElem.m_nextSibling = oldChildElem.m_nextSibling;
        oldChildElem.m_nextSibling = null;
        return newChildElem;
    }

    public void resolvePrefixTables() throws TransformerException {
        ElemTemplateElement parent;
        this.m_prefixTable = null;
        if (this.m_declaredPrefixes != null) {
            StylesheetRoot stylesheet = this.getStylesheetRoot();
            int n = this.m_declaredPrefixes.size();
            int i = 0;
            while (i < n) {
                NamespaceAlias nsAlias;
                XMLNSDecl decl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(i);
                String prefix = decl.getPrefix();
                String uri = decl.getURI();
                if (uri == null) {
                    uri = "";
                }
                boolean shouldExclude = this.excludeResultNSDecl(prefix, uri);
                if (this.m_prefixTable == null) {
                    this.m_prefixTable = new Vector();
                }
                decl = (nsAlias = stylesheet.getNamespaceAliasComposed(uri)) != null ? new XMLNSDecl(nsAlias.getStylesheetPrefix(), nsAlias.getResultNamespace(), shouldExclude) : new XMLNSDecl(prefix, uri, shouldExclude);
                this.m_prefixTable.addElement(decl);
                ++i;
            }
        }
        if ((parent = this.getParentNodeElem()) != null) {
            Vector prefixes = parent.m_prefixTable;
            if (this.m_prefixTable == null && !this.needToCheckExclude()) {
                this.m_prefixTable = parent.m_prefixTable;
            } else {
                int n = prefixes.size();
                int i = 0;
                while (i < n) {
                    XMLNSDecl decl = (XMLNSDecl)prefixes.elementAt(i);
                    boolean shouldExclude = this.excludeResultNSDecl(decl.getPrefix(), decl.getURI());
                    if (shouldExclude != decl.getIsExcluded()) {
                        decl = new XMLNSDecl(decl.getPrefix(), decl.getURI(), shouldExclude);
                    }
                    this.addOrReplaceDecls(decl);
                    ++i;
                }
            }
        } else if (this.m_prefixTable == null) {
            this.m_prefixTable = new Vector();
        }
    }

    public void runtimeInit(TransformerImpl transformer) throws TransformerException {
    }

    public void setDOMBackPointer(Node n) {
        this.m_DOMBackPointer = n;
    }

    public void setLocaterInfo(SourceLocator locator) {
        this.m_lineNumber = locator.getLineNumber();
        this.m_columnNumber = locator.getColumnNumber();
    }

    public void setParentElem(ElemTemplateElement p) {
        this.m_parentNode = p;
    }

    public void setPrefixes(NamespaceSupport nsSupport) throws TransformerException {
        this.setPrefixes(nsSupport, false);
    }

    public void setPrefixes(NamespaceSupport nsSupport, boolean excludeXSLDecl) throws TransformerException {
        Enumeration decls = nsSupport.getDeclaredPrefixes();
        while (decls.hasMoreElements()) {
            String prefix = (String)decls.nextElement();
            if (this.m_declaredPrefixes == null) {
                this.m_declaredPrefixes = new Vector();
            }
            String uri = nsSupport.getURI(prefix);
            if (excludeXSLDecl && uri.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl decl = new XMLNSDecl(prefix, uri, false);
            this.m_declaredPrefixes.addElement(decl);
        }
    }

    public void setUid(int i) {
        this.m_docOrderNumber = i;
    }

    public void setXmlSpace(int v) {
        this.m_defaultSpace = v == 2;
    }

    public boolean shouldStripWhiteSpace(XPathContext support, Element targetElement) throws TransformerException {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return sroot != null ? sroot.shouldStripWhiteSpace(support, targetElement) : false;
    }

    void unexecuteNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (this.m_prefixTable != null) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int i = 0;
                while (i < n) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (!decl.getIsExcluded()) {
                        rhandler.endPrefixMapping(decl.getPrefix());
                    }
                    ++i;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

