/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xalan.res.XSLMessages;

public final class WriterToUTF8Buffered
extends Writer {
    private OutputStream m_os;
    private byte[] buf;
    private int count;

    public WriterToUTF8Buffered(OutputStream out) throws UnsupportedEncodingException {
        this(out, 8192);
    }

    public WriterToUTF8Buffered(OutputStream out, int size) {
        this.m_os = out;
        if (size <= 0) {
            throw new IllegalArgumentException(XSLMessages.createMessage((int)136, null));
        }
        this.buf = new byte[size];
        this.count = 0;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void write(int c) throws IOException {
        if (c < 128) {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)c;
        } else if (c < 2048) {
            if (this.count + 1 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(192 + (c >> 6));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        } else {
            if (this.count + 2 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(224 + (c >> 12));
            this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    public void write(String s) throws IOException {
        int length = s.length();
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(s);
            return;
        }
        if (lengthx3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(chars, start, length);
            return;
        }
        if (lengthx3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    private final void writeDirect(String s) throws IOException {
        int n = s.length();
        OutputStream os = this.m_os;
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    private final void writeDirect(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }
}

