/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.PropertyUtils;

public class RequestUtils {
    private static final Locale defaultLocale = Locale.getDefault();
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.util.LocalStrings");

    public static URL absoluteURL(HttpServletRequest request, String path) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(request), request.getContextPath() + path);
    }

    public static Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)RequestUtils.lookup(pageContext, name, property, scope);
            }
        }
        catch (ClassCastException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("parameters.multi", (Object)name, (Object)property, (Object)scope));
        }
        catch (JspException e) {
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = RequestUtils.lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                RequestUtils.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String) {
                    String[] newValues = new String[]{(String)mapValue, paramString};
                    results.put(paramId, newValues);
                } else {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, Map params, String anchor, boolean redirect) throws MalformedURLException {
        String temp;
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ActionForwards forwards = (ActionForwards)pageContext.getAttribute("org.apache.struts.action.FORWARDS", 4);
            if (forwards == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forwards"));
            }
            ActionForward af = forwards.findForward(forward);
            if (af == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (af.getRedirect()) {
                redirect = true;
            }
            if (af.getPath().startsWith("/")) {
                url.append(request.getContextPath());
            }
            url.append(af.getPath());
        } else if (href != null) {
            url.append(href);
        } else {
            url.append(request.getContextPath());
            url.append(page);
        }
        if (anchor != null) {
            temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(URLEncoder.encode(anchor));
        }
        if (params != null && params.size() > 0) {
            temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append("&amp;");
                    }
                    url.append(URLEncoder.encode(key));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append("&amp;");
                    }
                    url.append(URLEncoder.encode(key));
                    url.append('=');
                    url.append(URLEncoder.encode((String)value));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    int i = 0;
                    while (i < values.length) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append("&amp;");
                        }
                        url.append(URLEncoder.encode(key));
                        url.append('=');
                        url.append(URLEncoder.encode(values[i]));
                        ++i;
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append('&');
                }
                url.append(URLEncoder.encode(key));
                url.append('=');
                url.append(URLEncoder.encode(value.toString()));
            }
            if (anchor != null) {
                url.append('#');
                url.append(anchor);
            }
        }
        if (pageContext.getSession() != null) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (redirect) {
                return response.encodeRedirectURL(url.toString());
            }
            return response.encodeURL(url.toString());
        }
        return url.toString();
    }

    public static Object lookup(PageContext pageContext, String name, String scope) throws JspException {
        Object bean = null;
        if (scope == null) {
            bean = pageContext.findAttribute(name);
        } else if (scope.equalsIgnoreCase("page")) {
            bean = pageContext.getAttribute(name, 1);
        } else if (scope.equalsIgnoreCase("request")) {
            bean = pageContext.getAttribute(name, 2);
        } else if (scope.equalsIgnoreCase("session")) {
            bean = pageContext.getAttribute(name, 3);
        } else if (scope.equalsIgnoreCase("application")) {
            bean = pageContext.getAttribute(name, 4);
        } else {
            JspException e = new JspException(messages.getMessage("lookup.scope", (Object)scope));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        return bean;
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = RequestUtils.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            RequestUtils.saveException(pageContext, t);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)name));
        }
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return RequestUtils.message(pageContext, bundle, locale, key, null);
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        Locale userLocale;
        MessageResources resources;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)pageContext.getAttribute(bundle, 4)) == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if ((userLocale = (Locale)pageContext.getAttribute(locale, 3)) == null) {
            userLocale = defaultLocale;
        }
        if (args == null) {
            return resources.getMessage(userLocale, key);
        }
        return resources.getMessage(userLocale, key, args);
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        RequestUtils.populate(bean, null, null, request);
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration names = null;
        Hashtable multipartElements = null;
        boolean isMultipart = false;
        String contentType = request.getContentType();
        String method = request.getMethod();
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            isMultipart = true;
            MultipartRequestHandler multipart = null;
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServlet servlet = ((ActionForm)bean).getServlet();
            String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
            request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
            if (multipartClass != null) {
                try {
                    multipart = (MultipartRequestHandler)Class.forName(multipartClass).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    servlet.log("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class");
                }
                catch (InstantiationException ie) {
                    servlet.log("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    servlet.log("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage());
                }
            }
            if (multipart == null) {
                try {
                    multipart = (MultipartRequestHandler)Class.forName(servlet.getMultipartClass()).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ServletException("Cannot find multipart class \"" + servlet.getMultipartClass() + "\"" + ", exception: " + cnfe.getMessage());
                }
                catch (InstantiationException ie) {
                    throw new ServletException("InstantiaionException when instantiating multipart class \"" + servlet.getMultipartClass() + "\", exception: " + ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new ServletException("IllegalAccessException when instantiating multipart class \"" + servlet.getMultipartClass() + "\", exception: " + iae.getMessage());
                }
            }
            ((ActionForm)bean).setMultipartRequestHandler(multipart);
            multipart.setServlet(servlet);
            multipart.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
            request.removeAttribute("org.apache.struts.action.mapping.instance");
            multipart.handleRequest(request);
            multipartElements = multipart.getAllElements();
            names = multipartElements.keys();
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name;
            String stripped = name = (String)names.nextElement();
            int subscript = stripped.lastIndexOf("[");
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            if (isMultipart) {
                properties.put(stripped, multipartElements.get(name));
                continue;
            }
            properties.put(stripped, request.getParameterValues(name));
        }
        try {
            BeanUtils.populate(bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
    }

    public static boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        Locale userLocale;
        MessageResources resources;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)pageContext.getAttribute(bundle, 4)) == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if ((userLocale = (Locale)pageContext.getAttribute(locale, 3)) == null) {
            userLocale = defaultLocale;
        }
        return resources.isPresent(userLocale, key);
    }

    public static String printableURL(URL url) {
        if (url.getHost() != null) {
            return url.toString();
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (ref == null) {
            return file;
        }
        StringBuffer sb = new StringBuffer(file);
        sb.append('#');
        sb.append(ref);
        return sb.toString();
    }

    public static URL requestURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getRequestURI());
        return new URL(url.toString());
    }

    public static URL serverURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return new URL(url.toString());
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }
}

