/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.IOException;
import java.io.InputStream;
import org.apache.struts.upload.ContentLengthExceededException;
import org.apache.struts.upload.MaxLengthExceededException;

public class BufferedMultipartInputStream
extends InputStream {
    protected InputStream inputStream;
    protected byte[] buffer;
    protected int bufferOffset = 0;
    protected int bufferSize = 8192;
    protected int bufferLength = 0;
    protected int totalLength = 0;
    protected long contentLength;
    protected long maxSize = -1L;
    protected boolean contentLengthMet = false;
    protected boolean maxLengthMet = false;

    public BufferedMultipartInputStream(InputStream inputStream, int bufferSize, long contentLength, long maxSize) throws IOException {
        this.inputStream = inputStream;
        this.bufferSize = bufferSize;
        this.contentLength = contentLength;
        this.maxSize = maxSize;
        if (maxSize < contentLength) {
            throw new MaxLengthExceededException(maxSize);
        }
        this.buffer = new byte[bufferSize];
        this.fill();
    }

    public int available() {
        return this.bufferLength - this.bufferOffset;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void mark(int position) {
        this.inputStream.mark(position);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public boolean maxLengthMet() {
        return this.maxLengthMet;
    }

    public boolean contentLengthMet() {
        return this.contentLengthMet;
    }

    public int read() throws IOException {
        if (this.maxLengthMet) {
            throw new MaxLengthExceededException(this.maxSize);
        }
        if (this.contentLengthMet) {
            throw new ContentLengthExceededException(this.contentLength);
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufferOffset < this.bufferLength) {
            return (char)this.buffer[this.bufferOffset++];
        }
        this.fill();
        return this.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int offset, int length) throws IOException {
        count = 0;
        read = this.read();
        if (read != -1) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            b[offset] = (byte)read;
            read = this.read();
            ++count;
            ++offset;
lbl9:
            // 2 sources

            ** while (read != -1 && count < length)
        }
lbl10:
        // 1 sources

        return count;
    }

    /*
     * Unable to fully structure code
     */
    public int readLine(byte[] b, int offset, int length) throws IOException {
        count = 0;
        read = this.read();
        if (read != -1) ** GOTO lbl10
        return -1;
        while (read != 10) {
            b[offset] = (byte)read;
            ++count;
            ++offset;
            read = this.read();
lbl10:
            // 2 sources

            if (read != -1 && count < length) continue;
        }
        return count;
    }

    public void reset() throws IOException {
        this.inputStream.reset();
    }

    protected void fill() throws IOException {
        if (this.bufferOffset > -1 && this.bufferLength > -1) {
            int length = Math.min(this.bufferSize, (int)this.contentLength + 1 - this.totalLength);
            if (length == 0) {
                this.contentLengthMet = true;
            }
            if (this.maxSize > -1L && length > 0 && (length = Math.min(length, (int)this.maxSize - this.totalLength)) == 0) {
                this.maxLengthMet = true;
            }
            int bytesRead = -1;
            if (length > 0) {
                bytesRead = this.inputStream.read(this.buffer, 0, length);
            }
            if (bytesRead == -1) {
                this.buffer = null;
                this.bufferOffset = -1;
                this.bufferLength = -1;
            } else {
                this.bufferLength = bytesRead;
                this.totalLength += bytesRead;
                this.bufferOffset = 0;
            }
        }
    }
}

