/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.relation.creation;

import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelRelationInfo;
import java.util.ArrayList;

public class ModelRelationWizardData {
    private CardinalityEnum mEnum = null;
    private CardinalityEnum[] mCardinalities = null;
    private String[] mCardinalityTexts = null;
    private String[] mTargetModelClassNames = null;
    private ModelClass[] mTargetModelClasses = null;
    private ModelRelationInfo mModelRelationInfo = null;
    private String mModelRelationName = "";
    private String mSourceRoleName = "Source";
    private String mTargetRoleName = "";
    private ModelClass mSourceModelClass = null;
    private ModelClass mTargetModelClass = null;
    private CardinalityEnum mSourceCardinality = null;
    private CardinalityEnum mTargetCardinality = null;
    private boolean mSourceNavigable = false;
    private boolean mTargetNavigable = false;
    private boolean mSourceAggregation = false;
    private boolean mTargetAggregation = false;

    public ModelRelationWizardData(ModelClass modelClass) {
        this.initializeData(modelClass);
    }

    public ModelRelationWizardData(ModelRelationInfo modelRelationInfo) {
        this.initializeData(modelRelationInfo.getSourceModelClass());
        this.mModelRelationInfo = modelRelationInfo;
        this.mModelRelationName = modelRelationInfo.getName();
        ModelRelationRole sourceRole = modelRelationInfo.getSourceRole();
        this.mSourceRoleName = sourceRole.getName();
        this.mSourceNavigable = sourceRole.getNavigable();
        this.mSourceAggregation = sourceRole.getAggregate();
        this.mSourceCardinality = sourceRole.getCardinality();
        ModelRelationRole targetRole = modelRelationInfo.getTargetRole();
        this.mTargetRoleName = targetRole.getName();
        this.mTargetModelClass = targetRole.getModelClass();
        this.mTargetNavigable = targetRole.getNavigable();
        this.mTargetAggregation = targetRole.getAggregate();
        this.mTargetCardinality = targetRole.getCardinality();
    }

    private void initializeData(ModelClass sourceModelClass) {
        this.mSourceModelClass = sourceModelClass;
        ArrayList cardinalities = CardinalityEnum.getValues();
        cardinalities.remove(CardinalityEnum.NONE);
        this.mCardinalities = cardinalities.toArray(new CardinalityEnum[cardinalities.size()]);
        this.mSourceCardinality = this.mCardinalities[0];
        this.mTargetCardinality = this.mCardinalities[0];
        this.mCardinalityTexts = new String[this.mCardinalities.length];
        int i = 0;
        while (i < this.mCardinalities.length) {
            this.mCardinalityTexts[i] = this.mCardinalities[i].getDescriptiveText();
            ++i;
        }
        this.mTargetModelClasses = ModelHelper.getModelClassesAndInterfaces((Model)this.mSourceModelClass.getModel(), (boolean)true);
        this.mTargetModelClassNames = ModelRelationWizardData.getModelClassNames(this.mTargetModelClasses);
        this.mTargetModelClass = this.mTargetModelClasses[0];
    }

    public String[] getCardinalityTexts() {
        return this.mCardinalityTexts;
    }

    public String getModelRelationName() {
        return this.mModelRelationName;
    }

    public void setModelRelationName(String name) {
        this.mModelRelationName = name;
    }

    public ModelRelationInfo getModelRelationInfo() {
        return this.mModelRelationInfo;
    }

    public String getSourceRoleName() {
        return this.mSourceRoleName;
    }

    public void setSourceRoleName(String sourceRoleName) {
        this.mSourceRoleName = sourceRoleName;
    }

    public ModelClass getSourceModelClass() {
        return this.mSourceModelClass;
    }

    public CardinalityEnum getSourceCardinality() {
        return this.mSourceCardinality;
    }

    public void setSourceCardinality(int idx) {
        if (idx >= 0 && idx < this.mCardinalities.length) {
            this.mSourceCardinality = this.mCardinalities[idx];
        }
    }

    public boolean getSourceNavigable() {
        return this.mSourceNavigable;
    }

    public void setSourceNavigable(boolean selectedSourceNavigable) {
        this.mSourceNavigable = selectedSourceNavigable;
    }

    public boolean getSourceAggregation() {
        return this.mSourceAggregation;
    }

    public void setSourceAggregation(boolean selectedSourceAggregation) {
        this.mSourceAggregation = selectedSourceAggregation;
    }

    public String[] getTargetModelClassNames() {
        return this.mTargetModelClassNames;
    }

    public String getTargetRoleName() {
        return this.mTargetRoleName;
    }

    public void setTargetRoleName(String targetRoleName) {
        this.mTargetRoleName = targetRoleName;
    }

    public ModelClass getTargetModelClass() {
        return this.mTargetModelClass;
    }

    public void setTargetModelClass(int idx) {
        if (idx >= 0 && idx < this.mTargetModelClasses.length) {
            this.mTargetModelClass = this.mTargetModelClasses[idx];
        }
    }

    public ModelClass getTargetModelClass(int idx) {
        if (idx >= 0 && idx <= this.mTargetModelClasses.length) {
            return this.mTargetModelClasses[idx];
        }
        return null;
    }

    public CardinalityEnum getTargetCardinality() {
        return this.mTargetCardinality;
    }

    public void setTargetCardinality(int idx) {
        if (idx >= 0 && idx < this.mCardinalities.length) {
            this.mTargetCardinality = this.mCardinalities[idx];
        }
    }

    public boolean getTargetNavigable() {
        return this.mTargetNavigable;
    }

    public void setTargetNavigable(boolean selectedTargetNavigable) {
        this.mTargetNavigable = selectedTargetNavigable;
    }

    public boolean getTargetAggregation() {
        return this.mTargetAggregation;
    }

    public void setTargetAggregation(boolean selectedTargetAggregation) {
        this.mTargetAggregation = selectedTargetAggregation;
    }

    public static String[] getModelClassNames(ModelClass[] modelClasses) {
        String[] modelClassNames = new String[modelClasses.length];
        int i = 0;
        while (i < modelClasses.length) {
            modelClassNames[i] = modelClasses[i].getName();
            ++i;
        }
        return modelClassNames;
    }
}

