/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.property.creation;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.modeleditor.wizards.TypeWizardData;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;

public class PropertyWizardData
extends TypeWizardData {
    private String mName = TextPool.getInstance().getText(418);
    private int mVisibility;
    private int mSelectedType;
    private DtSimpleType[] mTypes;
    private VisibilityEnum[] mVisibilities;
    private boolean mIsReadOnly = false;
    private Property mProperty;
    private ModelClass mModelClass;

    public PropertyWizardData(Property property) {
        super(property.getType(), MetamodelServices.getBuiltInScalarTypes((String)property.getRoot().getMetamodel().getName()), false);
        this.mProperty = property;
        this.mModelClass = (ModelClass)property.getParent();
        this.mName = property.getName();
        this.mIsReadOnly = property.getReadonly();
        this.mVisibilities = MetamodelServices.getVisibilityEnums();
        this.mVisibility = this.mVisibilities.length - 1;
    }

    public PropertyWizardData(ModelClass modelClass) {
        super((DevelopmentObject)MetamodelServices.getDefaultSimpleType((String)modelClass.getRoot().getMetamodel().getName()), MetamodelServices.getBuiltInScalarTypes((String)modelClass.getRoot().getMetamodel().getName()), false);
        this.mModelClass = modelClass;
        this.mVisibilities = MetamodelServices.getVisibilityEnums();
        this.mVisibility = this.mVisibilities.length - 1;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public int getTypeIndex() {
        return this.mSelectedType;
    }

    public void setVisibility(int visibiliy) {
        this.mVisibility = visibiliy;
    }

    public void setVisibility(VisibilityEnum visibility) {
        int i = 0;
        while (i < this.mVisibilities.length) {
            if (this.mVisibilities[i].equals(visibility)) {
                this.mVisibility = i;
                return;
            }
            ++i;
        }
    }

    public String getVisibilityName() {
        return this.mVisibilities[this.mVisibility].toString();
    }

    public VisibilityEnum getVisibility() {
        return this.mVisibilities[this.mVisibility];
    }

    public int getVisibilityAsInt() {
        return this.mVisibility;
    }

    public boolean getIsReadOnly() {
        return this.mIsReadOnly;
    }

    public void setIsReadOnly(boolean status) {
        this.mIsReadOnly = status;
    }

    public ModelClass getModelClass() {
        return this.mModelClass;
    }
}

