/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.property.creation;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.modeleditor.wizards.property.creation.PropertyWizardData;
import com.sap.ide.webdynpro.modeleditor.wizards.property.creation.PropertyWizardPropertiesPage;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceCreation;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PropertyWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private Property mNewProperty;
    private PropertyWizardData mData;
    private PropertyWizardPropertiesPage mPropertiesPage;

    public PropertyWizard(ModelClass modelClass) {
        this.mData = new PropertyWizardData(modelClass);
    }

    public boolean performFinish() {
        try {
            this.mNewProperty = ServiceCreation.createProperty((ModelClass)this.mData.getModelClass(), (String)this.mData.getName(), (MetamodelServices.CompoundType)this.mData.getType(), (VisibilityEnum)this.mData.getVisibility(), (boolean)this.mData.getIsReadOnly());
        }
        catch (CreateException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "performfinish", "Failed to create property ", e, false);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText(330));
    }

    public void addPages() {
        this.mPropertiesPage = new PropertyWizardPropertiesPage(this.mData);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public Property getProperty() {
        return this.mNewProperty;
    }
}

