/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.parameter.creation;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.webdynpro.modeleditor.wizards.parameter.creation.ParameterWizardData;
import com.sap.ide.webdynpro.modeleditor.wizards.parameter.creation.ParameterWizardPropertiesPage;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ParameterWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private ParameterWizardData mData;
    private ParameterWizardPropertiesPage mPropertiesPage;
    private Parameter mNewParameter;

    public ParameterWizard(ParameterizedFeature procedure) {
        this.mData = new ParameterWizardData(procedure, MetamodelServices.getDefaultSimpleType((String)procedure.getRoot().getMetamodel().getName()));
    }

    public boolean performFinish() {
        try {
            this.mNewParameter = this.mData.getProcedure().createParameter(this.mData.getName());
            MetamodelServices.setType((Parameter)this.mNewParameter, (MetamodelServices.CompoundType)this.mData.getType());
        }
        catch (CreateException e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)"Failed to create parameter ", (Throwable)e, (boolean)false);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText(322));
    }

    public void addPages() {
        this.mPropertiesPage = new ParameterWizardPropertiesPage(this.mData);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public Parameter getParameter() {
        return this.mNewParameter;
    }
}

