/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.modelclass.creation;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

public class RenameModelClassWizard
extends RenameWizard {
    private static final TextPool mTPool = TextPool.getInstance();

    public RenameModelClassWizard(ModelClass modelClass) {
        super((DevelopmentObject)modelClass);
    }

    public RenameModelClassWizard(ModelClass modelClass, String newName, String newPackage) {
        super((DevelopmentObject)modelClass, newName, newPackage);
    }

    protected String verifyDevelopmentobjectName(String nameInput, String packageInput) {
        IStatus status;
        Model parentModel;
        RenameWizardData renameWizardData = this.getWizardData();
        DevelopmentObject developmentObject = renameWizardData.getObjectToRefactor();
        if (developmentObject instanceof ModelClass && (parentModel = ((ModelClass)developmentObject).getModel()) != null) {
            if (parentModel.hasModelClass(packageInput, nameInput)) {
                return mTPool.getText(19, (Object)nameInput);
            }
            if (parentModel.getName().equals(nameInput) && parentModel.getPackage().equals(packageInput)) {
                return mTPool.getText(22);
            }
            boolean modelClassExists = parentModel.getMetamodel().objectExists(packageInput, nameInput, WebDynproMDOEnum.MODELCLASS);
            if (modelClassExists) {
                return mTPool.getText(6, (Object)nameInput, (Object)packageInput);
            }
        }
        if ((status = CheckServices.isValidMDOPath((Metamodel)developmentObject.getMetamodel(), (MDOEnum)WebDynproMDOEnum.MODELCLASS, (String)nameInput, (String)packageInput, (SourcePathIdentifier)renameWizardData.getTemporarySourcePathIdentifier())).getSeverity() == 4) {
            return status.getMessage();
        }
        return null;
    }

    protected void deleteImplementation(DevelopmentObject developmentObject) {
        if (developmentObject instanceof ModelClass) {
            DeletionService deletionService = new DeletionService(this.getWizardData().getEclipseProject());
            deletionService.deleteModelClass((ModelClass)developmentObject, true);
        }
    }

    protected void generateImplementation(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (developmentObject instanceof ModelClass) {
            ModelClass modelClass = (ModelClass)developmentObject;
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)modelClass);
            ModelClassService.generateModelClass((ModelClass)modelClass, (IProject)project, (IProgressMonitor)dialog.getProgressMonitor());
        }
    }
}

