/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.modelclass.creation;

import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.modeleditor.wizards.modelclass.creation.ModelClassWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModelClassWizardPage
extends WizardPage {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String TITLE = mTPool.getText(306);
    private static final String MODEL_CLASS = mCPool.getText(127);
    private static final String NAME = mTPool.getText(440);
    private static final String PACKAGE = mTPool.getText(441);
    private final String BROWSE = mCPool.getText(208);
    private final String SOURCE_FOLDER = mCPool.getText(207);
    private final String MODELCLASS = mCPool.getText(127);
    private static final String pageName = TITLE;
    private static final String pageTitle = TITLE;
    private static final String pageDescription = mTPool.getText(205);
    private ModelClassWizardData mData;
    private Model mModel;
    private Text mModelClassNameField;
    private Text mModelClassPackageField;
    private Button mBtBrowsePackage;
    private List mSourcePathList;
    private Button mBtIsAbstract;
    private Button mBtIsInterface;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public ModelClassWizardPage(ModelClassWizardData data, Model model) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_INTERFACE_VIEW_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mData = data;
        this.mModel = model;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        IGridLayoutData gridLayoutData = null;
        wizardPane.addTextLabel(NAME);
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false);
        this.mModelClassNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mModelClassNameField.addModifyListener((ModifyListener)new NameModifyListener());
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false);
        this.mModelClassPackageField = wizardPane.addTextField(this.mModel.getPackage(), false, gridLayoutData);
        this.mModelClassPackageField.addModifyListener((ModifyListener)new PackageModifyListener());
        this.mBtBrowsePackage = wizardPane.addPushButton(this.BROWSE);
        this.mBtBrowsePackage.addSelectionListener((SelectionListener)new BrowsePackageButtonListener());
        wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false);
        gridLayoutData.getGridData().heightHint = 40;
        IPackageFragmentRoot[] roots = this.mData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
        wizardPane.addPlaceholder();
        wizardPane.addPlaceholder();
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false);
        this.mBtIsInterface = wizardPane.addCheckBox(TextPool.getInstance().getText(431), false, gridLayoutData);
        this.mBtIsInterface.addSelectionListener((SelectionListener)new IsInterfaceSelectionListener());
        wizardPane.addPlaceholder();
        wizardPane.addPlaceholder();
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false);
        this.mBtIsAbstract = wizardPane.addCheckBox(TextPool.getInstance().getText(430), false, gridLayoutData);
        this.mBtIsAbstract.addSelectionListener((SelectionListener)new IsAbstractSelectionListener());
        wizardPane.addPlaceholder();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.mData.getModelClassName() != null && this.mData.getModelClassName().length() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mModelClassNameField.setFocus();
        }
    }

    private void handlePageCompletion() {
        this.mData.setModelClassName(this.mModelClassNameField.getText());
        this.mData.setModelClassPackage(this.mModelClassPackageField.getText());
        this.setPageComplete(true);
        this.setErrorMessage(null);
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String name = this.mModelClassNameField.getText();
        name = CheckServices.checkFirstCharacter((Text)this.mModelClassNameField);
        if (name.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, (Object)MODEL_CLASS));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)name);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)name);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)name));
            return false;
        }
        if (this.mModel.hasModelClass(name, this.mData.getModelClassPackage())) {
            this.setErrorMessage(mTPool.getText(6, (Object)name));
            return false;
        }
        if (this.mModel.getName().equals(name) && this.mModel.getPackage().equals(this.mModelClassPackageField.getText())) {
            this.setErrorMessage(mTPool.getText(22));
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageName = CheckServices.convertToLowerCase((Text)this.mModelClassPackageField);
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageName);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private class IsInterfaceSelectionListener
    implements SelectionListener {
        private IsInterfaceSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ModelClassWizardPage.this.mData.getIsInterface() != ((Button)e.widget).getSelection()) {
                ModelClassWizardPage.this.mData.setIsInterface(((Button)e.widget).getSelection());
                if (((Button)e.widget).getSelection()) {
                    ModelClassWizardPage.this.mBtIsAbstract.setEnabled(false);
                    ModelClassWizardPage.this.mBtIsAbstract.setSelection(true);
                } else {
                    ModelClassWizardPage.this.mBtIsAbstract.setEnabled(true);
                    ModelClassWizardPage.this.mBtIsAbstract.setSelection(false);
                    ModelClassWizardPage.this.mData.setIsAbstract(true);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class IsAbstractSelectionListener
    implements SelectionListener {
        private IsAbstractSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ModelClassWizardPage.this.mData.getIsAbstract() != ((Button)e.widget).getSelection()) {
                ModelClassWizardPage.this.mData.setIsAbstract(((Button)e.widget).getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    class BrowsePackageButtonListener
    extends SelectionAdapter {
        BrowsePackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot sourceRoot = ModelClassWizardPage.this.mData.getSelectedRoot();
            String packageName = ModelClassWizardPage.this.mData.getModelClassPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            if ((packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ModelClassWizardPage.this.getShell())) != null) {
                ModelClassWizardPage.this.mModelClassPackageField.setText(packageFragment.getElementName());
            }
            if (ModelClassWizardPage.this.isValidPackageField() && ModelClassWizardPage.this.isValidNameField() && ModelClassWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ModelClassWizardPage.this.handlePageCompletion();
            } else {
                ModelClassWizardPage.this.setPageComplete(false);
                if (ModelClassWizardPage.this.mSourcePathList.getItemCount() == 0) {
                    ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"mouseUp", (String)"Source Path not found.", null, (boolean)false);
                }
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = ModelClassWizardPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = ModelClassWizardPage.this.mData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                ModelClassWizardPage.this.mData.setSelectedRoot(selectedRoot);
            }
        }
    }

    class PackageModifyListener
    implements ModifyListener {
        PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ModelClassWizardPage.this.isValidPackageField() && ModelClassWizardPage.this.isValidNameField() && ModelClassWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ModelClassWizardPage.this.handlePageCompletion();
            } else {
                ModelClassWizardPage.this.setPageComplete(false);
                if (ModelClassWizardPage.this.mSourcePathList.getItemCount() == 0) {
                    ServiceModelEditorPlugin.internalError(this.getClass(), (String)"modifyText", (String)"Source Path not found.", null, (boolean)false);
                }
            }
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ModelClassWizardPage.this.isValidNameField() && ModelClassWizardPage.this.isValidPackageField() && ModelClassWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ModelClassWizardPage.this.handlePageCompletion();
            } else {
                ModelClassWizardPage.this.setPageComplete(false);
                if (ModelClassWizardPage.this.mSourcePathList.getItemCount() == 0) {
                    ServiceModelEditorPlugin.internalError(this.getClass(), (String)"modifyText", (String)"Source Path not found.", null, (boolean)false);
                }
            }
        }
    }
}

