/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanAnalyser;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanContentProvider;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanLabelProvider;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;

public class PageSelectJavaBeansJar
extends WizardPage {
    private IGridLayoutPane mGLP;
    private Label jarLabel;
    private Label modelLabel;
    private TreeViewer mJavaBeanListViewer;
    private TreeViewer mJarListViewer;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mAddAllButton;
    private Button mRemoveAllButton;
    private Button mBehaviourButton;
    private WebDynproRoot mWebDynproRoot;
    private JavaBeanModelData mJavaBeanModelData;

    public PageSelectJavaBeansJar(WebDynproRoot root, JavaBeanModelData mData) {
        super("Choose JavaBean Classes", "Choose JavaBean Classes", SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.setDescription("Add JavaBean classes to be imported as model");
        this.mWebDynproRoot = root;
        this.mJavaBeanModelData = mData;
    }

    public void createControl(Composite parent) {
        Composite childComposite = new Composite(parent, 0);
        childComposite.setLayout((Layout)new FillLayout());
        IGridLayoutPane layoutPane = PaneFactory.createGridLayoutPane((Composite)childComposite, (int)3);
        this.createJarPane(layoutPane);
        this.createButtonPane(layoutPane);
        this.createModelClassPane(layoutPane);
        this.setControl((Control)childComposite);
    }

    private void createJarPane(IGridLayoutPane layoutPane) {
        File file;
        IGridLayoutData layoutData = layoutPane.createGridLayoutData(4, 4, true, true, 1, 1);
        IGridLayoutPane jarPane = layoutPane.addGridLayoutPane(1, true, layoutData);
        this.jarLabel = jarPane.addTextLabel("");
        String jarPath = this.mJavaBeanModelData.getJarPath();
        String jarName = "";
        if (jarPath != null && (file = new File(jarPath)) != null && file.exists()) {
            jarName = file.getName();
        }
        this.jarLabel.setText("JAR: " + jarName);
        layoutData = jarPane.createGridLayoutData(4, 4, true, true, 1, 1);
        this.mJarListViewer = jarPane.addTreeViewer(false, layoutData);
        GridData grid = new GridData(1808);
        grid.widthHint = 100;
        grid.heightHint = 200;
        this.mJarListViewer.getControl().setLayoutData((Object)grid);
        this.mJarListViewer.setContentProvider((IContentProvider)new JavaBeanContentProvider());
        this.mJarListViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanLabelProvider((IWizardPage)this));
        this.mJarListViewer.setInput((Object)this.mJavaBeanModelData.getJarClasses());
        this.mJarListViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                TreeItem item = null;
                if (e.widget instanceof Tree) {
                    item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                } else if (e.widget instanceof TreeItem) {
                    item = (TreeItem)e.widget;
                }
                if (item != null && (data = item.getData()) instanceof JavaBeanModelClass) {
                    JavaBeanModelClass modelClass = (JavaBeanModelClass)data;
                    PageSelectJavaBeansJar.this.mJarListViewer.getTree().setToolTipText(modelClass.getTypeClass().getName());
                }
            }
        });
        this.mBehaviourButton = jarPane.addCheckBox("Add SuperClass and Interfaces", true);
        this.mBehaviourButton.setSelection(true);
        this.mJavaBeanModelData.setAddHierarchy(true);
        this.mBehaviourButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String message = PageSelectJavaBeansJar.this.mJavaBeanModelData.canChangeAddHierarchy();
                if (message != null) {
                    boolean status = MessageDialog.openConfirm((Shell)PageSelectJavaBeansJar.this.getShell(), (String)"Change in behaviour", (String)message);
                    if (status) {
                        PageSelectJavaBeansJar.this.mJavaBeanModelData.setAddHierarchy(PageSelectJavaBeansJar.this.mBehaviourButton.getSelection());
                    } else {
                        PageSelectJavaBeansJar.this.mBehaviourButton.setSelection(PageSelectJavaBeansJar.this.mJavaBeanModelData.getAddHierarchy());
                    }
                } else {
                    PageSelectJavaBeansJar.this.mJavaBeanModelData.setAddHierarchy(PageSelectJavaBeansJar.this.mBehaviourButton.getSelection());
                }
            }
        });
    }

    private void createButtonPane(IGridLayoutPane layoutPane) {
        IGridLayoutData layoutData = layoutPane.createGridLayoutData(2, 2, true, true, 1, 1);
        IGridLayoutPane buttonPane = layoutPane.addGridLayoutPane(1, layoutData);
        this.mAddButton = buttonPane.addPushButton("    Add -->   ");
        this.mAddAllButton = buttonPane.addPushButton("  Add All --> ");
        layoutData = layoutPane.createGridLayoutData(2, 2, true, true, 1, 1);
        Label dummyLabel = buttonPane.addTextLabel("");
        GridData gridData = new GridData();
        gridData.verticalSpan = 10;
        dummyLabel.setLayoutData((Object)gridData);
        this.mRemoveButton = buttonPane.addPushButton("  <-- Remove  ");
        this.mRemoveAllButton = buttonPane.addPushButton("<-- Remove All");
        this.mAddButton.setSize(this.mRemoveAllButton.getSize());
        this.mAddAllButton.setSize(this.mRemoveAllButton.getSize());
        this.mRemoveButton.setSize(this.mRemoveAllButton.getSize());
        this.mAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PageSelectJavaBeansJar.this.mJarListViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof JavaBeanModelClass) {
                    if (((JavaBeanModelClass)element).isModelClassExisting()) {
                        String name = "";
                        if (((JavaBeanModelClass)element).getTypeClass() != null) {
                            name = ((JavaBeanModelClass)element).getTypeClass().getName();
                        }
                        PageSelectJavaBeansJar.this.setErrorMessage("Invalid Class - " + name + " as Model Class already exists");
                        PageSelectJavaBeansJar.this.setPageComplete(false);
                    } else {
                        JavaBeanModelClass modelClass = (JavaBeanModelClass)element;
                        PageSelectJavaBeansJar.this.addBeanClass(modelClass);
                    }
                }
            }
        });
        this.mRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PageSelectJavaBeansJar.this.mJavaBeanListViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof JavaBeanModelClass) {
                    PageSelectJavaBeansJar.this.mJavaBeanModelData.removeModelClass((JavaBeanModelClass)element);
                    PageSelectJavaBeansJar.this.mJavaBeanListViewer.refresh();
                    PageSelectJavaBeansJar.this.mJavaBeanModelData.addJarClass((JavaBeanModelClass)element);
                    PageSelectJavaBeansJar.this.mJarListViewer.setInput((Object)PageSelectJavaBeansJar.this.mJavaBeanModelData.getJarClasses());
                    PageSelectJavaBeansJar.this.mJarListViewer.refresh();
                    PageSelectJavaBeansJar.this.setPageComplete(true);
                }
                PageSelectJavaBeansJar.this.setErrorMessage(null);
                if (PageSelectJavaBeansJar.this.mJavaBeanModelData.getModelClasses() == null || PageSelectJavaBeansJar.this.mJavaBeanModelData.getModelClasses().length == 0) {
                    PageSelectJavaBeansJar.this.setPageComplete(false);
                }
            }
        });
        this.mAddAllButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object[] elements = (Object[])PageSelectJavaBeansJar.this.mJarListViewer.getInput();
                int count = 0;
                JavaBeanModelClass modelClass = null;
                if (elements != null) {
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] instanceof JavaBeanModelClass) {
                            modelClass = (JavaBeanModelClass)elements[i];
                            if (!modelClass.isModelClassExisting()) {
                                PageSelectJavaBeansJar.this.mJavaBeanModelData.addModelClass(modelClass);
                                PageSelectJavaBeansJar.this.mJavaBeanModelData.removeJarClass(modelClass);
                            } else {
                                ++count;
                            }
                        }
                        ++i;
                    }
                }
                PageSelectJavaBeansJar.this.mJavaBeanListViewer.refresh();
                PageSelectJavaBeansJar.this.mJarListViewer.setInput((Object)PageSelectJavaBeansJar.this.mJavaBeanModelData.getJarClasses());
                PageSelectJavaBeansJar.this.mJarListViewer.refresh();
                if (count > 0) {
                    PageSelectJavaBeansJar.this.setErrorMessage("One or more Jar Classes could not be added as they already exist as ModelClasses");
                }
                PageSelectJavaBeansJar.this.setPageComplete(true);
            }
        });
        this.mRemoveAllButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JavaBeanModelClass[] classes = PageSelectJavaBeansJar.this.mJavaBeanModelData.getModelClasses();
                if (classes != null) {
                    int i = 0;
                    while (i < classes.length) {
                        PageSelectJavaBeansJar.this.mJavaBeanModelData.addJarClass(classes[i]);
                        ++i;
                    }
                }
                PageSelectJavaBeansJar.this.mJavaBeanModelData.removeAllModelClasses();
                PageSelectJavaBeansJar.this.mJavaBeanListViewer.refresh();
                PageSelectJavaBeansJar.this.mJarListViewer.setInput((Object)PageSelectJavaBeansJar.this.mJavaBeanModelData.getJarClasses());
                PageSelectJavaBeansJar.this.mJarListViewer.refresh();
                PageSelectJavaBeansJar.this.setErrorMessage(null);
                PageSelectJavaBeansJar.this.setPageComplete(false);
            }
        });
    }

    private void createModelClassPane(IGridLayoutPane layoutPane) {
        IGridLayoutData layoutData = layoutPane.createGridLayoutData(4, 4, true, true, 1, 1);
        IGridLayoutPane modelClassPane = layoutPane.addGridLayoutPane(1, true, layoutData);
        this.modelLabel = modelClassPane.addTextLabel("Model: " + this.mJavaBeanModelData.getModelName());
        layoutData = modelClassPane.createGridLayoutData(4, 4, true, true, 1, 1);
        this.mJavaBeanListViewer = modelClassPane.addTreeViewer(false, layoutData);
        GridData grid = new GridData(1808);
        grid.widthHint = 100;
        grid.heightHint = 200;
        this.mJavaBeanListViewer.getControl().setLayoutData((Object)grid);
        this.mJavaBeanListViewer.setContentProvider((IContentProvider)new JavaBeanContentProvider());
        this.mJavaBeanListViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanLabelProvider((IWizardPage)this));
        this.mJavaBeanListViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                TreeItem item = null;
                if (e.widget instanceof Tree) {
                    item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                } else if (e.widget instanceof TreeItem) {
                    item = (TreeItem)e.widget;
                }
                if (item != null && (data = item.getData()) instanceof JavaBeanModelClass) {
                    JavaBeanModelClass modelClass = (JavaBeanModelClass)data;
                    PageSelectJavaBeansJar.this.mJavaBeanListViewer.getTree().setToolTipText(modelClass.getTypeClass().getName());
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.mJavaBeanModelData.getModelClasses() != null && this.mJavaBeanModelData.getModelClasses().length > 0;
    }

    public void setVisible(boolean visible) {
        String error = null;
        if (visible && this.mJarListViewer != null) {
            this.mJarListViewer.setInput((Object)this.mJavaBeanModelData.getJarClasses());
            this.mJarListViewer.refresh();
            this.mJavaBeanListViewer.setInput((Object)this.mJavaBeanModelData);
            this.mJavaBeanListViewer.refresh();
        }
        this.setErrorMessage(error);
        if (error != null) {
            this.setPageComplete(false);
        } else if (this.mJavaBeanModelData.getModelClasses() != null && this.mJavaBeanModelData.getModelClasses().length > 0) {
            this.setPageComplete(true);
        }
        super.setVisible(visible);
    }

    private void addBeanClass(JavaBeanModelClass beanClass) {
        if (beanClass != null) {
            StringBuffer buffer = new StringBuffer();
            if (!this.mJavaBeanModelData.getAddHierarchy()) {
                this.mJavaBeanModelData.addModelClass(beanClass);
                this.mJavaBeanModelData.removeJarClass(beanClass);
            } else {
                Class[] classHierarchy = JavaBeanAnalyser.openHierarchy((Class)beanClass.getTypeClass());
                JavaBeanModelClass modelClass = null;
                if (classHierarchy != null) {
                    int i = 0;
                    while (i < classHierarchy.length) {
                        modelClass = this.mJavaBeanModelData.getJarBeanClass(classHierarchy[i]);
                        if (modelClass != null) {
                            this.mJavaBeanModelData.addModelClass(modelClass);
                            this.mJavaBeanModelData.removeJarClass(modelClass);
                            if (!beanClass.getTypeClass().equals(classHierarchy[i])) {
                                buffer.append(modelClass.getName() + "\n");
                            }
                        }
                        ++i;
                    }
                }
            }
            this.mJavaBeanListViewer.refresh();
            this.mJarListViewer.setInput((Object)this.mJavaBeanModelData.getJarClasses());
            this.mJarListViewer.refresh();
            this.setErrorMessage(null);
            this.setPageComplete(true);
            if (buffer.toString().trim().length() > 0) {
                String message = "Additional Beans added due to '" + beanClass.getName() + "':\n" + buffer.toString();
                if (this.mJavaBeanModelData.getNotifyHierarchyStatus()) {
                    this.displayMessage(message);
                }
            }
        }
    }

    private void displayMessage(String message) {
        if (message != null && message.trim().length() > 0) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)"Hierarchy", (String)message, null, (boolean)false);
            this.mJavaBeanModelData.setNotifyHierarchyStatus(!dialog.getToggleState());
        }
    }
}

