/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanAnalyser;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanContentProvider;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanLabelProvider;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;

public class PageSelectJavaBeansFinder
extends WizardPage {
    private Text mInputText;
    private Composite mTypeFinderComposite;
    private TreeViewer mJavaBeanListViewer;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mBehaviourButton;
    private TypeSelectionDialog mTypeSelectionDialog;
    private Control mDialogArea;
    private Composite mParentComposite;
    private WebDynproRoot mWebDynproRoot;
    private JavaBeanModelData mJavaBeanModelData;
    private TypeInfo[] mOnlyProjectTypeInfo;
    private TypeInfo[] mCompleteProjectTypeInfo;

    public PageSelectJavaBeansFinder(WebDynproRoot root, JavaBeanModelData mData) {
        super("Choose JavaBean Classes", "Choose JavaBean Classes", SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.setDescription("Add JavaBean classes to be imported as model");
        this.mWebDynproRoot = root;
        this.mJavaBeanModelData = mData;
    }

    public void createControl(Composite parent) {
        if (this.mJavaBeanModelData.getProjectSourceOption() == JavaBeanModelData.ONLY_SOURCE_FOLDERS && this.mOnlyProjectTypeInfo == null) {
            this.mOnlyProjectTypeInfo = this.mJavaBeanModelData.getOnlyProjectTypeInfo();
        }
        if (this.mJavaBeanModelData.getProjectSourceOption() == JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO && this.mCompleteProjectTypeInfo == null) {
            this.mCompleteProjectTypeInfo = this.mJavaBeanModelData.getCompleteProjectTypeInfo();
        }
        this.mParentComposite = parent;
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane mGLP = PaneFactory.createGridLayoutPane((Composite)root, (int)5);
        mGLP.setSpacing(5, 10);
        this.createFinderPane(mGLP);
        this.createButtonPane(mGLP);
        this.createListPane(mGLP);
    }

    private void initializeTypeInfo() {
        this.mOnlyProjectTypeInfo = this.initialize(JavaBeanModelData.ONLY_SOURCE_FOLDERS);
        this.mCompleteProjectTypeInfo = this.initialize(JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO);
    }

    private void createFinderPane(IGridLayoutPane pane) {
        IGridLayoutData layoutData = pane.createGridLayoutData(4, 4, true, true, 2, 1);
        IGridLayoutPane finderPane = pane.addGridLayoutPane(1, layoutData);
        this.mTypeFinderComposite = finderPane.getComposite();
        this.mTypeFinderComposite.setLayout((Layout)new GridLayout());
        this.mTypeFinderComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(this.mTypeFinderComposite, 0);
        label.setText("Select JavaBean");
        this.createTypeSelectionDialog();
        this.mBehaviourButton = new Button(this.mTypeFinderComposite, 32);
        this.mBehaviourButton.setText("Add SuperClass and Interfaces");
        this.mBehaviourButton.setSelection(true);
        this.mJavaBeanModelData.setAddHierarchy(true);
        this.mBehaviourButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String message = PageSelectJavaBeansFinder.this.mJavaBeanModelData.canChangeAddHierarchy();
                if (message != null) {
                    boolean status = MessageDialog.openConfirm((Shell)PageSelectJavaBeansFinder.this.getShell(), (String)"Change in behaviour", (String)message);
                    if (status) {
                        PageSelectJavaBeansFinder.this.mJavaBeanModelData.setAddHierarchy(PageSelectJavaBeansFinder.this.mBehaviourButton.getSelection());
                    } else {
                        PageSelectJavaBeansFinder.this.mBehaviourButton.setSelection(PageSelectJavaBeansFinder.this.mJavaBeanModelData.getAddHierarchy());
                    }
                } else {
                    PageSelectJavaBeansFinder.this.mJavaBeanModelData.setAddHierarchy(PageSelectJavaBeansFinder.this.mBehaviourButton.getSelection());
                }
            }
        });
    }

    private void createTypeSelectionDialog() {
        Composite composite;
        Control[] controls;
        int scopeOption = this.mJavaBeanModelData.getProjectSourceOption();
        IJavaSearchScope scope = this.getJavaSearchScope(scopeOption);
        this.mTypeSelectionDialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, scope){

            public Object getFirstResult() {
                this.computeResult();
                Object[] result = this.getResult();
                if (result == null || result.length == 0) {
                    return null;
                }
                return result[0];
            }
        };
        if (scopeOption == JavaBeanModelData.ONLY_SOURCE_FOLDERS) {
            this.mTypeSelectionDialog.setElements((Object[])this.mOnlyProjectTypeInfo);
        } else {
            this.mTypeSelectionDialog.setElements((Object[])this.mCompleteProjectTypeInfo);
        }
        this.mTypeSelectionDialog.setFilter("*");
        this.mDialogArea = this.mTypeSelectionDialog.createDialogArea(this.mTypeFinderComposite);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.mDialogArea.setLayoutData((Object)gridData);
        if (this.mDialogArea != null && this.mDialogArea instanceof Composite && (controls = (composite = (Composite)this.mDialogArea).getChildren()) != null) {
            int i = 0;
            while (i < controls.length) {
                if (controls[i] instanceof Text) {
                    this.mInputText = (Text)controls[i];
                    break;
                }
                ++i;
            }
        }
    }

    private void createButtonPane(IGridLayoutPane pane) {
        IGridLayoutData layoutData = pane.createGridLayoutData(2, 2, false, true, 1, 1);
        IGridLayoutPane buttonsPane = pane.addGridLayoutPane(1, layoutData);
        this.mAddButton = buttonsPane.addPushButton("   Add -->   ");
        this.mRemoveButton = buttonsPane.addPushButton("<-- Remove");
        this.mAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PageSelectJavaBeansFinder.this.mTypeSelectionDialog.getOkButton();
                IType result = (IType)PageSelectJavaBeansFinder.this.mTypeSelectionDialog.getFirstResult();
                PageSelectJavaBeansFinder.this.addBeanClass(result);
                PageSelectJavaBeansFinder.this.mRemoveButton.setEnabled(true);
                PageSelectJavaBeansFinder.this.setPageComplete(true);
            }
        });
        this.mRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PageSelectJavaBeansFinder.this.mJavaBeanListViewer.getSelection();
                Object element = selection.getFirstElement();
                Object result = null;
                if (element instanceof JavaBeanModelClass) {
                    PageSelectJavaBeansFinder.this.mJavaBeanModelData.removeModelClass((JavaBeanModelClass)element);
                    PageSelectJavaBeansFinder.this.mJavaBeanListViewer.refresh();
                }
                if (PageSelectJavaBeansFinder.this.mJavaBeanModelData.getModelClasses() == null || PageSelectJavaBeansFinder.this.mJavaBeanModelData.getModelClasses().length == 0) {
                    PageSelectJavaBeansFinder.this.mRemoveButton.setEnabled(false);
                    PageSelectJavaBeansFinder.this.setPageComplete(false);
                } else {
                    PageSelectJavaBeansFinder.this.mRemoveButton.setEnabled(true);
                }
            }
        });
    }

    private void createListPane(IGridLayoutPane pane) {
        IGridLayoutData layoutData = pane.createGridLayoutData(4, 4, true, true, 2, 1);
        IGridLayoutPane modelClassesPane = pane.addGridLayoutPane(1, layoutData);
        layoutData = modelClassesPane.createGridLayoutData(4, 4, true, true);
        modelClassesPane.addTextLabel("Model: " + this.mJavaBeanModelData.getModelName());
        this.mJavaBeanListViewer = modelClassesPane.addTreeViewer(true, layoutData);
        this.mJavaBeanListViewer.setContentProvider((IContentProvider)new JavaBeanContentProvider());
        this.mJavaBeanListViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanLabelProvider((IWizardPage)this));
        this.mJavaBeanListViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                TreeItem item = null;
                if (e.widget instanceof Tree) {
                    item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                } else if (e.widget instanceof TreeItem) {
                    item = (TreeItem)e.widget;
                }
                if (item != null && (data = item.getData()) instanceof JavaBeanModelClass) {
                    JavaBeanModelClass modelClass = (JavaBeanModelClass)data;
                    PageSelectJavaBeansFinder.this.mJavaBeanListViewer.getTree().setToolTipText(modelClass.getTypeClass().getName());
                }
            }
        });
    }

    private TypeInfo[] initialize(int option) {
        final ArrayList typeList = new ArrayList();
        ProgressMonitorDialog fRunnableContext = new ProgressMonitorDialog(this.getShell());
        final IJavaSearchScope fScope = this.getJavaSearchScope(option);
        boolean fElementKinds = false;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AllTypesCache.getTypes((IJavaSearchScope)fScope, (int)0, (IProgressMonitor)monitor, (Collection)typeList);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            fRunnableContext.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)JavaUIMessages.getString((String)"TypeSelectionDialog.error3Title"), (String)JavaUIMessages.getString((String)"TypeSelectionDialog.error3Message"));
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        if (typeList.isEmpty()) {
            String title = JavaUIMessages.getString((String)"TypeSelectionDialog.notypes.title");
            String message = JavaUIMessages.getString((String)"TypeSelectionDialog.notypes.message");
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"nextPressed", (String)"Internal error - see detail information in exception trace.", (Throwable)new Throwable(message), (boolean)false);
            return null;
        }
        TypeInfo[] typeRefs = typeList.toArray(new TypeInfo[typeList.size()]);
        return typeRefs;
    }

    public boolean isPageComplete() {
        return this.mJavaBeanModelData.getModelClasses() != null && this.mJavaBeanModelData.getModelClasses().length > 0;
    }

    public void setVisible(boolean visible) {
        if (visible && this.mJavaBeanListViewer != null) {
            this.mJavaBeanListViewer.setInput((Object)this.mJavaBeanModelData);
            this.mJavaBeanListViewer.refresh();
            if (this.mJavaBeanModelData.getModelClasses() == null || this.mJavaBeanModelData.getModelClasses().length == 0) {
                this.mRemoveButton.setEnabled(false);
            } else {
                this.mRemoveButton.setEnabled(true);
            }
            this.setFocus();
            this.setErrorMessage(null);
        }
        super.setVisible(visible);
    }

    public void setFocus() {
        if (this.mInputText != null) {
            this.mInputText.setText("*");
            this.mInputText.setFocus();
        }
    }

    private void addBeanClass(IType iType) {
        if (iType != null) {
            StringBuffer buffer = new StringBuffer();
            try {
                if (!Flags.isPublic((int)iType.getFlags()) || iType.getFullyQualifiedName().indexOf(36) != -1) {
                    this.setErrorMessage("Invalid JavaBean Class - Not a Public JavaBean");
                    return;
                }
                JavaBeanModelClass modelClass = null;
                if (this.mJavaBeanModelData.getAddHierarchy()) {
                    JavaBeanModelClass[] modelClasses = JavaBeanAnalyser.initializeJBModelClasses((WebDynproRoot)this.mWebDynproRoot, (IType)iType);
                    if (modelClasses != null) {
                        int i = 0;
                        while (i < modelClasses.length) {
                            if (!iType.getFullyQualifiedName().equals(modelClasses[i].getTypeClass().getName())) {
                                buffer.append(modelClasses[i].getName() + "\n");
                            }
                            this.mJavaBeanModelData.addModelClass(modelClasses[i]);
                            ++i;
                        }
                        modelClass = modelClasses[0];
                    }
                } else {
                    modelClass = JavaBeanAnalyser.createJavaBeanModelClass((WebDynproRoot)this.mWebDynproRoot, (IType)iType);
                    this.mJavaBeanModelData.addModelClass(modelClass);
                }
                this.mJavaBeanListViewer.setInput((Object)this.mJavaBeanModelData);
                if (modelClass != null) {
                    this.mJavaBeanListViewer.setSelection((ISelection)new StructuredSelection((Object)modelClass));
                }
                this.mJavaBeanListViewer.refresh();
                this.setErrorMessage(null);
            }
            catch (Exception ee) {
                this.setErrorMessage(ee.getMessage());
                System.out.println(ee.getMessage());
            }
            if (buffer.toString().trim().length() > 0) {
                String message = "Additional Beans added due to '" + iType.getElementName() + "':\n" + buffer.toString();
                if (this.mJavaBeanModelData.getNotifyHierarchyStatus()) {
                    this.displayMessage(message);
                }
            }
        }
    }

    private void displayMessage(String message) {
        if (message != null && message.trim().length() > 0) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)"Hierarchy", (String)message, null, (boolean)false);
            this.mJavaBeanModelData.setNotifyHierarchyStatus(!dialog.getToggleState());
        }
    }

    private IJavaSearchScope getJavaSearchScope(int option) {
        IJavaSearchScope javaSearchScope = null;
        IJavaProject iProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynproRoot.getMetamodel().getName()));
        IJavaElement[] elements = new IJavaElement[]{iProject};
        if (option == JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO) {
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        } else {
            ArrayList<IPackageFragmentRoot> elementsList = new ArrayList<IPackageFragmentRoot>();
            try {
                IClasspathEntry[] classpathEntries = iProject.getRawClasspath();
                if (classpathEntries != null) {
                    int i = 0;
                    while (i < classpathEntries.length) {
                        if (classpathEntries[i].getEntryKind() == 3) {
                            elementsList.add(iProject.findPackageFragmentRoot(classpathEntries[i].getPath()));
                        }
                        ++i;
                    }
                    if (elementsList.size() > 0) {
                        elements = new IJavaElement[elementsList.size()];
                        elements = elementsList.toArray(elements);
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        }
        return javaSearchScope;
    }

    public void disposeControl() {
        Control rootControl = this.getControl();
        this.setControl(null);
        if (rootControl != null) {
            rootControl.dispose();
        }
        this.setPageComplete(false);
    }
}

