/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanAnalyser;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanContentProvider;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanLabelProvider;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanModelRelationViewer;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanRelationCellModifier;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanRelationContentProvider;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.JavaBeanRelationLabelProvider;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class PageAddJavaBeanDetails
extends WizardPage {
    private ITabbedPane mTabbedPane;
    private Text mJavaClassNameField;
    private TreeViewer mtreeViewer;
    private TableViewer mTableViewer;
    private Button mJavaBeanAddButton;
    private Button mJavaBeanRemoveButton;
    private Button mAddHierarchyButton;
    private Label mMethodLabel;
    private Font mLabelFont;
    private IGridLayoutPane mJavaBeanDetailsPane;
    private IGridLayoutPane mPropertiesPane;
    private IGridLayoutPane mRelationsPane;
    private JavaBeanModelRelationViewer mModelRelationViewer;
    private JavaBeanContentProvider mContentProvider;
    private JavaBeanLabelProvider mLabelProvider;
    private CheckboxTreeViewer mPropertyViewer;
    private TableTree mTableTree;
    private TableTreeViewer mTableTreeViewer;
    private ColumnContentProvider mColumnContentProvider;
    private Table mTable;
    private WebDynproRoot mWebDynproRoot;
    private JavaBeanModelData mJavaBeanModelData;
    private JavaBeanModelClass mSelectedClass;
    private JavaBeanModelClass mAddedClass;

    public PageAddJavaBeanDetails(WebDynproRoot root, JavaBeanModelData mData) {
        super("ModelClass Details", "ModelClass Details", SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.setDescription("Identify the ModelClassProperties and ModelRelations to be imported. \nIdentify the target ModelClass for ModelRelations decorated with warning.");
        this.mWebDynproRoot = root;
        this.mJavaBeanModelData = mData;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        this.mTabbedPane = PaneFactory.createTabbedPane((Composite)root);
        IGridLayoutPane detailedPane = this.mTabbedPane.addGridLayoutPaneAsTab("ModelClass View", 2);
        detailedPane.setSpacing(10, 0);
        IGridLayoutPane relationsPane = this.mTabbedPane.addGridLayoutPaneAsTab("ModelRelation View", 2);
        this.setJavaBeanPane(detailedPane);
        this.setJavaBeanDetailsPane(detailedPane);
        this.setRelationalPane(relationsPane);
    }

    private void setJavaBeanPane(IGridLayoutPane mGLP) {
        IGridLayoutData layoutData = mGLP.createGridLayoutData(4, 4, true, true);
        IGridLayoutPane childPane = mGLP.addGridLayoutPane("ModelClass", 1, true, layoutData);
        layoutData = childPane.createGridLayoutData(4, 4, true, true, 1, 2);
        this.mtreeViewer = childPane.addTreeViewer(true, layoutData);
        this.mLabelProvider = new JavaBeanLabelProvider((IWizardPage)this);
        this.mContentProvider = new JavaBeanContentProvider();
        this.mtreeViewer.setLabelProvider((IBaseLabelProvider)this.mLabelProvider);
        this.mtreeViewer.setContentProvider((IContentProvider)this.mContentProvider);
        this.mtreeViewer.setInput((Object)this.mJavaBeanModelData);
        this.mtreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof JavaBeanModelClass) {
                    PageAddJavaBeanDetails.this.mSelectedClass = (JavaBeanModelClass)selection.getFirstElement();
                    PageAddJavaBeanDetails.this.setDefaultSelection();
                    PageAddJavaBeanDetails.this.updateButtonStatus();
                    PageAddJavaBeanDetails.this.refreshPage();
                } else {
                    PageAddJavaBeanDetails.this.mJavaBeanDetailsPane.getComposite().setVisible(false);
                }
            }
        });
        this.mtreeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                TreeItem item = null;
                if (e.widget instanceof Tree) {
                    item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                } else if (e.widget instanceof TreeItem) {
                    item = (TreeItem)e.widget;
                }
                if (item != null && (data = item.getData()) instanceof JavaBeanModelClass) {
                    JavaBeanModelClass modelClass = (JavaBeanModelClass)data;
                    PageAddJavaBeanDetails.this.mtreeViewer.getTree().setToolTipText(modelClass.getTypeClass().getName());
                }
            }
        });
        layoutData = childPane.createGridLayoutData(4, 3, true, false);
        layoutData.getGridData().heightHint = 20;
        IGridLayoutPane gPane = childPane.addGridLayoutPane(2, false, layoutData);
        this.mJavaBeanAddButton = gPane.addPushButton("  Add  ");
        this.mJavaBeanRemoveButton = gPane.addPushButton(" Remove ");
        this.mJavaBeanAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object modelClass = null;
                IType result = null;
                if (PageAddJavaBeanDetails.this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_CLASS_FINDER) {
                    result = PageAddJavaBeanDetails.this.chooseType();
                    if (result == null) {
                        return;
                    }
                    try {
                        if (!Flags.isPublic((int)result.getFlags()) || result.getFullyQualifiedName().indexOf(36) != -1) {
                            PageAddJavaBeanDetails.this.setErrorMessage("Invalid JavaBean Class - Not a Public JavaBean");
                            return;
                        }
                    }
                    catch (JavaModelException jme) {
                        PageAddJavaBeanDetails.this.setErrorMessage(jme.getMessage());
                        System.out.println(jme.getMessage());
                    }
                } else {
                    result = PageAddJavaBeanDetails.this.chooseJavaBeans();
                }
                if (result != null) {
                    PageAddJavaBeanDetails.this.addBeanClass(result);
                    PageAddJavaBeanDetails.this.updateButtonStatus();
                    PageAddJavaBeanDetails.this.setPageComplete(true);
                }
            }
        });
        this.mJavaBeanRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PageAddJavaBeanDetails.this.mtreeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof JavaBeanModelClass) {
                    PageAddJavaBeanDetails.this.mJavaBeanModelData.removeModelClass((JavaBeanModelClass)element);
                    PageAddJavaBeanDetails.this.mtreeViewer.refresh();
                    if (PageAddJavaBeanDetails.this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_JAR_FILE || PageAddJavaBeanDetails.this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_DC_PUBLIC_PART) {
                        PageAddJavaBeanDetails.this.mJavaBeanModelData.addJarClass((JavaBeanModelClass)element);
                    }
                }
                if (PageAddJavaBeanDetails.this.mJavaBeanModelData.getModelClasses() == null || PageAddJavaBeanDetails.this.mJavaBeanModelData.getModelClasses().length == 0) {
                    PageAddJavaBeanDetails.this.setPageComplete(false);
                }
                PageAddJavaBeanDetails.this.updateButtonStatus();
                PageAddJavaBeanDetails.this.setDefaultSelection();
            }
        });
        layoutData = childPane.createGridLayoutData(4, 3, true, false);
        layoutData.getGridData().heightHint = 20;
        gPane = childPane.addGridLayoutPane(1, false, layoutData);
        this.mAddHierarchyButton = gPane.addCheckBox("Add SuperClass and Interfaces", true);
        this.mAddHierarchyButton.setEnabled(false);
    }

    private void setJavaBeanDetailsPane(IGridLayoutPane mGLP) {
        IGridLayoutData layoutData = mGLP.createGridLayoutData(4, 4, true, true);
        this.mJavaBeanDetailsPane = mGLP.addGridLayoutPane(1, true, layoutData);
        this.mJavaBeanDetailsPane.setSpacing(5, 10);
        layoutData = this.mJavaBeanDetailsPane.createGridLayoutData(4, 4, true, true);
        this.mPropertiesPane = this.mJavaBeanDetailsPane.addGridLayoutPane("ModelClassProperty", 1, true, layoutData);
        layoutData = this.mPropertiesPane.createGridLayoutData(4, 4, true, true);
        this.mPropertyViewer = this.mPropertiesPane.addCheckboxTreeViewer(true, layoutData);
        this.mPropertyViewer.setContentProvider((IContentProvider)new JavaBeanContentProvider());
        this.mPropertyViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanLabelProvider((IWizardPage)this, this.mPropertyViewer));
        this.mPropertyViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean status = event.getChecked();
                if (element instanceof JavaBeanModelProperty) {
                    ((JavaBeanModelProperty)element).setSelected(status);
                }
                PageAddJavaBeanDetails.this.mPropertyViewer.setChecked(element, status);
                if (!PageAddJavaBeanDetails.this.validateSelection(PageAddJavaBeanDetails.this.mSelectedClass)) {
                    PageAddJavaBeanDetails.this.setErrorMessage("Atleast one property or one relation has to be selected for model class " + PageAddJavaBeanDetails.this.mSelectedClass.getName());
                    PageAddJavaBeanDetails.this.setPageComplete(false);
                }
            }
        });
        this.mPropertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PageAddJavaBeanDetails.this.mPropertyViewer.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.getFirstElement() instanceof JavaBeanModelProperty) {
                        PageAddJavaBeanDetails.this.mMethodLabel.setText(((JavaBeanModelProperty)selection.getFirstElement()).getMethodSignature());
                        PageAddJavaBeanDetails.this.mMethodLabel.pack();
                        PageAddJavaBeanDetails.this.mMethodLabel.setVisible(true);
                    }
                } else {
                    PageAddJavaBeanDetails.this.mMethodLabel.setVisible(false);
                }
            }
        });
        layoutData = this.mJavaBeanDetailsPane.createGridLayoutData(4, 4, true, true, 1, 2);
        this.mRelationsPane = this.mJavaBeanDetailsPane.addGridLayoutPane("ModelRelation", 1, layoutData);
        this.mRelationsPane.getComposite().setLayoutData((Object)layoutData.getGridData());
        this.mModelRelationViewer = new JavaBeanModelRelationViewer((IWizardPage)this, this.mRelationsPane, this.mJavaBeanModelData);
        this.mTableViewer = this.mModelRelationViewer.getTableViewer();
        this.createTableColumns(this.mTableViewer.getTable());
        this.setUpTableCellEditors(this.mTableViewer);
        this.mTableViewer.setColumnProperties(this.mJavaBeanModelData.getTableHeaders(JavaBeanModelData.GET_MODEL_RELATION_DETAILS));
        this.mModelRelationViewer.setContentProvider(new JavaBeanRelationContentProvider());
        this.mModelRelationViewer.setLabelProvider(new JavaBeanRelationLabelProvider(this.mTableViewer));
        this.mModelRelationViewer.setCellModifier(new JavaBeanRelationCellModifier((WizardPage)this, this.mTableViewer));
        String[] names = new String[]{JavaBeanModelData.MODEL_STATUS, JavaBeanModelData.MODEL_RELATION_NAME, JavaBeanModelData.MODEL_TARGET_ROLE, JavaBeanModelData.MODEL_MODEL_CLASS};
        this.mModelRelationViewer.setColumnProperties(names);
        this.mTableViewer.setInput((Object)this.mJavaBeanModelData);
        this.mTableViewer.refresh();
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PageAddJavaBeanDetails.this.mTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.getFirstElement() instanceof JavaBeanModelRelation) {
                        JavaBeanModelRelation relation = (JavaBeanModelRelation)selection.getFirstElement();
                        PageAddJavaBeanDetails.this.mMethodLabel.setText(relation.getProperty().getMethodSignature());
                        PageAddJavaBeanDetails.this.mMethodLabel.pack();
                        PageAddJavaBeanDetails.this.mMethodLabel.setVisible(true);
                    }
                } else {
                    PageAddJavaBeanDetails.this.mMethodLabel.setVisible(false);
                }
            }
        });
        layoutData = this.mJavaBeanDetailsPane.createGridLayoutData(4, 1, true, true);
        this.mMethodLabel = this.mJavaBeanDetailsPane.addTextLabel("", layoutData);
        FontData[] fontData = this.mMethodLabel.getFont().getFontData();
        if (fontData != null) {
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setStyle(1 | fontData[i].getStyle());
                ++i;
            }
        }
        this.mLabelFont = new Font((Device)this.mMethodLabel.getDisplay(), fontData);
        this.mMethodLabel.setFont(this.mLabelFont);
    }

    private void setRelationalPane(IGridLayoutPane relationsPane) {
        this.mColumnContentProvider = new ColumnContentProvider(this.mJavaBeanModelData);
        this.mTableTreeViewer = new TableTreeViewer(relationsPane.getComposite(), 101120);
        GridData grid = new GridData(1808);
        grid.widthHint = 450;
        grid.heightHint = 200;
        this.mTableTreeViewer.getControl().setLayoutData((Object)grid);
        this.mTableTree = this.mTableTreeViewer.getTableTree();
        this.mTable = this.mTableTree.getTable();
        this.createColumns();
        this.setUpCellEditors();
        this.mTableTreeViewer.setColumnProperties(this.mJavaBeanModelData.getTableHeaders(JavaBeanModelData.GET_MORE_MODEL_RELATION_DETAILS));
        this.mTableTreeViewer.setContentProvider((IContentProvider)this.mColumnContentProvider);
        this.mTableTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanRelationLabelProvider(this.mTableTreeViewer));
        this.mTableTreeViewer.setCellModifier((ICellModifier)new JavaBeanRelationCellModifier((WizardPage)this, this.mTableTreeViewer));
        this.mTableTreeViewer.setInput((Object)this.mJavaBeanModelData);
        this.mTable.setLinesVisible(true);
        this.mTable.setHeaderVisible(true);
    }

    protected void createColumns() {
        this.mTable.setHeaderVisible(true);
        this.mTable.removeAll();
        TableColumn modelClassNameColumn = new TableColumn(this.mTable, 0, 0);
        modelClassNameColumn.setResizable(true);
        modelClassNameColumn.setWidth(125);
        TableColumn statusColumn = new TableColumn(this.mTable, 0, 1);
        statusColumn.setWidth(20);
        TableColumn nameColumn = new TableColumn(this.mTable, 0, 2);
        nameColumn.setResizable(true);
        nameColumn.setText(JavaBeanModelData.MODEL_RELATION_NAME);
        nameColumn.setWidth(120);
        TableColumn targetColumn = new TableColumn(this.mTable, 0, 3);
        targetColumn.setResizable(true);
        targetColumn.setText(JavaBeanModelData.MODEL_TARGET_ROLE);
        targetColumn.setWidth(150);
        TableColumn modelColumn = new TableColumn(this.mTable, 0, 4);
        modelColumn.setResizable(true);
        modelColumn.setText(JavaBeanModelData.MODEL_MODEL_CLASS);
        modelColumn.setWidth(120);
    }

    private void setUpCellEditors() {
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.mTable), new CheckboxCellEditor((Composite)this.mTable), new TextCellEditor((Composite)this.mTable), new TextCellEditor((Composite)this.mTable), new ComboBoxCellEditor((Composite)this.mTable, this.mJavaBeanModelData.getModelClassNames(), 8)};
        this.mTableTreeViewer.setCellEditors(editors);
    }

    protected void createTableColumns(Table mTable) {
        mTable.setHeaderVisible(true);
        TableColumn[] columns = mTable.getColumns();
        int columnCount = mTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            columns[0].dispose();
            ++i;
        }
        mTable.removeAll();
        TableColumn statusColumn = new TableColumn(mTable, 0, 0);
        statusColumn.setWidth(30);
        TableColumn nameColumn = new TableColumn(mTable, 0, 1);
        nameColumn.setResizable(true);
        nameColumn.setText(JavaBeanModelData.MODEL_RELATION_NAME);
        nameColumn.setWidth(130);
        TableColumn targetColumn = new TableColumn(mTable, 0, 2);
        targetColumn.setResizable(true);
        targetColumn.setText(JavaBeanModelData.MODEL_TARGET_ROLE);
        targetColumn.setWidth(95);
        TableColumn modelColumn = new TableColumn(mTable, 0, 3);
        modelColumn.setResizable(true);
        modelColumn.setText(JavaBeanModelData.MODEL_MODEL_CLASS);
        modelColumn.setWidth(95);
    }

    protected void setUpTableCellEditors(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        CellEditor[] editors = new CellEditor[]{new CheckboxCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, this.mJavaBeanModelData.getModelClassNames(), 8)};
        tableViewer.setCellEditors(editors);
    }

    private IType chooseType() {
        IJavaProject iProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynproRoot.getMetamodel().getName()));
        IJavaElement[] elements = new IJavaElement[]{iProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        scope = this.mJavaBeanModelData.getProjectSearchScope(this.mWebDynproRoot);
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, scope);
        dialog.setTitle("Choose Java Bean");
        dialog.setMessage("Choose Java Bean");
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private JavaBeanModelClass chooseJavaBeans() {
        try {
            Object[] modelClasses = this.mJavaBeanModelData.getJarClasses();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaBeanLabelProvider((IWizardPage)this));
            dialog.setElements(modelClasses);
            dialog.setMultipleSelection(true);
            dialog.setTitle("Choose Java Bean");
            dialog.setMessage("Choose Java Bean");
            if (dialog.open() == 0) {
                return (JavaBeanModelClass)dialog.getFirstResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.mJavaBeanDetailsPane != null && this.mtreeViewer != null) {
                this.mtreeViewer.setInput((Object)this.mJavaBeanModelData);
                this.mtreeViewer.refresh();
                this.setDefaultSelection();
                this.refreshPage();
                this.updateButtonStatus();
            }
            if (this.mTableTreeViewer != null && this.mJavaBeanModelData != null) {
                this.mJavaBeanModelData.initializeRelationsToResolve();
                this.mTableTreeViewer.setInput((Object)this.mJavaBeanModelData);
                this.mTableTreeViewer.refresh();
            }
            this.mMethodLabel.setVisible(false);
            if (this.mAddHierarchyButton != null && this.mJavaBeanModelData != null) {
                this.mAddHierarchyButton.setSelection(this.mJavaBeanModelData.getAddHierarchy());
            }
        }
        super.setVisible(visible);
    }

    private void setDefaultSelection() {
        StructuredSelection selection;
        if (this.mtreeViewer.getSelection().isEmpty()) {
            if (this.mJavaBeanModelData.getModelClasses() == null || this.mJavaBeanModelData.getModelClasses().length == 0) {
                this.mJavaBeanDetailsPane.getComposite().setVisible(false);
            } else {
                this.mtreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.mJavaBeanModelData.getModelClasses()[0]));
            }
        }
        if (!(selection = (StructuredSelection)this.mtreeViewer.getSelection()).isEmpty() && selection.getFirstElement() instanceof JavaBeanModelClass) {
            this.mJavaBeanDetailsPane.getComposite().setVisible(true);
            JavaBeanModelClass modelClass = (JavaBeanModelClass)selection.getFirstElement();
            if (modelClass != null) {
                this.mSelectedClass = modelClass;
            }
            String[] modelClassNames = this.mJavaBeanModelData.getTargetModelClassNames(modelClass.getName());
            JavaBeanModelRelation[] relations = modelClass.getRelations();
            if (relations != null) {
                int i = 0;
                while (i < relations.length) {
                    relations[i].setModelClassNames(modelClassNames);
                    ++i;
                }
            }
            this.mJavaBeanModelData.identifyTargetClasses(modelClass);
            this.mPropertyViewer.setInput((Object)modelClass);
            JavaBeanModelProperty[] properties = modelClass.getProperties();
            if (properties != null) {
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].isSelected()) {
                        this.mPropertyViewer.setChecked((Object)properties[i], true);
                    }
                    ++i;
                }
            }
            this.mPropertyViewer.refresh();
            if (modelClass.getRelations() != null && modelClass.getRelations().length > 0) {
                this.mRelationsPane.getComposite().setVisible(true);
                this.mTableViewer.setInput((Object)modelClass);
                this.mTableViewer.refresh();
            } else {
                this.mRelationsPane.getComposite().setVisible(false);
                this.mMethodLabel.setVisible(false);
            }
            this.mJavaBeanModelData.initializeRelationsToResolve();
            this.mJavaBeanModelData.identifyTargetClasses(modelClass);
            this.mTableTreeViewer.setInput((Object)this.mJavaBeanModelData);
            this.mTableTreeViewer.refresh();
        }
    }

    private void addBeanClass(Object object) {
        if (object != null) {
            String javaBeanName = null;
            JavaBeanModelClass modelClass = null;
            StringBuffer buffer = new StringBuffer();
            if (object instanceof IType) {
                IType iType = (IType)object;
                javaBeanName = iType.getElementName();
                if (this.mJavaBeanModelData.getAddHierarchy()) {
                    JavaBeanModelClass[] modelClasses = null;
                    try {
                        modelClasses = JavaBeanAnalyser.initializeJBModelClasses((WebDynproRoot)this.mWebDynproRoot, (IType)iType);
                        if (modelClasses != null) {
                            int i = 0;
                            while (i < modelClasses.length) {
                                if (!iType.getFullyQualifiedName().equals(modelClasses[i].getTypeClass().getName())) {
                                    buffer.append(modelClasses[i].getName() + "\n");
                                }
                                this.mJavaBeanModelData.addModelClass(modelClasses[i]);
                                ++i;
                            }
                            modelClass = modelClasses[0];
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        modelClass = JavaBeanAnalyser.createJavaBeanModelClass((WebDynproRoot)this.mWebDynproRoot, (IType)iType);
                        this.mJavaBeanModelData.addModelClass(modelClass);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (object instanceof JavaBeanModelClass) {
                modelClass = (JavaBeanModelClass)object;
                javaBeanName = modelClass.getName();
                if (this.mJavaBeanModelData.getAddHierarchy()) {
                    Class[] classHierarchy = JavaBeanAnalyser.openHierarchy((Class)modelClass.getTypeClass());
                    JavaBeanModelClass beanClass = null;
                    if (classHierarchy != null) {
                        int i = 0;
                        while (i < classHierarchy.length) {
                            beanClass = this.mJavaBeanModelData.getJarBeanClass(classHierarchy[i]);
                            if (beanClass != null) {
                                this.mJavaBeanModelData.addModelClass(beanClass);
                                this.mJavaBeanModelData.removeJarClass(beanClass);
                                if (!modelClass.getTypeClass().equals(classHierarchy[i])) {
                                    buffer.append(beanClass.getName() + "\n");
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    this.mJavaBeanModelData.addModelClass(modelClass);
                    this.mJavaBeanModelData.removeJarClass(modelClass);
                }
            }
            if (modelClass != null) {
                this.mtreeViewer.setSelection((ISelection)new StructuredSelection((Object)modelClass));
            }
            this.mtreeViewer.refresh();
            this.setDefaultSelection();
            this.setErrorMessage(null);
            if (buffer.toString().trim().length() > 0) {
                String message = "Additional Beans added due to '" + javaBeanName + "':\n" + buffer.toString();
                if (this.mJavaBeanModelData.getNotifyHierarchyStatus()) {
                    this.displayMessage(message);
                }
            }
        }
    }

    private void displayMessage(String message) {
        if (message != null && message.trim().length() > 0) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)"Hierarchy", (String)message, null, (boolean)false);
            this.mJavaBeanModelData.setNotifyHierarchyStatus(!dialog.getToggleState());
        }
    }

    private void updateButtonStatus() {
        if (!(this.mJavaBeanModelData.getJavaBeanSource() != JavaBeanModelData.SOURCE_JAR_FILE && this.mJavaBeanModelData.getJavaBeanSource() != JavaBeanModelData.SOURCE_DC_PUBLIC_PART || this.mJavaBeanModelData.getJarClasses() != null && this.mJavaBeanModelData.getJarClasses().length != 0)) {
            this.mJavaBeanAddButton.setEnabled(false);
        } else {
            this.mJavaBeanAddButton.setEnabled(true);
        }
        if (this.mJavaBeanModelData.getModelClasses() == null || this.mJavaBeanModelData.getModelClasses().length == 0) {
            this.mJavaBeanRemoveButton.setEnabled(false);
        } else {
            this.mJavaBeanRemoveButton.setEnabled(true);
        }
    }

    public boolean validateSelection(JavaBeanModelClass modelClass) {
        if (modelClass != null) {
            JavaBeanModelRelation[] relations;
            JavaBeanModelProperty[] properties = modelClass.getProperties();
            if (properties != null) {
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].isSelected()) {
                        return true;
                    }
                    ++i;
                }
            }
            if ((relations = modelClass.getRelations()) != null) {
                int i = 0;
                while (i < relations.length) {
                    if (relations[i].isSelected()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    private String isPageValid() {
        JavaBeanModelClass[] modelClasses = this.mJavaBeanModelData.getModelClasses();
        if (modelClasses != null) {
            int i = 0;
            while (i < modelClasses.length) {
                if (!this.validateSelection(modelClasses[i])) {
                    return "Atleast one property or relation has to be selected for model class " + modelClasses[i].getName();
                }
                ++i;
            }
        }
        return null;
    }

    public void refreshPage() {
        this.mJavaBeanModelData.initializeRelationsToResolve();
        JavaBeanModelClass[] modelClasses = this.mJavaBeanModelData.getModelClasses();
        if (modelClasses != null) {
            int i = 0;
            while (i < modelClasses.length) {
                this.mJavaBeanModelData.identifyTargetClasses(modelClasses[i]);
                ++i;
            }
        }
        if (this.mtreeViewer != null) {
            this.mtreeViewer.refresh();
        }
        if (this.mTableViewer != null) {
            this.mTableViewer.refresh();
        }
        if (this.mModelRelationViewer != null && this.mModelRelationViewer.getTableViewer() != null) {
            this.mModelRelationViewer.getTableViewer().refresh();
        }
        if (this.mTableTreeViewer != null) {
            this.mTableTreeViewer.refresh();
        }
        if (this.mPropertyViewer != null) {
            this.mPropertyViewer.refresh();
        }
    }

    public void dispose() {
        if (this.mLabelFont != null) {
            this.mLabelFont.dispose();
        }
        super.dispose();
    }

    class ColumnContentProvider
    extends WorkbenchContentProvider {
        private JavaBeanModelData mJavaBeanModelData;
        private Object[] EMPTY_ARRAY = new Object[0];

        public ColumnContentProvider(JavaBeanModelData mData) {
            this.mJavaBeanModelData = mData;
        }

        public Object[] getElements(Object parent) {
            return this.mJavaBeanModelData.getModelClassesForRelationResolution();
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = this.EMPTY_ARRAY;
            if (parentElement instanceof JavaBeanModelClass) {
                return ((JavaBeanModelClass)parentElement).getRelations();
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof JavaBeanModelData || parent instanceof JavaBeanModelClass;
        }

        public Object getParent(Object element) {
            if (element instanceof JavaBeanModelRelation) {
                return ((JavaBeanModelRelation)element).getParent();
            }
            return null;
        }
    }
}

