/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageAddJavaBeanDetails;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Item;

public class JavaBeanRelationCellModifier
implements ICellModifier {
    private WizardPage mWizardPage;
    private StructuredViewer mViewer;
    private Object[] mColumnProperties;
    private CellEditor[] mCellEditors;
    private Object mElement;
    private String mProperty;

    public JavaBeanRelationCellModifier(WizardPage page, TableViewer viewer) {
        this.mWizardPage = page;
        this.mViewer = viewer;
        this.mColumnProperties = viewer.getColumnProperties();
        this.mCellEditors = viewer.getCellEditors();
    }

    public JavaBeanRelationCellModifier(WizardPage page, TableTreeViewer viewer) {
        this.mWizardPage = page;
        this.mViewer = viewer;
        this.mColumnProperties = viewer.getColumnProperties();
        this.mCellEditors = viewer.getCellEditors();
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof JavaBeanModelClass) {
            return false;
        }
        if (element instanceof JavaBeanModelRelation) {
            if (property.equals(JavaBeanModelData.MODEL_STATUS)) {
                return true;
            }
            if (property.equals(JavaBeanModelData.MODEL_MODEL_CLASS)) {
                this.updateModelClassNames(element, property);
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof JavaBeanModelClass) {
            return null;
        }
        JavaBeanModelRelation relation = (JavaBeanModelRelation)element;
        this.mElement = element;
        this.mProperty = property;
        if (property.equals(JavaBeanModelData.MODEL_STATUS)) {
            relation.setSelected(!relation.isSelected());
            return new Boolean(relation.isSelected());
        }
        if (property.equals(JavaBeanModelData.MODEL_RELATION_NAME)) {
            return relation.getRelationName();
        }
        if (property.equals(JavaBeanModelData.MODEL_SOURCE_ROLE)) {
            return relation.getSourceRole();
        }
        if (property.equals(JavaBeanModelData.MODEL_TARGET_ROLE)) {
            return relation.getTargetRole();
        }
        if (property.equals(JavaBeanModelData.MODEL_MODEL_CLASS)) {
            return new Integer(relation.getModelClassNameIndex());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void modify(Object element, String property, Object value) {
        if (element instanceof JavaBeanModelClass) {
            return;
        }
        Item item = (Item)element;
        Object data = item.getData();
        if (data instanceof JavaBeanModelClass) {
            return;
        }
        JavaBeanModelRelation relation = (JavaBeanModelRelation)data;
        if (this.mProperty != null && this.mElement != null && this.mProperty.equals(property) && !this.mElement.equals(relation)) {
            return;
        }
        if (property.equals(JavaBeanModelData.MODEL_STATUS)) {
            relation.setSelected((Boolean)value == false);
            if (relation.getParent() != null) {
                relation.getParent().updateNeedToResolve();
            }
        } else if (property.equals(JavaBeanModelData.MODEL_MODEL_CLASS)) {
            int index = (Integer)value;
            relation.setModelClassName(index);
            if (index > 0) {
                boolean valid = true;
                if (!valid) {
                    relation.setValid(false);
                    this.mWizardPage.setErrorMessage("Invalid Target Class for relation " + relation.getRelationName());
                    this.mWizardPage.setPageComplete(false);
                    this.mViewer.refresh();
                    return;
                }
                relation.setResolved(true);
                if (relation.getParent() != null) {
                    relation.getParent().updateNeedToResolve();
                }
            } else {
                relation.setResolved(false);
                if (relation.getParent() != null) {
                    relation.getParent().updateNeedToResolve();
                }
            }
        }
        String errMsg = this.areRelationResolutionsValid();
        this.mWizardPage.setErrorMessage(errMsg);
        this.mWizardPage.setPageComplete(errMsg == null);
        this.mViewer.refresh();
        if (this.mWizardPage instanceof PageAddJavaBeanDetails) {
            ((PageAddJavaBeanDetails)this.mWizardPage).refreshPage();
        }
    }

    private void updateModelClassNames(Object element, String property) {
        if (element != null && property != null && element instanceof JavaBeanModelRelation && this.mColumnProperties != null) {
            int i = 0;
            while (i < this.mColumnProperties.length) {
                if (this.mColumnProperties[i] instanceof String && this.mColumnProperties[i].equals(JavaBeanModelData.MODEL_MODEL_CLASS) && this.mCellEditors[i] instanceof ComboBoxCellEditor) {
                    ComboBoxCellEditor combo = (ComboBoxCellEditor)this.mCellEditors[i];
                    combo.setItems(((JavaBeanModelRelation)element).getModelClassNames());
                    this.mViewer.refresh();
                }
                ++i;
            }
        }
    }

    private String areRelationResolutionsValid() {
        if (this.mViewer != null && this.mViewer.getInput() != null) {
            JavaBeanModelClass modelClass;
            JavaBeanModelRelation[] relations;
            Object input = this.mViewer.getInput();
            if (input instanceof JavaBeanModelData) {
                return ((JavaBeanModelData)input).areRelationResolutionsValid();
            }
            if (input instanceof JavaBeanModelClass && (relations = (modelClass = (JavaBeanModelClass)input).getRelations()) != null) {
                int i = 0;
                while (i < relations.length) {
                    if (relations[i].isSelected() && !relations[i].isValid()) {
                        return "Invalid Target Class for relation " + relations[i].getRelationName();
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

