/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation;

import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.AbstractModelWizardPage;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizardData;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.io.File;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PageXMIImportDetails
extends AbstractModelWizardPage {
    private static final String PATH = AbstractModelWizardPage.mTPool.getText(409);
    private Text mXmiPathField;
    private Button mFileDialogButton;

    public PageXMIImportDetails(ModelWizardData data, WebDynproRoot webDynproRoot) {
        super(AbstractModelWizardPage.mTPool.getText(305), AbstractModelWizardPage.mTPool.getText(305), AbstractModelWizardPage.mTPool.getText(204), data, webDynproRoot);
    }

    protected void createControlExtended(IGridLayoutPane wizardPane) {
        wizardPane.addHorizontalSeparator();
        wizardPane.addTextLabel(TextPool.getInstance().getText(409));
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false, 2, 1);
        this.mXmiPathField = wizardPane.addTextField(this.mWizardData.getXMIPath(), false, gridLayoutData);
        this.mXmiPathField.addModifyListener((ModifyListener)new XmiPathModifyListener());
        this.mFileDialogButton = wizardPane.addPushButton(this.BROWSE);
        this.mFileDialogButton.addSelectionListener((SelectionListener)new FileDialogButtonListener());
    }

    public IWizardPage getPreviousPage() {
        return this.mWizardData.getPageSelect();
    }

    public void resetFields() {
        super.resetFields();
        if (this.mXmiPathField.getText().length() > 0) {
            this.mXmiPathField.setText("");
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.mWizardData.getXMIPath() != null && this.mWizardData.getXMIPath().length() > 0;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    private boolean validateXmiPath(String xmiPath) {
        if (xmiPath.length() > 0) {
            if (xmiPath.lastIndexOf(".xmi") != -1 || xmiPath.lastIndexOf(".xml") != -1) {
                File file = new File(xmiPath);
                if (file.exists()) {
                    if (file.canRead()) {
                        return true;
                    }
                    this.setErrorMessage(AbstractModelWizardPage.mCPool.getText(13));
                } else {
                    this.setErrorMessage(AbstractModelWizardPage.mCPool.getText(14, (Object)this.mXmiPathField.getText()));
                }
            } else {
                this.setErrorMessage(AbstractModelWizardPage.mCPool.getText(15, (Object)this.mXmiPathField.getText()));
            }
        } else {
            this.setErrorMessage(AbstractModelWizardPage.mTPool.getText(3, (Object)this.mXmiPathField.getText()));
        }
        return false;
    }

    class FileDialogButtonListener
    implements SelectionListener {
        FileDialogButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dialog = new FileDialog(shell, 4096);
            dialog.setFilterExtensions(new String[]{"*.xmi; *.xml"});
            String fileName = dialog.open();
            if (fileName != null) {
                PageXMIImportDetails.this.mXmiPathField.setText(fileName);
            }
        }
    }

    class XmiPathModifyListener
    implements ModifyListener {
        XmiPathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String xmiPath = PageXMIImportDetails.this.mXmiPathField.getText();
            if (PageXMIImportDetails.this.validateXmiPath(xmiPath)) {
                PageXMIImportDetails.this.mWizardData.setXMIPath(xmiPath);
                PageXMIImportDetails.this.setErrorMessage(null);
            }
        }
    }
}

