/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation;

import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.AbstractModelWizardPage;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizardData;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PageJavaBeanImportDetails
extends AbstractModelWizardPage {
    private Button mJarButton;
    private Button mFinderButton;
    private Button mDCButton;
    private Label mJarPathlabel;
    private Text mJarPathField;
    private Button mAssociatedProjectsButton;
    private Button mFileDialogButton;
    private Button mJarDesignTimeButton;
    private Button mJarDeployTimeButton;
    private Combo mPublicPartCombo;
    private Label mPublicPartLabel;
    private IGridLayoutPane mJarOptionPane;
    private JavaBeanModelData mJavaBeanModelData;
    private WebDynproRoot mWebDynproRoot;
    private boolean mJarChanged;

    public PageJavaBeanImportDetails(ModelWizardData data, WebDynproRoot webDynproRoot) {
        super(TextPool.getInstance().getText(362), TextPool.getInstance().getText(362), TextPool.getInstance().getText(233), data, webDynproRoot);
        this.mJavaBeanModelData = data.getJavaBeanModelData();
        this.mWebDynproRoot = webDynproRoot;
        this.isDCProject();
    }

    protected void createControlExtended(IGridLayoutPane wizardPane) {
        wizardPane.addHorizontalSeparator();
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false, 3, 1);
        wizardPane.addTextLabel("Select JavaBean Source", gridLayoutData);
        wizardPane.addPlaceholder();
        if (this.mJavaBeanModelData.isDCProject()) {
            this.addAssociatedProjectOption(wizardPane);
            this.addDCPPOption(wizardPane);
        } else {
            this.addAssociatedProjectOption(wizardPane);
            this.addJarFileOption(wizardPane);
        }
    }

    private void addAssociatedProjectOption(IGridLayoutPane layoutPane) {
        IGridLayoutData gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mFinderButton = layoutPane.addRadioButton("project(source folder)", gridLayoutData);
        this.mFinderButton.setSelection(true);
        this.mFinderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PageJavaBeanImportDetails.this.mFinderButton.getSelection()) {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setJavaBeanSource(JavaBeanModelData.SOURCE_CLASS_FINDER);
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setProjectSourceOption(JavaBeanModelData.ONLY_SOURCE_FOLDERS);
                    if (!PageJavaBeanImportDetails.this.mJavaBeanModelData.isDCProject()) {
                        PageJavaBeanImportDetails.this.mAssociatedProjectsButton.setEnabled(true);
                        PageJavaBeanImportDetails.this.mAssociatedProjectsButton.setSelection(false);
                    }
                    PageJavaBeanImportDetails.this.setPageComplete(true);
                    if (PageJavaBeanImportDetails.this.isPageComplete()) {
                        PageJavaBeanImportDetails.this.setPageComplete(true);
                    }
                } else if (!PageJavaBeanImportDetails.this.mFinderButton.getSelection()) {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setProjectSourceOption(JavaBeanModelData.ONLY_SOURCE_FOLDERS);
                    PageJavaBeanImportDetails.this.mAssociatedProjectsButton.setEnabled(false);
                    PageJavaBeanImportDetails.this.mAssociatedProjectsButton.setSelection(false);
                    PageJavaBeanImportDetails.this.setPageComplete(false);
                }
            }
        });
        layoutPane.addPlaceholder();
        layoutPane.addPlaceholder();
        gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 2, 1);
        this.mAssociatedProjectsButton = layoutPane.addCheckBox("include associated projects", false, gridLayoutData);
        layoutPane.addPlaceholder();
        if (this.mJavaBeanModelData.isDCProject()) {
            this.mAssociatedProjectsButton.setEnabled(false);
        }
        this.mAssociatedProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PageJavaBeanImportDetails.this.mAssociatedProjectsButton.getSelection()) {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setProjectSourceOption(JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO);
                } else {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setProjectSourceOption(JavaBeanModelData.ONLY_SOURCE_FOLDERS);
                }
                PageJavaBeanImportDetails.this.mJavaBeanModelData.removeAllModelClasses();
            }
        });
    }

    private void addJarFileOption(IGridLayoutPane layoutPane) {
        IGridLayoutData gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mJarButton = layoutPane.addRadioButton("local JAR file", gridLayoutData);
        layoutPane.addPlaceholder();
        this.mJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PageJavaBeanImportDetails.this.mJarButton.getSelection()) {
                    PageJavaBeanImportDetails.this.mJarPathlabel.setEnabled(false);
                    PageJavaBeanImportDetails.this.mJarPathField.setText("");
                    PageJavaBeanImportDetails.this.mJarPathField.setToolTipText("");
                    PageJavaBeanImportDetails.this.mJarPathField.setEnabled(false);
                    PageJavaBeanImportDetails.this.mFileDialogButton.setEnabled(false);
                    PageJavaBeanImportDetails.this.mJarDesignTimeButton.setEnabled(false);
                    PageJavaBeanImportDetails.this.mJarDeployTimeButton.setEnabled(false);
                    if (PageJavaBeanImportDetails.this.isPageComplete()) {
                        PageJavaBeanImportDetails.this.setPageComplete(true);
                    }
                } else {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setJavaBeanSource(JavaBeanModelData.SOURCE_JAR_FILE);
                    PageJavaBeanImportDetails.this.mJarPathField.setText("");
                    PageJavaBeanImportDetails.this.mJarPathField.setToolTipText("");
                    PageJavaBeanImportDetails.this.mJarPathlabel.setEnabled(true);
                    PageJavaBeanImportDetails.this.mJarPathField.setEnabled(true);
                    PageJavaBeanImportDetails.this.mFileDialogButton.setEnabled(true);
                    PageJavaBeanImportDetails.this.mJarDesignTimeButton.setEnabled(true);
                    PageJavaBeanImportDetails.this.mJarDeployTimeButton.setEnabled(true);
                    PageJavaBeanImportDetails.this.setPageComplete(false);
                }
            }
        });
        gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mJarOptionPane = layoutPane.addGridLayoutPane(" JAR Details ", 3, false, gridLayoutData);
        this.mJarOptionPane.setSpacing(10, 10);
        this.mJarPathlabel = this.mJarOptionPane.addTextLabel("Jar Path");
        this.mJarPathlabel.setEnabled(false);
        gridLayoutData = this.mJarOptionPane.createGridLayoutData(4, 1, true, false);
        this.mJarPathField = this.mJarOptionPane.addTextField("", false, gridLayoutData);
        this.mJarPathField.setEditable(false);
        this.mFileDialogButton = this.mJarOptionPane.addPushButton(this.BROWSE);
        this.mFileDialogButton.addSelectionListener((SelectionListener)new FileDialogButtonListener());
        this.mFileDialogButton.setEnabled(false);
        gridLayoutData = this.mJarOptionPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mJarDesignTimeButton = this.mJarOptionPane.addRadioButton("Design Time (compile time dependency only, JAR will be deployed using a different deployable unit)", gridLayoutData);
        this.mJarDesignTimeButton.setSelection(true);
        this.mJarDesignTimeButton.setEnabled(false);
        this.mJavaBeanModelData.setJARDependency(JavaBeanModelData.DESIGN_TIME_DEPENDENCY);
        this.mJarDesignTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageJavaBeanImportDetails.this.setJARDependency();
            }
        });
        gridLayoutData = this.mJarOptionPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mJarDeployTimeButton = this.mJarOptionPane.addRadioButton("Deploy Time (JAR will be deployed as part of this deployable unit)", gridLayoutData);
        this.mJarDeployTimeButton.setEnabled(false);
        this.mJarDeployTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageJavaBeanImportDetails.this.setJARDependency();
            }
        });
    }

    private void setJARDependency() {
        boolean design = this.mJarDesignTimeButton.getSelection();
        boolean deploy = this.mJarDeployTimeButton.getSelection();
        if (design && deploy) {
            this.mJavaBeanModelData.setJARDependency(JavaBeanModelData.DESIGN_TIME_DEPENDENCY & JavaBeanModelData.DEPLOY_TIME_DEPENDENCY);
        } else if (design) {
            this.mJavaBeanModelData.setJARDependency(JavaBeanModelData.DESIGN_TIME_DEPENDENCY);
        } else if (deploy) {
            this.mJavaBeanModelData.setJARDependency(JavaBeanModelData.DEPLOY_TIME_DEPENDENCY);
        } else {
            this.mJavaBeanModelData.setJARDependency(-1);
        }
    }

    private void addDCPPOption(IGridLayoutPane layoutPane) {
        IGridLayoutData gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mDCButton = layoutPane.addRadioButton("public parts of used DCs", gridLayoutData);
        layoutPane.addPlaceholder();
        this.mPublicPartLabel = layoutPane.addTextLabel("Used Public Parts");
        gridLayoutData = layoutPane.createGridLayoutData(4, 1, true, false, 2, 1);
        String[] parts = this.mJavaBeanModelData.getUsedPublicParts();
        this.mPublicPartCombo = layoutPane.addComboBox(parts, "", true, gridLayoutData);
        this.mPublicPartCombo.setText("");
        this.mPublicPartCombo.setEnabled(false);
        this.mDCButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PageJavaBeanImportDetails.this.mDCButton.getSelection()) {
                    PageJavaBeanImportDetails.this.mPublicPartCombo.setText("");
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.selectUsedPublicPart("");
                    if (PageJavaBeanImportDetails.this.isPageComplete()) {
                        PageJavaBeanImportDetails.this.setPageComplete(true);
                    }
                } else {
                    PageJavaBeanImportDetails.this.mJavaBeanModelData.setJavaBeanSource(JavaBeanModelData.SOURCE_DC_PUBLIC_PART);
                    PageJavaBeanImportDetails.this.setPageComplete(false);
                }
                PageJavaBeanImportDetails.this.mPublicPartCombo.setEnabled(PageJavaBeanImportDetails.this.mDCButton.getSelection());
            }
        });
        this.mPublicPartCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = PageJavaBeanImportDetails.this.mPublicPartCombo.getText();
                String oldJarPath = PageJavaBeanImportDetails.this.mJavaBeanModelData.getJarPath();
                String jarPath = PageJavaBeanImportDetails.this.mJavaBeanModelData.selectUsedPublicPart(selection);
                if (jarPath != null) {
                    if (!jarPath.equals(oldJarPath)) {
                        PageJavaBeanImportDetails.this.mJarChanged = true;
                    }
                    PageJavaBeanImportDetails.this.setPageComplete(true);
                    if (PageJavaBeanImportDetails.this.isPageComplete()) {
                        PageJavaBeanImportDetails.this.setPageComplete(true);
                    }
                } else {
                    if (oldJarPath != null) {
                        PageJavaBeanImportDetails.this.mJarChanged = true;
                    }
                    PageJavaBeanImportDetails.this.setPageComplete(false);
                }
            }
        });
    }

    public boolean canFlipToNextPage() {
        if (super.isPageComplete()) {
            if (this.mFinderButton.getSelection()) {
                return true;
            }
            if (this.mJavaBeanModelData.isDCProject() ? this.mDCButton.getSelection() && this.mJavaBeanModelData.getJarPath() != null : this.mJarButton.getSelection() && this.mJarPathField.getText() != null && this.mJarPathField.getText().trim().length() > 0) {
                return true;
            }
        }
        return false;
    }

    private void isDCProject() {
        if (this.mWebDynproRoot != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynproRoot.getMetamodel().getName());
            try {
                if (project != null && project.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                    this.mJavaBeanModelData.isDCProject(true);
                    this.mJavaBeanModelData.initializeDCPublicParts(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            if (this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_CLASS_FINDER) {
                return true;
            }
            if (this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_JAR_FILE ? this.mJarPathField.getText() != null && this.mJarPathField.getText().trim().length() > 0 : this.mJavaBeanModelData.getJavaBeanSource() == JavaBeanModelData.SOURCE_DC_PUBLIC_PART && this.mJavaBeanModelData.getJarPath() != null) {
                return true;
            }
        }
        return false;
    }

    public boolean hasJarChanged() {
        return this.mJarChanged;
    }

    public void setVisible(boolean visible) {
        this.mJarChanged = false;
        super.setVisible(visible);
    }

    class FileDialogButtonListener
    implements SelectionListener {
        FileDialogButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dialog = new FileDialog(shell, 4096);
            dialog.setFilterExtensions(new String[]{"*.jar"});
            String fileName = dialog.open();
            if (fileName != null) {
                if (!fileName.equals(PageJavaBeanImportDetails.this.mJavaBeanModelData.getJarPath())) {
                    PageJavaBeanImportDetails.this.mJarChanged = true;
                }
                PageJavaBeanImportDetails.this.mJarPathField.setText(fileName);
                PageJavaBeanImportDetails.this.mJarPathField.setToolTipText(fileName);
                PageJavaBeanImportDetails.this.mJavaBeanModelData.setJarPath(fileName);
                PageJavaBeanImportDetails.this.setPageComplete(true);
                PageJavaBeanImportDetails.this.setErrorMessage(null);
            } else {
                PageJavaBeanImportDetails.this.setPageComplete(false);
            }
        }
    }
}

