/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation;

import com.sap.ide.jcb.core.service.IR3Service;
import com.sap.ide.jcb.core.service.connection.ConnectionFailedException;
import com.sap.ide.jcb.core.service.generation.GenerationException;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.IGenerationManager;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.wizardpages.CoolSelectionPage;
import com.sap.ide.jcb.core.wizardpages.RFCSelectionPage;
import com.sap.ide.jcb.core.wizardpages.SAPLogonPage;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.importers.cool.CoolModelImporter;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelImporter;
import com.sap.ide.metamodel.importers.javabean.JavaBeanResourceImporter;
import com.sap.ide.metamodel.importers.rfcmodel.DynamicRFCModelImporter;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.DynamicRFCModelReimporter;
import com.sap.ide.metamodel.importers.rfcmodel.upgrade.DynamicRFCModelConverter;
import com.sap.ide.metamodel.importers.webservice.WebServiceModelImporter;
import com.sap.ide.metamodel.importers.xmi.XMIImporter;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizardData;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageCoolImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageDynRFCImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageImportLog;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageJavaBeanImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageRFCImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageRuntimeRepositoryModelDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageSelectModelType;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageWebServiceImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageXMIImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageAddJavaBeanDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageSelectJavaBeansFinder;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageSelectJavaBeansJar;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.projectproperties.WDProjectPropertiesUtil;
import com.sap.ide.webdynpro.service.modeleditor.ModelService;
import com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceCreation;
import com.sap.ide.webdynpro.service.modeleditor.ServiceDeletion;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.wsproxy.wizards.prx.pages.NamespacePackageMappingPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlAbstractSelectionPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlLocalFileClientPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlLocalServerClientPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlPageI;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlUddiClientPage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ModelWizard
extends Wizard
implements INewWizard {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String MODEL_IMPORT_WIZARD_SECTION = "Model Import Wizard";
    private WebDynproRoot mWebDynproRoot;
    private DtDictionaryRoot mDictionaryRoot;
    private Model mModel;
    private ModelWizardData mData;
    private boolean mIsUpdateMode = false;

    public ModelWizard(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(mTPool.getText(355));
        this.mWebDynproRoot = webDynproRoot;
        this.mDictionaryRoot = dictionaryRoot;
        this.mData = new ModelWizardData(webDynproRoot);
    }

    public ModelWizard(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot, int operationType, Model model) {
        this.setNeedsProgressMonitor(true);
        if (operationType == 2) {
            this.setWindowTitle(mTPool.getText(358));
        } else if (operationType == 3) {
            this.setWindowTitle(mTPool.getText(360));
        } else {
            this.setWindowTitle(mTPool.getText(355));
        }
        this.mWebDynproRoot = webDynproRoot;
        this.mDictionaryRoot = dictionaryRoot;
        this.mData = new ModelWizardData(webDynproRoot, operationType, model);
    }

    public boolean performFinish() {
        if (this.mData.getOperationType() == 2 && this.mData.getModelType() == 0) {
            this.mModel = this.mData.getDynamicRFCModelReimporter().reImport();
            if (this.mModel != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Reimport", (String)"Adaptive RFC Reimport could lead to inconsistence of R/3 metadata cashed on the J2EE server. Business data might get corrupted in that case.\n\nIt is recommended to restart the J2EE server.");
            }
            return true;
        }
        if (this.mData.getOperationType() == 3) {
            try {
                this.mModel = this.mData.getDynamicRFCModelConverter().convertToARFCModel();
                return true;
            }
            catch (Exception e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)"Failed to migrate rfc model", (Throwable)e, (boolean)false);
                return false;
            }
        }
        if (this.mData.getModelType() == 1) {
            try {
                this.mData.getPageSAPLogon().performFinish();
            }
            catch (ConnectionFailedException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish", (String)"performFinish for SAPLogon page failed", (Throwable)e, (boolean)true);
            }
        } else if (this.mData.getModelType() == 5) {
            try {
                this.mData.getPageSAPLogon().performFinish();
            }
            catch (ConnectionFailedException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish", (String)"performFinish for SAPLogon page failed", (Throwable)e, (boolean)true);
            }
            this.mData.getPageRfcSelection().performFinish();
            this.doImportRfcModel();
        } else if (this.mData.getModelType() == 3) {
            this.doCreateRuntimeRepositoryModel();
        } else if (this.mData.getModelType() == 0) {
            if (!this.addJcoReferences()) {
                return false;
            }
            try {
                this.mData.getPageSAPLogon().performFinish();
            }
            catch (ConnectionFailedException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish", (String)"performFinish for SAPLogon page failed", (Throwable)e, (boolean)true);
            }
            this.mData.getPageRfcSelection().performFinish();
        } else if (this.mData.getModelType() == 2) {
            this.doImportWebServiceModel();
        } else if (this.mData.getModelType() == 6) {
            JavaBeanModelData modelData;
            this.mData.getJavaBeanModelData().setImportStatus(true);
            this.doImportJavaBeanModel();
            if (this.mModel != null && (modelData = this.mData.getJavaBeanModelData()).getJavaBeanSource() == JavaBeanModelData.SOURCE_JAR_FILE) {
                JavaBeanResourceImporter resourceImporter = new JavaBeanResourceImporter(this.mWebDynproRoot, modelData.getJarPath(), this.getShell());
                int type = modelData.getJARDependency();
                boolean status = true;
                if (type == JavaBeanModelData.DESIGN_TIME_DEPENDENCY) {
                    resourceImporter.addToRawClassPath();
                } else {
                    resourceImporter.importResource();
                    resourceImporter.addToRawClassPath();
                }
            }
        }
        if (this.mModel != null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ModelService.generateModel((Model)ModelWizard.this.mModel, (IProgressMonitor)monitor);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(false, false, op);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)"Failed to generate Model", (Throwable)e.getTargetException(), (boolean)false);
                return false;
            }
        }
        return true;
    }

    public void addPages() {
        WizardPage page = null;
        if (this.mData.getOperationType() == 2 || this.mData.getOperationType() == 3) {
            this.mData.setModelType(0);
            this.addSapLogonPage();
        }
        page = new PageSelectModelType(this.mData, this.mWebDynproRoot);
        this.mData.setPageSelect((PageSelectModelType)page);
        this.addPage((IWizardPage)page);
        page = new PageXMIImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageXmiImport((PageXMIImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageImportLog(this.mData);
        this.mData.setPageImportLog((PageImportLog)page);
        this.addPage((IWizardPage)page);
        page = new RFCSelectionPage();
        this.mData.setPageRfcSelection((RFCSelectionPage)page);
        page.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.addPage((IWizardPage)page);
        page = new CoolSelectionPage();
        this.mData.setPageCoolSelection((CoolSelectionPage)page);
        page.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.addPage((IWizardPage)page);
        page = new PageRFCImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageRfcImport((PageRFCImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageCoolImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageCoolImport((PageCoolImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageRuntimeRepositoryModelDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageCreateRuntimeRepository((PageRuntimeRepositoryModelDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageDynRFCImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageDynRfcImport((PageDynRFCImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageWebServiceImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageWebService((PageWebServiceImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new WsdlLocalServerClientPage();
        this.mData.setPageLocalServerWsdl((WsdlPageI)((WsdlLocalServerClientPage)page));
        this.addPage((IWizardPage)page);
        page = new WsdlUddiClientPage();
        this.mData.setPageUddiServerWsdl((WsdlPageI)((WsdlUddiClientPage)page));
        this.addPage((IWizardPage)page);
        page = new WsdlLocalFileClientPage();
        this.mData.setPageFileSystemWsdl((WsdlPageI)((WsdlLocalFileClientPage)page));
        this.addPage((IWizardPage)page);
        page = new NamespacePackageMappingPage();
        this.mData.setPageNamespacePackageMapping((NamespacePackageMappingPage)page);
        this.addPage((IWizardPage)page);
        this.mData.setJavaBeanModelData(new JavaBeanModelData(this.mData.getModelName()));
        page = new PageJavaBeanImportDetails(this.mData, this.mWebDynproRoot);
        this.mData.setPageJavaBean((PageJavaBeanImportDetails)page);
        this.addPage((IWizardPage)page);
        page = new PageSelectJavaBeansFinder(this.mWebDynproRoot, this.mData.getJavaBeanModelData());
        this.mData.setPageSelectJavaBeansFinder((PageSelectJavaBeansFinder)page);
        this.addPage((IWizardPage)page);
        page = new PageSelectJavaBeansJar(this.mWebDynproRoot, this.mData.getJavaBeanModelData());
        this.mData.setPageSelectJavaBeansJar((PageSelectJavaBeansJar)page);
        this.addPage((IWizardPage)page);
        page = new PageAddJavaBeanDetails(this.mWebDynproRoot, this.mData.getJavaBeanModelData());
        this.mData.setPageAddJavaBeanDetails((PageAddJavaBeanDetails)page);
        this.addPage((IWizardPage)page);
        if (this.mData.getOperationType() != 2 && this.mData.getOperationType() != 3) {
            this.addSapLogonPage();
        }
    }

    public void createPageControls(Composite pageContainer) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (!(page instanceof PageSelectJavaBeansFinder) && !(page instanceof PageSelectJavaBeansJar)) {
                page.createControl(pageContainer);
                Assert.isNotNull((Object)page.getControl());
            }
            ++i;
        }
    }

    public boolean canFinish() {
        if (this.mData.getOperationType() == 2) {
            return this.mData.getPageSAPLogon().isPageComplete() && this.mData.getPageImportLog().isPageComplete();
        }
        if (this.mData.getModelType() == 5) {
            return this.mData.getPageRfcImport().isPageComplete() && this.mData.getPageSAPLogon().isPageComplete() && this.mData.getPageRfcSelection().isPageComplete();
        }
        if (this.mData.getModelType() == 4) {
            return this.mData.getPageImportLog().isPageComplete();
        }
        if (this.mData.getModelType() == 1) {
            return this.mData.getPageImportLog().isPageComplete();
        }
        if (this.mData.getModelType() == 3) {
            return this.mData.getPageCreateRuntimeRepository().isPageComplete();
        }
        if (this.mData.getModelType() == 0) {
            return this.mData.getPageImportLog().isPageComplete();
        }
        if (this.mData.getModelType() == 2) {
            return this.mData.getPageWebService().isPageComplete() && this.mData.getCurrentWsdlPage() != null && this.mData.getCurrentWsdlPage().isPageComplete() && this.mData.getPageNamespacePackageMapping().isPageComplete();
        }
        if (this.mData.getModelType() == 6) {
            if (this.mData.getJavaBeanModelData().getModelClasses() != null && this.mData.getJavaBeanModelData().getModelClasses().length > 0 && !this.mData.getJavaBeanModelData().needToResolveRelations()) {
                try {
                    JavaBeanModelImporter importer = new JavaBeanModelImporter(this.mDictionaryRoot, this.mWebDynproRoot, this.mData.getJavaBeanModelData());
                    boolean status = importer.getImportStatus(this.mData.getModelPackage(), this.mData.getModelName(), this.mData.getSourcePathIdentifier());
                    return status;
                }
                catch (Exception e1) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.setDefaultPageImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
    }

    public boolean performCancel() {
        if (this.mData.getOperationType() == 2 && this.mData.getModelType() == 0) {
            if (null == this.mData.getDynamicRFCModelReimporter()) {
                return super.performCancel();
            }
            this.mData.getDynamicRFCModelReimporter().doRollBack();
            return super.performCancel();
        }
        this.deleteModel();
        return super.performCancel();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = null;
        if ((this.mData.getOperationType() == 2 || this.mData.getOperationType() == 3) && page instanceof PageSelectModelType) {
            nextPage = this.mData.getPageSAPLogon();
            return nextPage;
        }
        if (page instanceof PageSelectModelType) {
            switch (this.mData.getModelType()) {
                case 5: {
                    nextPage = this.mData.getPageRfcImport();
                    break;
                }
                case 4: {
                    nextPage = this.mData.getPageXmiImport();
                    break;
                }
                case 1: {
                    nextPage = this.mData.getPageCoolImport();
                    break;
                }
                case 3: {
                    nextPage = this.mData.getPageCreateRuntimeRepository();
                    break;
                }
                case 0: {
                    nextPage = this.mData.getPageDynRfcImport();
                    break;
                }
                case 2: {
                    nextPage = this.mData.getPageWebService();
                    break;
                }
                case 6: {
                    nextPage = this.mData.getPageJavaBean();
                }
            }
        } else if (page instanceof PageXMIImportDetails) {
            nextPage = this.mData.getPageImportLog();
        } else if (page instanceof SAPLogonPage) {
            if (this.mData.getOperationType() == 2) {
                nextPage = this.mData.getPageRfcSelection();
                nextPage.setDescription(mTPool.getText(230));
                return nextPage;
            }
            if (this.mData.getOperationType() == 3) {
                DynamicRFCModelConverter converter = this.mData.getDynamicRFCModelConverter();
                this.mData.getPageDynRfcImport().setConverterSpecificInfo(converter.getModelName(), converter.getModelPackageName());
                nextPage = this.mData.getPageDynRfcImport();
                return nextPage;
            }
            switch (this.mData.getModelType()) {
                case 5: {
                    nextPage = this.mData.getPageRfcSelection();
                    break;
                }
                case 1: {
                    nextPage = this.mData.getPageCoolSelection();
                    nextPage.setDescription(mTPool.getText(231));
                    break;
                }
                case 0: {
                    nextPage = this.mData.getPageRfcSelection();
                    nextPage.setDescription(mTPool.getText(230));
                }
            }
        } else if (page instanceof RFCSelectionPage && this.mData.getModelType() == 0) {
            if (this.mData.getOperationType() == 2) {
                nextPage = this.mData.getPageImportLog();
                return nextPage;
            }
            nextPage = this.mData.getPageImportLog();
        } else if (page instanceof CoolSelectionPage) {
            nextPage = this.mData.getPageImportLog();
        } else {
            if (page instanceof PageWebServiceImportDetails) {
                return ((PageWebServiceImportDetails)page).getNextPage();
            }
            if (page instanceof WsdlAbstractSelectionPage || page instanceof WsdlLocalServerClientPage) {
                this.mData.getPageNamespacePackageMapping().init(((WsdlPageI)page).getWSDLUrl(), this.mData.getWebServicesProxyPackageName());
                return this.mData.getPageNamespacePackageMapping();
            }
            if (page instanceof PageJavaBeanImportDetails) {
                this.mData.getJavaBeanModelData().setModelName(this.mData.getModelName());
                if (this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_CLASS_FINDER) {
                    return this.mData.getPageSelectJavaBeansFinder();
                }
                if (this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_JAR_FILE) {
                    return this.mData.getPageSelectJavaBeansJar();
                }
                if (this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_DC_PUBLIC_PART) {
                    return this.mData.getPageSelectJavaBeansJar();
                }
            } else {
                if (page instanceof PageSelectJavaBeansFinder || page instanceof PageSelectJavaBeansJar) {
                    return this.mData.getPageAddJavaBeanDetails();
                }
                if (page instanceof PageAddJavaBeanDetails) {
                    this.mData.getJavaBeanModelData().setImportStatus(false);
                    return this.mData.getPageImportLog();
                }
            }
        }
        return nextPage;
    }

    public Model getModel() {
        return this.mModel;
    }

    boolean doImportRfcModel() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    block4: {
                        try {
                            IResource portType = ModelWizard.this.generateProxy(monitor);
                            if (portType == null) break block4;
                            ModelWizard.this.mModel = RfcModelImportService.doImport((WebDynproRoot)ModelWizard.this.mWebDynproRoot, (DtDictionaryRoot)ModelWizard.this.mDictionaryRoot, (String)ModelWizard.this.mData.getModelPackage(), (String)ModelWizard.this.mData.getModelName(), (SourcePathIdentifier)ModelWizard.this.mData.getSourcePathIdentifier(), (IResource)portType, (IGenerationData)ModelWizard.this.mData.getRfcGenerationData(), (IProgressMonitor)monitor);
                        }
                        catch (GenerationException e) {
                            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doImportRfcModel", (String)"RFC proxy generation failed", (Throwable)e, (boolean)false);
                            Object var4_5 = null;
                            monitor.done();
                            return;
                        }
                    }
                    Object var4_4 = null;
                    monitor.done();
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportRfcModel()", (String)"Failed to create RFC model", (Throwable)e.getTargetException(), (boolean)false);
        }
        return this.mModel != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doImportDynRfcModel() {
        block5: {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    DynamicRFCModelImporter importer;
                    block7: {
                        importer = null;
                        try {
                            try {
                                IWorkingSet workingSet = R3Service.getInstance().getWorkingSet();
                                ArrayList<String> rfcNames = new ArrayList<String>(workingSet.getSize());
                                Iterator iter = workingSet.getIterator();
                                while (true) {
                                    if (!iter.hasNext()) {
                                        ModelWizard.this.deleteModel();
                                        importer = new DynamicRFCModelImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot);
                                        ModelWizard.this.mModel = importer.doImport(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier(), ModelWizard.this.mData.getLogicalDictionaryName(), ModelWizard.this.mData.getModelDefaultLogicalSystem(), ModelWizard.this.mData.getMetadataDefaultLogicalSystem(), ModelWizard.this.mData.getDictionaryTypesPackage(), rfcNames.toArray(new String[rfcNames.size()]), monitor);
                                        break;
                                    }
                                    rfcNames.add(((IWorkingSetObject)iter.next()).getName());
                                }
                            }
                            catch (Exception e) {
                                ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doImportDynRfcModel()", (String)("Failed to create model " + ModelWizard.this.mData.getModelPackage() + ModelWizard.this.mData.getModelName()), (Throwable)e, (boolean)false);
                                Object var7_8 = null;
                                monitor.done();
                                break block7;
                            }
                            Object var7_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                    ModelWizard.this.mData.setImportLog(importer.getImportLog());
                }
            };
            try {
                try {
                    this.mWebDynproRoot.disableAutoNotify();
                    this.mDictionaryRoot.disableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                    this.getContainer().run(true, false, op);
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Object var5_3 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    return bl;
                }
                catch (InvocationTargetException e) {
                    ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportDynRfcModel()", (String)("Failed to create model " + this.mData.getModelPackage() + this.mData.getModelName()), (Throwable)e.getTargetException(), (boolean)false);
                    Object var5_4 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    break block5;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                throw throwable;
            }
            this.mWebDynproRoot.enableAutoNotify();
            this.mDictionaryRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
        }
        if (this.mModel == null) return false;
        return true;
    }

    public void initializeJavaBeanSource() throws Exception {
        if (this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_DC_PUBLIC_PART || this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_JAR_FILE) {
            if (this.mData.getPageJavaBean().hasJarChanged()) {
                try {
                    this.mData.getJavaBeanModelData().initializeJavaBeanSource(this.mWebDynproRoot);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String error = "Invalid Jar - No JavaBeans available for import";
                    throw new Exception(error);
                }
            }
        } else if (this.mData.getJavaBeanModelData().getJavaBeanSource() == JavaBeanModelData.SOURCE_CLASS_FINDER) {
            TypeInfo[] info = null;
            if (this.mData.getJavaBeanModelData().getProjectSourceOption() == JavaBeanModelData.ONLY_SOURCE_FOLDERS && !this.mData.getJavaBeanModelData().isOnlyProjectTypeInfoInitialized()) {
                try {
                    info = this.initializeJavaBeanInfo(JavaBeanModelData.ONLY_SOURCE_FOLDERS);
                    this.mData.getJavaBeanModelData().setOnlyProjectTypeInfo(info);
                    this.mData.getJavaBeanModelData().setOnlyProjectTypeInfoInitialized(true);
                }
                catch (Exception e) {
                    this.mData.getJavaBeanModelData().setOnlyProjectTypeInfo(null);
                    this.mData.getJavaBeanModelData().setOnlyProjectTypeInfoInitialized(false);
                    throw e;
                }
            }
            if (this.mData.getJavaBeanModelData().getProjectSourceOption() == JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO && !this.mData.getJavaBeanModelData().isCompleteProjectTypeInfoInitialized()) {
                try {
                    info = this.initializeJavaBeanInfo(JavaBeanModelData.ASSOCIATED_PROJECTS_ASLO);
                    this.mData.getJavaBeanModelData().setCompleteProjectTypeInfo(info);
                    this.mData.getJavaBeanModelData().setCompleteProjectTypeInfoInitialized(true);
                }
                catch (Exception e) {
                    this.mData.getJavaBeanModelData().setCompleteProjectTypeInfo(null);
                    this.mData.getJavaBeanModelData().setCompleteProjectTypeInfoInitialized(false);
                    throw e;
                }
            }
        }
    }

    private TypeInfo[] initializeJavaBeanInfo(int option) throws Exception {
        final ArrayList typeList = new ArrayList();
        ProgressMonitorDialog fRunnableContext = new ProgressMonitorDialog(this.getShell());
        final IJavaSearchScope fScope = this.mData.getJavaBeanModelData().getProjectSearchScope(this.mWebDynproRoot, option);
        boolean fElementKinds = false;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AllTypesCache.getTypes((IJavaSearchScope)fScope, (int)0, (IProgressMonitor)monitor, (Collection)typeList);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            fRunnableContext.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)"Error", (String)"No JavaBeans available for import");
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        if (typeList.isEmpty()) {
            throw new Exception("No JavaBeans available for import");
        }
        TypeInfo[] typeRefs = typeList.toArray(new TypeInfo[typeList.size()]);
        return typeRefs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doImportJavaBeanModel() {
        IRunnableWithProgress op = new IRunnableWithProgress(){
            static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$ModelService;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                JavaBeanModelImporter importer;
                block9: {
                    importer = null;
                    if (!ModelWizard.this.mData.getJavaBeanModelData().getImportStatus()) {
                        try {
                            importer = new JavaBeanModelImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot, ModelWizard.this.mData.getJavaBeanModelData());
                            importer.getImportStatus(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier());
                            ModelWizard.this.mData.setImportLog(importer.getImportLog());
                            return;
                        }
                        catch (Exception e1) {
                            System.out.println(e1.getMessage());
                        }
                        return;
                    }
                    try {
                        try {
                            ModelWizard.this.deleteModel();
                            importer = new JavaBeanModelImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot, ModelWizard.this.mData.getJavaBeanModelData());
                            monitor.beginTask("Import model", -1);
                            ModelWizard.this.mModel = importer.doImport(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier());
                        }
                        catch (Exception e) {
                            try {
                                boolean status = ModelWizard.this.mWebDynproRoot.hasModel(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName());
                                ModelWizard.this.mModel = ModelWizard.this.mWebDynproRoot.getModel(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName());
                                ModelWizard.this.deleteModel();
                            }
                            catch (LoadException e1) {
                                e1.printStackTrace();
                            }
                            ServiceModelEditorPlugin.internalError((Class)(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = 5.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService), (String)"doImportJavaBeanModel()", (String)("Failed to create model " + ModelWizard.this.mData.getModelPackage() + ModelWizard.this.mData.getModelName()), (Throwable)e, (boolean)true);
                            Object var6_6 = null;
                            monitor.done();
                            break block9;
                        }
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
                ModelWizard.this.mData.setImportLog(importer.getImportLog());
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        try {
            try {
                this.mWebDynproRoot.disableAutoNotify();
                this.mDictionaryRoot.disableAutoNotify();
                this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
                Object var5_3 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            catch (InvocationTargetException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportJavaBeanModel()", (String)("Failed to create model " + this.mData.getModelPackage() + this.mData.getModelName()), (Throwable)e.getTargetException(), (boolean)true);
                Object var5_4 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mWebDynproRoot.enableAutoNotify();
            this.mDictionaryRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
            throw throwable;
        }
        this.mWebDynproRoot.enableAutoNotify();
        this.mDictionaryRoot.enableAutoNotify();
        this.mWebDynproRoot.getMetamodel().enableAutoNotify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doImportCoolModel() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CoolModelImporter importer;
                block4: {
                    importer = null;
                    try {
                        try {
                            ModelWizard.this.deleteModel();
                            monitor.beginTask("Import model", -1);
                            importer = new CoolModelImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot);
                            importer.setUseSmartNames(true);
                            ModelWizard.this.mModel = importer.doImport(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier(), ModelWizard.this.mData.getPageCoolSelection().getServiceModuleDescriptor(), ModelWizard.this.mData.getGenerateModelLayer());
                        }
                        catch (Exception e) {
                            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doImportCoolModel", (String)"Error while importing Web Dynpro metadata from cool service module description", (Throwable)e, (boolean)true);
                            Object var5_4 = null;
                            monitor.done();
                            break block4;
                        }
                        Object var5_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
                ModelWizard.this.mData.setImportLog(importer.getImportLog());
            }
        };
        try {
            try {
                this.mWebDynproRoot.disableAutoNotify();
                this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
                Object var5_3 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            catch (InvocationTargetException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportCoolModel()", (String)"Failed to create Enterprise Services Model", (Throwable)e.getTargetException(), (boolean)false);
                Object var5_4 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mWebDynproRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
            throw throwable;
        }
        this.mWebDynproRoot.enableAutoNotify();
        this.mWebDynproRoot.getMetamodel().enableAutoNotify();
    }

    void doCreateRuntimeRepositoryModel() {
        this.deleteModel();
        this.mModel = ServiceCreation.createRuntimeRepositoryModel((WebDynproRoot)this.mWebDynproRoot, (String)this.mData.getModelPackage(), (String)this.mData.getModelName(), (SourcePathIdentifier)this.mData.getSourcePathIdentifier());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doImportWebServiceModel() {
        block5: {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    WebServiceModelImporter importer = null;
                    try {
                        try {
                            importer = new WebServiceModelImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot);
                            String sourceFolder = ModelWizard.this.mData.getSelectedRoot().getPath().removeFirstSegments(1).makeRelative().toString();
                            ModelWizard.this.mModel = importer.doImport(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier(), sourceFolder, ModelWizard.this.mData.getWebServicesProxyPackageName(), ModelWizard.this.mData.getPageNamespacePackageMapping().getWsdlUrl(), ModelWizard.this.mData.getPageNamespacePackageMapping().getMapping(), monitor);
                        }
                        catch (Exception e) {
                            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doImportWebServiceModel", (String)"Web Service model import failed", (Throwable)e, (boolean)false);
                            Object var5_6 = null;
                            monitor.done();
                            return;
                        }
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
            };
            try {
                try {
                    this.mWebDynproRoot.disableAutoNotify();
                    this.mDictionaryRoot.disableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                    this.getContainer().run(true, false, op);
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Object var5_3 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    return bl;
                }
                catch (InvocationTargetException e) {
                    ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportWebServiceModel()", (String)"Failed to create Web Service model", (Throwable)e.getTargetException(), (boolean)false);
                    Object var5_4 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    break block5;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                throw throwable;
            }
            this.mWebDynproRoot.enableAutoNotify();
            this.mDictionaryRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
        }
        if (this.mModel == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doImportXmiModel() {
        IRunnableWithProgress op = new IRunnableWithProgress(){
            static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$ModelService;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                XMIImporter importer;
                block4: {
                    importer = null;
                    try {
                        try {
                            ModelWizard.this.deleteModel();
                            importer = new XMIImporter(ModelWizard.this.mDictionaryRoot, ModelWizard.this.mWebDynproRoot);
                            monitor.beginTask("Import model", -1);
                            ModelWizard.this.mModel = importer.doImport(ModelWizard.this.mData.getModelPackage(), ModelWizard.this.mData.getModelName(), ModelWizard.this.mData.getSourcePathIdentifier(), ModelWizard.this.mData.getXMIPath());
                        }
                        catch (Exception e) {
                            ServiceModelEditorPlugin.internalError((Class)(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = 8.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService), (String)"doImportXmiModel()", (String)("Failed to create model " + ModelWizard.this.mData.getModelPackage() + ModelWizard.this.mData.getModelName()), (Throwable)e, (boolean)false);
                            Object var5_4 = null;
                            monitor.done();
                            break block4;
                        }
                        Object var5_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
                ModelWizard.this.mData.setImportLog(importer.getImportLog());
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        try {
            try {
                this.mWebDynproRoot.disableAutoNotify();
                this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
                Object var5_3 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            catch (InvocationTargetException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doImportXmiModel()", (String)("Failed to create model " + this.mData.getModelPackage() + this.mData.getModelName()), (Throwable)e.getTargetException(), (boolean)false);
                Object var5_4 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mWebDynproRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
            throw throwable;
        }
        this.mWebDynproRoot.enableAutoNotify();
        this.mWebDynproRoot.getMetamodel().enableAutoNotify();
    }

    int getSelectedModelType() {
        return this.mData.getModelType();
    }

    private void deleteModel() {
        if (this.mModel != null) {
            ServiceDeletion.deleteModel((Model)this.mModel);
            if (this.mModel.isDeleted()) {
                this.mModel = null;
            }
        }
    }

    private IResource generateProxy(IProgressMonitor monitor) throws GenerationException {
        IGenerationManager generationManager = R3Service.getInstance().getGenerationManagerFactory().getGenerationManager(this.mData.getRfcGenerationData());
        if (generationManager != null) {
            this.saveMemento(generationManager);
            generationManager.setConnectionManager(R3Service.getInstance().getConnectionManager());
            generationManager.setWorkingSet(R3Service.getInstance().getWorkingSet());
            return generationManager.generate(monitor);
        }
        return null;
    }

    private void setUpDialogSection() {
        IDialogSettings theDialogSettings = ServiceModelEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings theSection = theDialogSettings.getSection(MODEL_IMPORT_WIZARD_SECTION);
        if (theSection == null) {
            theSection = theDialogSettings.addNewSection(MODEL_IMPORT_WIZARD_SECTION);
        }
        this.setDialogSettings(theSection);
    }

    private void saveMemento(IGenerationManager generationManager) {
        IMemento memento = generationManager.createMemento();
        if (memento != null) {
            this.mData.getPageSAPLogon().saveState(memento);
            this.mData.getPageRfcSelection().saveState(memento);
        }
    }

    private void handleGenerationTargetChanged(IGenerationData generationData) {
        IMemento memento;
        IGenerationManager generationManager = R3Service.getInstance().getGenerationManagerFactory().getGenerationManager(this.mData.getRfcGenerationData());
        if (generationManager != null && (memento = generationManager.getMemento()) != null) {
            this.mData.getPageSAPLogon().init(memento);
            this.mData.getPageRfcSelection().init(memento);
        }
    }

    public void dispose() {
        super.dispose();
        if (R3Service.getInstance().getCoolConnectionManager() != null) {
            R3Service.getInstance().getCoolConnectionManager().disconnect();
        }
        if (R3Service.getInstance().getConnectionManager() != null) {
            R3Service.getInstance().getConnectionManager().disconnect();
        }
    }

    private void addSapLogonPage() {
        SAPLogonPage page = new SAPLogonPage();
        this.mData.setPageSAPLogon(page);
        page.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.addPage((IWizardPage)page);
    }

    public int getOperationType() {
        return this.mData.getOperationType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doReimportDynRfcModel() {
        block5: {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            IWorkingSet workingSet = R3Service.getInstance().getWorkingSet();
                            String[] rfcNames = new String[workingSet.getSize()];
                            Iterator iter = workingSet.getIterator();
                            int i = 0;
                            while (true) {
                                if (!iter.hasNext()) {
                                    ModelWizard.this.mData.setImportLog(ModelWizard.this.mData.getDynamicRFCModelReimporter().getImportLog(rfcNames, monitor));
                                    break;
                                }
                                rfcNames[i] = ((IWorkingSetObject)iter.next()).getName();
                                ++i;
                            }
                        }
                        catch (Throwable e) {
                            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doReimportDynRfcModel", (String)"Adaptive RFC model reimport failed", (Throwable)e, (boolean)false);
                            Object var7_8 = null;
                            monitor.done();
                            return;
                        }
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
            };
            try {
                try {
                    this.mWebDynproRoot.disableAutoNotify();
                    this.mDictionaryRoot.disableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                    this.getContainer().run(false, false, op);
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Object var5_3 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    return bl;
                }
                catch (InvocationTargetException e) {
                    ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doReimportDynRfcModel()", (String)"Reimport for Adaptive RFC model failed", (Throwable)e.getTargetException(), (boolean)false);
                    Object var5_4 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    break block5;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                throw throwable;
            }
            this.mWebDynproRoot.enableAutoNotify();
            this.mDictionaryRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
        }
        if (this.mModel == null) return false;
        return true;
    }

    public void initializeReimporter() {
        RFCSelectionPage rfcSelectionPage = this.mData.getPageRfcSelection();
        rfcSelectionPage.setR3Service((IR3Service)R3Service.getInstance());
        try {
            this.mData.getPageSAPLogon().performFinish();
        }
        catch (ConnectionFailedException e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"initializeReimporter", (String)"performFinish for SAPLogon page failed", (Throwable)e, (boolean)true);
        }
        DynamicRFCModelReimporter reimporter = null;
        reimporter = new DynamicRFCModelReimporter(this.mWebDynproRoot, this.mDictionaryRoot, this.mData.getModelToBeReimported());
        this.mData.setDynamicRFCModelReimporter(reimporter);
    }

    public void initializeRFCSelectionPage() {
        RFCSelectionPage rfcSelectionPage = this.mData.getPageRfcSelection();
        rfcSelectionPage.setHasToBeDisplayedRfms(this.mData.getDynamicRFCModelReimporter().getRfcNameDescImported());
    }

    public void performPostSapLogonPageForReimport() {
        this.initializeReimporter();
        this.initializeRFCSelectionPage();
    }

    public void performPostSapLogonPageForUpgradeToARFCModel() {
        this.initializeARFCConverter();
    }

    private void initializeARFCConverter() {
        try {
            this.mData.getPageSAPLogon().performFinish();
        }
        catch (ConnectionFailedException e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"initializeARFCConverter", (String)"performFinish for SAPLogon page failed", (Throwable)e, (boolean)true);
        }
        DynamicRFCModelConverter converter = new DynamicRFCModelConverter(this.mWebDynproRoot, this.mDictionaryRoot, this.mData.getModelToBeReimported());
        this.mData.setDynamicRFCModelConverter(converter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doConvertToDynRfcModel() {
        block5: {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            String[] rfcNameList = ModelWizard.this.mData.getDynamicRFCModelConverter().getRfcNamesImportedFromModel();
                            String[] rfcNames = new String[rfcNameList.length];
                            System.arraycopy(rfcNameList, 0, rfcNames, 0, rfcNameList.length);
                            ModelWizard.this.mData.getDynamicRFCModelConverter().setDictionaryRelatedInfo(ModelWizard.this.mData.getLogicalDictionaryName(), ModelWizard.this.mData.getModelDefaultLogicalSystem(), ModelWizard.this.mData.getMetadataDefaultLogicalSystem());
                            ModelWizard.this.mData.setImportLog(ModelWizard.this.mData.getDynamicRFCModelConverter().getImportLog(rfcNames, monitor));
                        }
                        catch (Throwable e) {
                            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"doConvertToDynRfcModel", (String)"Conversion of RFC model failed", (Throwable)e, (boolean)false);
                            Object var5_6 = null;
                            monitor.done();
                            return;
                        }
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
            };
            try {
                try {
                    this.mWebDynproRoot.disableAutoNotify();
                    this.mDictionaryRoot.disableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().disableAutoNotify();
                    this.getContainer().run(false, false, op);
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Object var5_3 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    return bl;
                }
                catch (InvocationTargetException e) {
                    ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"doConvertToDynRfcModel()", (String)"Conversion of RFC model failed", (Throwable)e.getTargetException(), (boolean)false);
                    Object var5_4 = null;
                    this.mWebDynproRoot.enableAutoNotify();
                    this.mDictionaryRoot.enableAutoNotify();
                    this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                    break block5;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mWebDynproRoot.enableAutoNotify();
                this.mDictionaryRoot.enableAutoNotify();
                this.mWebDynproRoot.getMetamodel().enableAutoNotify();
                throw throwable;
            }
            this.mWebDynproRoot.enableAutoNotify();
            this.mDictionaryRoot.enableAutoNotify();
            this.mWebDynproRoot.getMetamodel().enableAutoNotify();
        }
        if (this.mModel == null) return false;
        return true;
    }

    private boolean addJcoReferences() {
        boolean success = true;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynproRoot.getMetamodel().getName());
        if (project != null) {
            try {
                if (!WDProjectPropertiesUtil.hasJcoReference((IProject)project, (String)this.mData.getMetadataDefaultLogicalSystem())) {
                    success = WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mData.getMetadataDefaultLogicalSystem());
                }
                if (success && !WDProjectPropertiesUtil.hasJcoReference((IProject)project, (String)this.mData.getModelDefaultLogicalSystem())) {
                    success = WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mData.getModelDefaultLogicalSystem());
                }
            }
            catch (CreateException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"addJCOReferences()", (String)("Failed to create entries in project properties file for logical system names: " + this.mData.getMetadataDefaultLogicalSystem() + ", " + this.mData.getModelDefaultLogicalSystem()), (Throwable)e, (boolean)false);
            }
        } else {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)("Failed to retrieve project reference for project " + this.mWebDynproRoot.getMetamodel().getName()), null, (boolean)false);
            success = false;
        }
        return success;
    }
}

