/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation;

import com.sap.ide.jcb.core.wizardpages.CoolSelectionPage;
import com.sap.ide.jcb.core.wizardpages.RFCSelectionPage;
import com.sap.ide.jcb.core.wizardpages.SAPLogonPage;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizard;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageDynRFCImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageJavaBeanImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.PageXMIImportDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageAddJavaBeanDetails;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.jbean.PageSelectJavaBeansFinder;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ModelDialog
extends WizardDialog {
    ModelWizard mWizard;
    private boolean m_HasReimportInitialized;
    private boolean m_HasConverterInitialized;

    public ModelDialog(Shell parentShell, ModelWizard newWizard) {
        super(parentShell, (IWizard)newWizard);
        this.mWizard = newWizard;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void nextPressed() {
        try {
            IWizardPage page = this.getCurrentPage();
            if (page instanceof PageXMIImportDetails) {
                this.mWizard.doImportXmiModel();
            } else if (page instanceof RFCSelectionPage && this.mWizard.getSelectedModelType() == 0) {
                if (this.mWizard.getOperationType() == 2) {
                    this.mWizard.doReimportDynRfcModel();
                    super.nextPressed();
                    return;
                }
                this.mWizard.doImportDynRfcModel();
            } else if (page instanceof CoolSelectionPage) {
                this.mWizard.doImportCoolModel();
            } else if (page instanceof SAPLogonPage) {
                if (this.mWizard.getOperationType() == 2) {
                    if (!this.m_HasReimportInitialized) {
                        this.mWizard.performPostSapLogonPageForReimport();
                        this.m_HasReimportInitialized = true;
                    }
                    super.nextPressed();
                    return;
                }
                if (this.mWizard.getOperationType() == 3) {
                    if (!this.m_HasConverterInitialized) {
                        this.mWizard.performPostSapLogonPageForUpgradeToARFCModel();
                        this.m_HasConverterInitialized = true;
                    }
                    super.nextPressed();
                    return;
                }
            } else if (page instanceof PageDynRFCImportDetails) {
                if (this.mWizard.getOperationType() == 3) {
                    this.mWizard.doConvertToDynRfcModel();
                    super.nextPressed();
                    return;
                }
            } else {
                if (page instanceof PageAddJavaBeanDetails) {
                    this.mWizard.doImportJavaBeanModel();
                    super.nextPressed();
                    return;
                }
                if (page instanceof PageJavaBeanImportDetails) {
                    try {
                        this.mWizard.initializeJavaBeanSource();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
                        return;
                    }
                    IWizardPage nextPage = this.mWizard.getNextPage(page);
                    if (nextPage instanceof PageSelectJavaBeansFinder) {
                        ((PageSelectJavaBeansFinder)nextPage).disposeControl();
                    }
                    super.nextPressed();
                    return;
                }
            }
            super.nextPressed();
            if (page instanceof PageJavaBeanImportDetails && page.getNextPage() instanceof PageSelectJavaBeansFinder) {
                ((PageSelectJavaBeansFinder)page.getNextPage()).setFocus();
            }
        }
        catch (Exception e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"nextPressed", (String)"Internal error - see detail information in exception trace.", (Throwable)e, (boolean)false);
        }
    }
}

