/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards.model.creation;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizard;
import com.sap.ide.webdynpro.modeleditor.wizards.model.creation.ModelWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractModelWizardPage
extends WizardPage {
    protected static final CoreTextPool mCPool = CoreTextPool.getInstance();
    protected static final TextPool mTPool = TextPool.getInstance();
    protected static final String MODEL = mCPool.getText(112);
    protected final String BROWSE = mCPool.getText(208);
    protected ModelWizardData mWizardData;
    protected WebDynproRoot mWebDynproRoot;
    protected Model[] mAvailableModels;
    protected Text mModelNameField;
    protected Text mModelPackageField;
    protected List mSourcePathList;
    protected Button mModelPackageButton;
    protected ModelNameModifyListener mModelNameModifyListener;

    public AbstractModelWizardPage(String pageName, String pageTitle, String pageDescription, ModelWizardData data, WebDynproRoot webDynproRoot) {
        super(pageName, pageTitle, SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_MODEL_BANNER));
        this.setDescription(pageDescription);
        this.mWizardData = data;
        this.mWebDynproRoot = webDynproRoot;
        try {
            this.mAvailableModels = this.mWebDynproRoot.getModels();
        }
        catch (LoadException e) {
            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"AbstractModelWizardPage", (String)"Failed to load web dynpro model instances", (Throwable)e, (boolean)true);
        }
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)4);
        wizardPane.setSpacing(5, 10);
        wizardPane.addTextLabel(mTPool.getText(401));
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false, 2, 1);
        this.mModelNameField = wizardPane.addTextField(this.mWizardData.getModelName(), false, gridLayoutData);
        this.mModelNameModifyListener = new ModelNameModifyListener();
        this.mModelNameField.addModifyListener((ModifyListener)this.mModelNameModifyListener);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(mTPool.getText(402));
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false, 2, 1);
        this.mModelPackageField = wizardPane.addTextField(this.mWizardData.getModelPackage(), false, gridLayoutData);
        this.mModelPackageField.addModifyListener((ModifyListener)new ModelPackageModifyListener());
        this.mModelPackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mModelPackageButton.addSelectionListener((SelectionListener)new BrowseModelPackageButtonListener());
        wizardPane.addTextLabel(mCPool.getText(207));
        gridLayoutData = wizardPane.createGridLayoutData(4, 1, true, false, 2, 1);
        gridLayoutData.getGridData().heightHint = 40;
        IPackageFragmentRoot[] roots = this.mWizardData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mWizardData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourcePathSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
        wizardPane.addPlaceholder();
        this.createControlExtended(wizardPane);
    }

    protected abstract void createControlExtended(IGridLayoutPane var1);

    public void resetFields() {
        if (this.mModelPackageField.getText().length() > 0) {
            this.mModelPackageField.setText("");
        }
        if (this.mModelNameField.getText().length() > 0) {
            this.mModelNameField.setText("");
        }
        this.mWizardData.clearData();
        this.setErrorMessage(null);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validateModelName(this.mWizardData.getModelName(), this.mWizardData.getModelPackage()).getSeverity() != 4 && this.validatePackageName(this.mWizardData.getModelPackage()).getSeverity() != 4 && this.mWizardData.getSourcePathIdentifier() != null;
    }

    public void setErrorMessage(String message) {
        this.setPageComplete(message == null ? true : message.length() == 0);
        super.setMessage(null);
        super.setErrorMessage(message);
    }

    public void setMessage(String message, int type) {
        this.setPageComplete(type != 4);
        if (type == 4) {
            super.setErrorMessage(message);
        } else if (type == 0) {
            super.setErrorMessage(null);
            super.setMessage(null, type);
        } else {
            super.setErrorMessage(null);
            super.setMessage(message, type);
        }
    }

    protected IStatus validatePackageName(String packageName) {
        IStatus status = CheckServices.isValidPackage((String)packageName);
        if (status.getSeverity() == 0) {
            MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager((String)this.mWebDynproRoot.getMetamodel().getName());
            if (!metamodelManager.isPackageEmpty(packageName)) {
                status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "The package is not empty", null);
                return status;
            }
            if (this.mAvailableModels != null && this.mAvailableModels.length > 0) {
                int i = 0;
                while (i < this.mAvailableModels.length) {
                    if (packageName.equals(this.mAvailableModels[i].getPackage())) {
                        status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, TextPool.getInstance().getText(24, (Object)this.mAvailableModels[i].getName()), null);
                        break;
                    }
                    ++i;
                }
            }
        }
        return status;
    }

    protected String selectPackage(String defaultPackage) {
        IPackageFragmentRoot sourceRoot = this.mWizardData.getSelectedRoot();
        IPackageFragment selectedPackage = null;
        if (sourceRoot != null) {
            IPackageFragment preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)defaultPackage, (IPackageFragmentRoot)sourceRoot);
            selectedPackage = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)this.getShell());
        }
        if (selectedPackage != null) {
            return selectedPackage.getElementName();
        }
        return null;
    }

    protected IStatus validateModelName(String modelName, String packageName) {
        Status status = new Status(0, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "", null);
        if (modelName != null && modelName.length() > 0) {
            MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)modelName);
            if (checkResult.isOk()) {
                if (Character.isUpperCase(modelName.charAt(0))) {
                    if (packageName != null) {
                        try {
                            Model model = this.mWebDynproRoot.getModel(packageName, modelName);
                            if (model != null && !model.equals(((ModelWizard)this.getWizard()).getModel())) {
                                status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, mTPool.getText(4, (Object)modelName, (Object)packageName), null);
                            }
                        }
                        catch (LoadException e) {
                            ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"validateModelName", (String)"Cannot load model instances", (Throwable)e, (boolean)false);
                        }
                    }
                } else {
                    status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, mCPool.getText(17, (Object)modelName), null);
                }
            } else {
                status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, checkResult.getMessage(), null);
            }
        } else {
            status = new Status(4, ServiceModelEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, mTPool.getText(1, (Object)MODEL), null);
        }
        return status;
    }

    protected void updateModelName(String modelName) {
    }

    protected void updateModelPackageName(String packageName) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mModelNameField.setFocus();
        }
    }

    public ModelNameModifyListener getmModelNameModifyListener() {
        return this.mModelNameModifyListener;
    }

    class BrowseModelPackageButtonListener
    extends SelectionAdapter {
        BrowseModelPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String packageName = AbstractModelWizardPage.this.selectPackage(AbstractModelWizardPage.this.mWizardData.getModelPackage());
            if (packageName != null) {
                IStatus status = AbstractModelWizardPage.this.validatePackageName(packageName);
                if (status != null && status.getSeverity() != 4) {
                    String modelName = AbstractModelWizardPage.this.mWizardData.getModelName();
                    if (modelName.length() > 0) {
                        IStatus statusModelName = AbstractModelWizardPage.this.validateModelName(modelName, packageName);
                        if (statusModelName != null && statusModelName.getSeverity() != 4) {
                            AbstractModelWizardPage.this.mWizardData.setModelPackage(packageName);
                        } else {
                            status = statusModelName;
                            AbstractModelWizardPage.this.mWizardData.setModelPackage("");
                        }
                    } else {
                        AbstractModelWizardPage.this.mWizardData.setModelPackage(packageName);
                    }
                } else {
                    AbstractModelWizardPage.this.mWizardData.setModelPackage("");
                }
                AbstractModelWizardPage.this.mModelPackageField.setText(packageName);
                AbstractModelWizardPage.this.updateModelPackageName(packageName);
                AbstractModelWizardPage.this.setMessage(status.getMessage(), status.getSeverity());
            }
        }
    }

    private class SourcePathSelectionListener
    extends SelectionAdapter {
        private SourcePathSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int idx = AbstractModelWizardPage.this.mSourcePathList.getSelectionIndex();
            IPackageFragmentRoot[] rootPaths = AbstractModelWizardPage.this.mWizardData.getAllValidRoots();
            if (idx >= 0 && idx < rootPaths.length) {
                AbstractModelWizardPage.this.mWizardData.setSelectedRoot(rootPaths[idx]);
                AbstractModelWizardPage.this.setErrorMessage(null);
            }
        }
    }

    private class ModelPackageModifyListener
    implements ModifyListener {
        private ModelPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String packageName = CheckServices.convertToLowerCase((Text)AbstractModelWizardPage.this.mModelPackageField);
            String modelName = AbstractModelWizardPage.this.mModelNameField.getText();
            IStatus status = AbstractModelWizardPage.this.validatePackageName(packageName);
            if (status != null && status.getSeverity() != 4) {
                if (modelName.length() > 0) {
                    IStatus statusModelName = AbstractModelWizardPage.this.validateModelName(modelName, packageName);
                    if (statusModelName != null && statusModelName.getSeverity() != 4) {
                        AbstractModelWizardPage.this.mWizardData.setModelPackage(packageName);
                    }
                    if (status.getSeverity() < statusModelName.getSeverity()) {
                        status = statusModelName;
                        if (statusModelName.getSeverity() == 4) {
                            AbstractModelWizardPage.this.mWizardData.setModelPackage("");
                        }
                    }
                } else {
                    AbstractModelWizardPage.this.mWizardData.setModelPackage(packageName);
                }
            } else {
                AbstractModelWizardPage.this.mWizardData.setModelPackage("");
            }
            AbstractModelWizardPage.this.updateModelPackageName(packageName);
            AbstractModelWizardPage.this.setMessage(status.getMessage(), status.getSeverity());
        }
    }

    private class ModelNameModifyListener
    implements ModifyListener {
        private ModelNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String packageName;
            String modelName = CheckServices.checkFirstCharacter((Text)AbstractModelWizardPage.this.mModelNameField);
            IStatus status = AbstractModelWizardPage.this.validateModelName(modelName, packageName = AbstractModelWizardPage.this.mModelPackageField.getText());
            if (status != null && status.getSeverity() != 4) {
                AbstractModelWizardPage.this.mWizardData.setModelName(modelName);
                if (packageName.length() > 0) {
                    IStatus statusPackageName = AbstractModelWizardPage.this.validatePackageName(packageName);
                    if (statusPackageName != null && statusPackageName.getSeverity() != 4) {
                        AbstractModelWizardPage.this.mWizardData.setModelPackage(packageName);
                    }
                    if (status.getSeverity() < statusPackageName.getSeverity()) {
                        status = statusPackageName;
                    }
                }
            } else {
                AbstractModelWizardPage.this.mWizardData.setModelName("");
            }
            AbstractModelWizardPage.this.updateModelName(modelName);
            AbstractModelWizardPage.this.setMessage(status.getMessage(), status.getSeverity());
        }
    }
}

