/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.wizards;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.service.core.MetamodelServices;

public class TypeWizardData {
    private static final String NAME_VOID = "void";
    private MetamodelServices.CompoundType mType;
    private DtSimpleType[] mBuiltInTypes;
    private Object[] mTypes;
    private boolean mVoidSupported;

    public TypeWizardData(DevelopmentObject initialType, DtSimpleType[] builtInTypes, boolean voidSupported) {
        if (initialType != null) {
            this.mType = new MetamodelServices.CompoundType(initialType);
        } else if (builtInTypes.length > 0) {
            this.mType = new MetamodelServices.CompoundType(builtInTypes[0]);
        }
        this.mBuiltInTypes = builtInTypes;
        this.mVoidSupported = voidSupported;
        this.updateTypes();
    }

    public MetamodelServices.CompoundType getType() {
        return this.mType;
    }

    public String getTypeName() {
        if (this.mType == null) {
            if (this.mVoidSupported) {
                return NAME_VOID;
            }
            return "";
        }
        if (this.mType.isJavaNativeType()) {
            return this.mType.getQualifiedName();
        }
        return this.mType.getName();
    }

    public String[] getTypeNames() {
        String[] names = new String[this.mTypes.length];
        int i = 0;
        while (i < this.mTypes.length) {
            names[i] = this.mTypes[i] instanceof String ? (String)this.mTypes[i] : (this.mTypes[i] instanceof MetamodelServices.CompoundType ? (((MetamodelServices.CompoundType)this.mTypes[i]).isJavaNativeType() ? ((MetamodelServices.CompoundType)this.mTypes[i]).getQualifiedName() : ((MetamodelServices.CompoundType)this.mTypes[i]).getName()) : ((DtSimpleType)this.mTypes[i]).getName());
            ++i;
        }
        return names;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTypeIdx() {
        MetamodelServices.CompoundType compoundType = this.mType;
        if (this.mType == null) {
            if (!this.mVoidSupported) return -1;
            String string = NAME_VOID;
        } else if (this.mType.isBuiltInType()) {
            DtSimpleType dtSimpleType = this.mType.getSimpleType();
        }
        int i = 0;
        while (i < this.mTypes.length) {
            void var1_4;
            if (this.mTypes[i].equals(var1_4)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setType(MetamodelServices.CompoundType type) {
        if (type != this.mType) {
            this.mType = type;
            if (type != null && !type.isBuiltInType() && !this.mTypes[0].equals(type)) {
                this.updateTypes();
            }
        }
    }

    public void setType(int idx) {
        if (idx >= 0 && idx < this.mTypes.length) {
            this.mType = this.mTypes[idx].equals(NAME_VOID) ? null : (this.mTypes[idx] instanceof MetamodelServices.CompoundType ? (MetamodelServices.CompoundType)this.mTypes[idx] : new MetamodelServices.CompoundType((DtSimpleType)this.mTypes[idx]));
        }
    }

    private void updateTypes() {
        if (this.mType != null && !this.mType.isBuiltInType()) {
            if (this.mVoidSupported) {
                this.mTypes = new Object[this.mBuiltInTypes.length + 2];
                this.mTypes[0] = this.mType;
                this.mTypes[1] = NAME_VOID;
                System.arraycopy(this.mBuiltInTypes, 0, this.mTypes, 2, this.mBuiltInTypes.length);
            } else {
                this.mTypes = new Object[this.mBuiltInTypes.length + 1];
                this.mTypes[0] = this.mType;
                System.arraycopy(this.mBuiltInTypes, 0, this.mTypes, 1, this.mBuiltInTypes.length);
            }
        } else if (this.mVoidSupported) {
            this.mTypes = new Object[this.mBuiltInTypes.length + 1];
            this.mTypes[0] = NAME_VOID;
            System.arraycopy(this.mBuiltInTypes, 0, this.mTypes, 1, this.mBuiltInTypes.length);
        } else {
            this.mTypes = new Object[this.mBuiltInTypes.length];
            System.arraycopy(this.mBuiltInTypes, 0, this.mTypes, 0, this.mBuiltInTypes.length);
        }
    }
}

