/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.settings;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.framework.AbstractModelSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassMethodSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassPropertySettingDefintion;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelRelationRoleSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelRelationSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.AbstractModelSetting;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethodSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassPropertySetting;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRoleSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.metamodel.webdynpro.repository.ModelRepositoryManager;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.projectproperties.ProjectPropertiesService;
import com.sap.ide.webdynpro.service.core.projectproperties.WDProjectPropertiesUtil;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ModelSettingsPropertySource
implements IPropertySource {
    private static String CATEGORY_MODEL_SETTINGS = "Model Settings";
    private static String CATEGORY_MODEL_CLASS_SETTINGS = "Model Class Settings";
    private static String CATEGORY_MODEL_CLASS_PROPERTY_SETTINGS = "Model Class Property Settings";
    private static String CATEGORY_MODEL_CLASS_METHOD_SETTINGS = "Model Class Method Settings";
    private static String CATEGORY_MODEL_RELATION_SETTINGS = "Model Relation Settings";
    private static String CATEGORY_MODEL_RELATION_ROLE_SETTINGS = "Model Relation Role Settings";
    private DevelopmentObject mModelEntity;
    private MainDevelopmentObject mMDO;
    private ModelType mModelType;
    private Model mModel;
    private boolean mSetPropertyValueDone;

    public ModelSettingsPropertySource(ModelClass modelClass) {
        this.mModelEntity = modelClass;
        this.mMDO = modelClass;
        this.mModel = modelClass.getModel();
        this.mModelType = modelClass.getModel().getModelType();
    }

    public Object getEditableValue() {
        return this.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        AbstractModelSettingDefinition[] settingDefinitions = this.getSettingDefinitions();
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        Object newDescriptor = null;
        int i = 0;
        while (i < settingDefinitions.length) {
            if (!settingDefinitions[i].getObsolete()) {
                newDescriptor = settingDefinitions[i].getReadonly() ? new PropertyDescriptor((Object)settingDefinitions[i].getName(), settingDefinitions[i].getName()) : new TextPropertyDescriptor((Object)settingDefinitions[i].getName(), settingDefinitions[i].getName());
                if (this.mModelEntity instanceof Model) {
                    newDescriptor.setCategory(CATEGORY_MODEL_SETTINGS);
                } else if (this.mModelEntity instanceof ModelClass) {
                    newDescriptor.setCategory(CATEGORY_MODEL_CLASS_SETTINGS);
                } else if (this.mModelEntity instanceof ModelClassProperty) {
                    newDescriptor.setCategory(CATEGORY_MODEL_CLASS_PROPERTY_SETTINGS);
                } else if (this.mModelEntity instanceof ModelClassMethod) {
                    newDescriptor.setCategory(CATEGORY_MODEL_CLASS_METHOD_SETTINGS);
                } else if (this.mModelEntity instanceof ModelRelation) {
                    newDescriptor.setCategory(CATEGORY_MODEL_RELATION_SETTINGS);
                } else if (this.mModelEntity instanceof ModelRelationRole) {
                    newDescriptor.setCategory(CATEGORY_MODEL_RELATION_ROLE_SETTINGS);
                }
                propertyDescriptors.add((PropertyDescriptor)newDescriptor);
            }
            ++i;
        }
        if (this.mModelEntity instanceof ModelClass && this.mModelType != null) {
            ModelSettingDefinition[] modelSettingDefinitions = this.mModelType.getModelSettingDefinitions();
            int i2 = 0;
            while (i2 < modelSettingDefinitions.length) {
                if (!modelSettingDefinitions[i2].getObsolete()) {
                    newDescriptor = modelSettingDefinitions[i2].getReadonly() ? new PropertyDescriptor((Object)("MODEL" + modelSettingDefinitions[i2].getName()), modelSettingDefinitions[i2].getName()) : new TextPropertyDescriptor((Object)("MODEL" + modelSettingDefinitions[i2].getName()), modelSettingDefinitions[i2].getName());
                    newDescriptor.setCategory(CATEGORY_MODEL_SETTINGS);
                    propertyDescriptors.add((PropertyDescriptor)newDescriptor);
                }
                ++i2;
            }
            return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        String settingName = id instanceof String ? (String)id : "";
        AbstractModelSetting setting = this.getSetting(settingName);
        String defaultValue = null;
        if (setting != null) {
            return setting.getValue();
        }
        AbstractModelSettingDefinition settingDefinition = this.getSettingDefinition(settingName);
        if (settingDefinition != null) {
            defaultValue = settingDefinition.getDefaultValue();
        }
        return defaultValue == null ? "" : defaultValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String settingName = id instanceof String ? (String)id : "";
        String settingValue = value instanceof String ? (String)value : "";
        AbstractModelSetting setting = this.getSetting(settingName);
        if (this.mSetPropertyValueDone) {
            return;
        }
        this.mSetPropertyValueDone = true;
        MMRepositoryObject[] repositoryObjs = this.getAffectedRepositoryObjects(settingName, settingValue);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjs)) {
            this.mSetPropertyValueDone = false;
            return;
        }
        if (setting == null) {
            setting = this.createSetting(settingName);
        }
        if (setting != null) {
            IProject project;
            setting.setValue(settingValue);
            if (MetamodelServices.hasModelTypeDynamicRfcAdapter((Model)this.mModel) && setting.getName().equals("modelInstance_defaultLogicalSystem") && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mModel.getRoot().getMetamodel().getName())) != null) {
                try {
                    WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)settingValue);
                }
                catch (CreateException e) {
                    ServiceModelEditorPlugin.internalError(this.getClass(), (String)"setPropertyValue()", (String)("Failed to create entry in properties file for logical system name " + settingValue), (Throwable)e, (boolean)false);
                }
            }
        }
    }

    private AbstractModelSetting getSetting(String settingName) {
        ModelSetting setting = null;
        if (this.mModelEntity instanceof Model) {
            setting = ((Model)this.mModelEntity).getSetting(settingName);
        } else if (this.mModelEntity instanceof ModelClass) {
            if (settingName.startsWith("MODEL")) {
                settingName = settingName.substring(5);
                setting = ((ModelClass)this.mModelEntity).getModel().getSetting(settingName);
            } else {
                setting = ((ModelClass)this.mModelEntity).getSetting(settingName);
            }
        } else if (this.mModelEntity instanceof ModelClassProperty) {
            setting = ((ModelClassProperty)this.mModelEntity).getSetting(settingName);
        } else if (this.mModelEntity instanceof ModelClassMethod) {
            setting = ((ModelClassMethod)this.mModelEntity).getSetting(settingName);
        } else if (this.mModelEntity instanceof ModelRelation) {
            setting = ((ModelRelation)this.mModelEntity).getSetting(settingName);
        } else if (this.mModelEntity instanceof ModelRelationRole) {
            setting = ((ModelRelationRole)this.mModelEntity).getSetting(settingName);
        }
        return setting;
    }

    private AbstractModelSetting createSetting(String settingName) {
        AbstractModelSettingDefinition settingDefinition = this.getSettingDefinition(settingName);
        ModelSetting setting = null;
        try {
            if (this.mModelEntity instanceof Model) {
                setting = ((Model)this.mModelEntity).createSetting(settingName);
                setting.setSettingDefinition((ModelSettingDefinition)settingDefinition);
            } else if (this.mModelEntity instanceof ModelClass) {
                if (settingName.startsWith("MODEL")) {
                    settingName = settingName.substring(5);
                    setting = ((ModelClass)this.mModelEntity).getModel().createSetting(settingName);
                    setting.setSettingDefinition((ModelSettingDefinition)settingDefinition);
                } else {
                    setting = ((ModelClass)this.mModelEntity).createSetting(settingName);
                    ((ModelClassSetting)setting).setSettingDefinition((ModelClassSettingDefinition)settingDefinition);
                }
            } else if (this.mModelEntity instanceof ModelClassProperty) {
                setting = ((ModelClassProperty)this.mModelEntity).createSetting(settingName);
                ((ModelClassPropertySetting)setting).setSettingDefinition((ModelClassPropertySettingDefintion)settingDefinition);
            } else if (this.mModelEntity instanceof ModelClassMethod) {
                setting = ((ModelClassMethod)this.mModelEntity).createSetting(settingName);
                ((ModelClassMethodSetting)setting).setSettingDefinition((ModelClassMethodSettingDefinition)settingDefinition);
            } else if (this.mModelEntity instanceof ModelRelation) {
                setting = ((ModelRelation)this.mModelEntity).createSetting(settingName);
                ((ModelRelationSetting)setting).setSettingDefinition((ModelRelationSettingDefinition)settingDefinition);
            } else if (this.mModelEntity instanceof ModelRelationRole) {
                setting = ((ModelRelationRole)this.mModelEntity).createSetting(settingName);
                ((ModelRelationRoleSetting)setting).setSettingDefinition((ModelRelationRoleSettingDefinition)settingDefinition);
            }
        }
        catch (CreateException e) {
            ModelEditorPlugin.internalError(this.getClass(), "createSetting", "Cannot create setting " + settingName, e, false);
            e.printStackTrace();
        }
        return setting;
    }

    private AbstractModelSettingDefinition getSettingDefinition(String settingName) {
        ModelSettingDefinition settingDefinition = null;
        if (this.mModelEntity instanceof Model) {
            settingDefinition = this.mModelType.getModelSettingDefinition(settingName);
        } else if (this.mModelEntity instanceof ModelClass) {
            if (settingName.startsWith("MODEL")) {
                settingName = settingName.substring(5);
                settingDefinition = this.mModelType.getModelSettingDefinition(settingName);
            } else {
                settingDefinition = this.mModelType.getModelClassSettingDefinition(settingName);
            }
        } else if (this.mModelEntity instanceof ModelClassProperty) {
            settingDefinition = this.mModelType.getModelClassPropertySettingDefinition(settingName);
        } else if (this.mModelEntity instanceof ModelClassMethod) {
            settingDefinition = this.mModelType.getModelClassMethodSettingDefinition(settingName);
        } else if (this.mModelEntity instanceof ModelRelation) {
            settingDefinition = this.mModelType.getModelRelationSettingDefinition(settingName);
        } else if (this.mModelEntity instanceof ModelRelationRole) {
            settingDefinition = this.mModelType.getModelRelationRoleSettingDefinition(settingName);
        }
        return settingDefinition;
    }

    private AbstractModelSettingDefinition[] getSettingDefinitions() {
        if (this.mModelType != null) {
            if (this.mModelEntity instanceof Model) {
                return this.mModelType.getModelSettingDefinitions();
            }
            if (this.mModelEntity instanceof ModelClass) {
                return this.mModelType.getModelClassSettingDefinitions();
            }
            if (this.mModelEntity instanceof ModelClassProperty) {
                return this.mModelType.getModelClassPropertySettingDefinitions();
            }
            if (this.mModelEntity instanceof ModelClassMethod) {
                return this.mModelType.getModelClassMethodSettingDefinitions();
            }
            if (this.mModelEntity instanceof ModelRelation) {
                return this.mModelType.getModelRelationSettingDefinitions();
            }
            if (this.mModelEntity instanceof ModelRelationRole) {
                return this.mModelType.getModelRelationRoleSettingDefinitions();
            }
        }
        return new AbstractModelSettingDefinition[0];
    }

    private MMRepositoryObject[] getAffectedRepositoryObjects(String settingName, String settingValue) {
        ArrayList<MMRepositoryObject> repositoryObjs = new ArrayList<MMRepositoryObject>();
        if (settingName.startsWith("MODEL")) {
            IProject project;
            if (MetamodelServices.hasModelTypeDynamicRfcAdapter((Model)this.mModel) && settingName.endsWith("modelInstance_defaultLogicalSystem") && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mModel.getRoot().getMetamodel().getName())) != null && !WDProjectPropertiesUtil.hasJcoReference((IProject)project, (String)settingValue)) {
                ProjectProperties projectProperties = ProjectPropertiesService.getProjectProperties((IProject)project);
                repositoryObjs.addAll(Arrays.asList(ProjectPropertiesService.getRepositoryObjectsAffectedByProjectPropertiesDeletion((ProjectProperties)projectProperties)));
            }
            repositoryObjs.add(ModelRepositoryManager.getRepositioryObject((Model)this.mModel, (boolean)false));
        } else {
            repositoryObjs.add(ModelRepositoryManager.getRepositioryObject((DevelopmentObject)this.mModelEntity, (boolean)false));
        }
        return repositoryObjs.toArray(new MMRepositoryObject[repositoryObjs.size()]);
    }
}

