/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.relations;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.relations.RelationEditDialog;
import com.sap.ide.webdynpro.modeleditor.wizards.relation.creation.ModelRelationWizard;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceDeletion;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelRelationInfo;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class RelationsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{AbstractTableModel.mTextPool.getText(338), AbstractTableModel.mTextPool.getText(337), AbstractTableModel.mTextPool.getText(339), AbstractTableModel.mTextPool.getText(361), AbstractTableModel.mTextPool.getText(340), AbstractTableModel.mTextPool.getText(361), AbstractTableModel.mTextPool.getText(336)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelRelationInfo == null ? (class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelRelationInfo = RelationsTableModel.class$("com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelRelationInfo")) : class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelRelationInfo, class$java$lang$String == null ? (class$java$lang$String = RelationsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RelationsTableModel.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$swt$widgets$Button == null ? (class$org$eclipse$swt$widgets$Button = RelationsTableModel.class$("org.eclipse.swt.widgets.Button")) : class$org$eclipse$swt$widgets$Button, class$java$lang$String == null ? (class$java$lang$String = RelationsTableModel.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$swt$widgets$Button == null ? (class$org$eclipse$swt$widgets$Button = RelationsTableModel.class$("org.eclipse.swt.widgets.Button")) : class$org$eclipse$swt$widgets$Button, class$java$lang$String == null ? (class$java$lang$String = RelationsTableModel.class$("java.lang.String")) : class$java$lang$String};
    public static final int COLUMN_RELATION_TYPE = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_SOURCE_ROLE = 2;
    public static final int COLUMN_SOURCE_ROLE_IS_AGGREGATION = 3;
    private static final int COLUMN_TARGET_ROLE = 4;
    public static final int COLUMN_TARGET_ROLE_IS_AGGREGATION = 5;
    private static final int COLUMN_TARGET_CLASS = 6;
    private static final int[] COLUMN_WIDTHS = new int[]{18, Integer.MAX_VALUE, Integer.MAX_VALUE, 16, Integer.MAX_VALUE, 16, Integer.MAX_VALUE};
    protected ModelRelationInfo[] mRelations;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelRelationInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Button;

    public RelationsTableModel(ModelClass modelClass) {
        super(modelClass);
        this.setNumberOfColumns(COLUMN_NAMES.length);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mRelations.length) {
            return null;
        }
        return this.mRelations[index].getModelRelation();
    }

    public void updateDataTable() {
        if (this.getModelClass().isValid()) {
            ModelRelationRole[] roles = ModelClassHelper.getSourceRoles((ModelClass)this.getModelClass(), (boolean)this.getShowInherited());
            this.mRelations = ModelClassService.convertToModelRelationInfos((ModelRelationRole[])roles, (ModelClass)this.getModelClass());
            ModelClassService.sort((ModelClass)this.getModelClass(), (ModelRelationInfo[])this.mRelations);
        }
    }

    public int getRowCount() {
        if (this.mRelations == null) {
            return 0;
        }
        return this.mRelations.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.getModelClass().isValid() || this.mRelations == null || rowIndex >= this.mRelations.length || this.mRelations[rowIndex] == null) {
            return AbstractTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return this.mRelations[rowIndex];
            }
            case 1: {
                ModelClass source = this.mRelations[rowIndex].getSourceRole().getModelClass();
                if (this.getModelClass().equals(source)) {
                    return this.mRelations[rowIndex].getName();
                }
                return this.mRelations[rowIndex].getName() + " (from " + source.getName() + ")";
            }
            case 2: {
                return this.mRelations[rowIndex].getSourceRoleInfo();
            }
            case 3: {
                return new Boolean(this.mRelations[rowIndex].getSourceRole().getAggregate());
            }
            case 4: {
                return this.mRelations[rowIndex].getTargetRoleInfo();
            }
            case 5: {
                return new Boolean(this.mRelations[rowIndex].getTargetRole().getAggregate());
            }
            case 6: {
                return this.mRelations[rowIndex].getTargetClassName();
            }
        }
        return AbstractTableModel.ERROR;
    }

    protected boolean isRefreshNeeded(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ModelRelation || event.getModifiedObject() instanceof ModelClass) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isEditAllowed(int index) {
        return (this.getModelClass().equals(this.mRelations[index].getSourceModelClass()) || this.getModelClass().equals(this.mRelations[index].getTargetModelClass())) && MetamodelServices.isModelRelationDeletable((ModelRelation)this.mRelations[index].getModelRelation());
    }

    protected boolean isDeleteAllowed(int index) {
        return (this.getModelClass().equals(this.mRelations[index].getSourceModelClass()) || this.getModelClass().equals(this.mRelations[index].getTargetModelClass())) && MetamodelServices.isModelRelationDeletable((ModelRelation)this.mRelations[index].getModelRelation());
    }

    protected boolean isCopyAllowed(int index) {
        return false;
    }

    protected void doNew() {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByRelationCreation((Model)this.getModelClass().getModel()))) {
            return;
        }
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new ModelRelationWizard(this.getModelClass()));
        dialog.open();
        dialog.close();
    }

    protected void doEdit(int index) {
        ModelRelationInfo info = this.mRelations[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByRelationModification((ModelRelation)info.getModelRelation()))) {
            return;
        }
        RelationEditDialog dialog = new RelationEditDialog(info, 1);
        if (dialog.open() == 0) {
            ModelRelationRole sourceRole = info.getSourceRole();
            ModelRelationRole targetRole = info.getTargetRole();
            if (sourceRole.getCardinality() != null && !sourceRole.getCardinality().equals(dialog.getSourceCardinality())) {
                sourceRole.setCardinality(dialog.getSourceCardinality());
            }
            if (targetRole.getCardinality() != null && !targetRole.getCardinality().equals(dialog.getTargetCardinality())) {
                targetRole.setCardinality(dialog.getTargetCardinality());
            }
            if (sourceRole.getAggregate() != dialog.getSourceAggregation()) {
                sourceRole.setAggregate(dialog.getSourceAggregation());
            }
            if (targetRole.getAggregate() != dialog.getTargetAggregation()) {
                targetRole.setAggregate(dialog.getTargetAggregation());
            }
            if (sourceRole.getNavigable() != dialog.getSourceNavigable()) {
                sourceRole.setNavigable(dialog.getSourceNavigable());
            }
            if (targetRole.getNavigable() != dialog.getTargetNavigable()) {
                targetRole.setNavigable(dialog.getTargetNavigable());
            }
            if (targetRole.getModelClass() != null && !targetRole.getModelClass().equals(dialog.getTargetModelClass())) {
                targetRole.setModelClass(dialog.getTargetModelClass());
            }
            this.refresh();
        }
    }

    protected void doDelete(int index) {
        ModelRelationInfo info = this.mRelations[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByRelationDeletion((ModelRelation)info.getModelRelation()))) {
            return;
        }
        ServiceDeletion.deleteModelRelation((ModelRelation)info.getModelRelation());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

