/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.relations;

import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.modeleditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.modeleditor.wizards.relation.creation.ModelRelationWizardData;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class RelationEditUI {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String MODEL_RELATION = mCPool.getText(128);
    private static final String RELATION_NAME = mTPool.getText(424);
    private static final String SOURCE_ROLE = mTPool.getText(434);
    private static final String TARGET_ROLE = mTPool.getText(435);
    private static final String ROLE_NAME = mTPool.getText(436);
    private static final String MODEL_CLASS = mCPool.getText(127);
    private static final String CARDINALITY = mTPool.getText(437);
    private static final String NAVIGABLE = mTPool.getText(438);
    private static final String AGGREGATION = mTPool.getText(439);
    private ModelRelationWizardData mData = null;
    private ModelClass mModelClass = null;
    private IDisplayErrorListener mDisplayErrorListener;
    private int mMode;
    private Text mModelRelationNameField = null;
    private Text mSourceRoleNameField = null;
    private Combo mSourceModelClassCombo = null;
    private Combo mSourceCardinalityCombo = null;
    private Button mSourceNavigableBox = null;
    private Button mSourceAggregationBox = null;
    private Text mTargetRoleNameField = null;
    private Combo mTargetModelClassCombo = null;
    private Combo mTargetCardinalityCombo = null;
    private Button mTargetNavigableBox = null;
    private Button mTargetAggregationBox = null;

    public RelationEditUI(ModelRelationWizardData data, IDisplayErrorListener displayErrorListener, int mode) {
        this.mData = data;
        this.mModelClass = this.mData.getSourceModelClass();
        this.mDisplayErrorListener = displayErrorListener;
        this.mMode = mode;
    }

    public void initUI(IGridLayoutPane pane) {
        IGridLayoutPane relationPane = PaneFactory.createGridLayoutPane((Composite)pane.getComposite(), (int)2);
        GridData relationGridData = new GridData(1792);
        relationPane.setLayoutData((Object)relationGridData);
        IGridLayoutPane targetPane = PaneFactory.createGridLayoutPaneWithTitle((Composite)pane.getComposite(), (String)"Target Role", (int)2);
        GridData targetGridData = new GridData(1808);
        targetPane.setLayoutData((Object)targetGridData);
        targetPane.addTextLabel(ROLE_NAME);
        IGridLayoutData gridLayoutData = targetPane.createGridLayoutData(4, 1, true, false);
        this.mTargetRoleNameField = targetPane.addTextField(this.mData.getTargetRoleName(), this.mMode == 1, gridLayoutData);
        this.mTargetRoleNameField.addModifyListener((ModifyListener)new TargetRoleNameListener());
        targetPane.addTextLabel(MODEL_CLASS);
        gridLayoutData = targetPane.createGridLayoutData(4, 1, true, false);
        this.mTargetModelClassCombo = targetPane.addComboBox(this.mData.getTargetModelClassNames(), this.mData.getTargetModelClass().getName(), true, gridLayoutData);
        this.mTargetModelClassCombo.addSelectionListener((SelectionListener)new TargetClassListener());
        targetPane.addTextLabel(CARDINALITY);
        gridLayoutData = targetPane.createGridLayoutData(4, 1, true, false);
        this.mTargetCardinalityCombo = targetPane.addComboBox(this.mData.getCardinalityTexts(), this.mData.getTargetCardinality().getDescriptiveText(), true, gridLayoutData);
        this.mTargetCardinalityCombo.addSelectionListener((SelectionListener)new TargetCardinalityListener());
        targetPane.addTextLabel(NAVIGABLE);
        gridLayoutData = targetPane.createGridLayoutData(4, 1, true, false);
        this.mTargetNavigableBox = targetPane.addCheckBox("");
        this.mTargetNavigableBox.setSelection(this.mData.getTargetNavigable());
        this.mTargetNavigableBox.addSelectionListener((SelectionListener)new TargetNavigableListener());
        targetPane.addTextLabel(AGGREGATION);
        gridLayoutData = targetPane.createGridLayoutData(4, 1, true, false);
        this.mTargetAggregationBox = targetPane.addCheckBox("");
        this.mTargetAggregationBox.setSelection(this.mData.getTargetAggregation());
        this.mTargetAggregationBox.addSelectionListener((SelectionListener)new TargetAggregationListener());
        pane.addPlaceholder(10, 10);
        IGridLayoutPane sourcePane = PaneFactory.createGridLayoutPaneWithTitle((Composite)pane.getComposite(), (String)"Source Role", (int)2);
        GridData sourceGridData = new GridData(1808);
        sourcePane.setLayoutData((Object)sourceGridData);
        sourcePane.addTextLabel(ROLE_NAME);
        gridLayoutData = sourcePane.createGridLayoutData(4, 1, true, false);
        this.mSourceRoleNameField = sourcePane.addTextField(this.mData.getSourceRoleName(), this.mMode == 1, gridLayoutData);
        this.mSourceRoleNameField.addModifyListener((ModifyListener)new SourceRoleNameListener());
        sourcePane.addTextLabel(MODEL_CLASS);
        gridLayoutData = sourcePane.createGridLayoutData(4, 1, true, false);
        this.mSourceModelClassCombo = sourcePane.addComboBox(new String[]{this.mData.getSourceModelClass().getName()}, this.mData.getSourceModelClass().getName(), true, gridLayoutData);
        this.mSourceModelClassCombo.setEnabled(false);
        sourcePane.addTextLabel(CARDINALITY);
        gridLayoutData = sourcePane.createGridLayoutData(4, 1, true, false);
        this.mSourceCardinalityCombo = sourcePane.addComboBox(this.mData.getCardinalityTexts(), this.mData.getSourceCardinality().getDescriptiveText(), true, gridLayoutData);
        this.mSourceCardinalityCombo.addSelectionListener((SelectionListener)new SourceCardinalityListener());
        sourcePane.addTextLabel(NAVIGABLE);
        gridLayoutData = sourcePane.createGridLayoutData(4, 1, true, false);
        this.mSourceNavigableBox = sourcePane.addCheckBox("");
        this.mSourceNavigableBox.setSelection(this.mData.getSourceNavigable());
        this.mSourceNavigableBox.addSelectionListener((SelectionListener)new SourceNavigableListener());
        sourcePane.addTextLabel(AGGREGATION);
        gridLayoutData = sourcePane.createGridLayoutData(4, 1, true, false);
        this.mSourceAggregationBox = sourcePane.addCheckBox("");
        this.mSourceAggregationBox.setSelection(this.mData.getSourceAggregation());
        this.mSourceAggregationBox.addSelectionListener((SelectionListener)new SourceAggregationListener());
        pane.addPlaceholder(10, 10);
        relationPane.addTextLabel(RELATION_NAME);
        gridLayoutData = relationPane.createGridLayoutData(4, 1, true, false);
        this.mModelRelationNameField = relationPane.addTextField(this.mData.getModelRelationName(), this.mMode == 1, gridLayoutData);
        this.mModelRelationNameField.setText(this.mModelClass.getName());
        this.mModelRelationNameField.addModifyListener((ModifyListener)new RelationNameListener());
        this.mTargetRoleNameField.setFocus();
        this.mTargetRoleNameField.addTraverseListener((TraverseListener)new TargetRoleNameTraverseListener());
        this.mTargetModelClassCombo.addTraverseListener((TraverseListener)new TargetModelClassTraverseListener());
        this.mTargetCardinalityCombo.addTraverseListener((TraverseListener)new TargetCardinalityTraverseListener());
        this.mTargetNavigableBox.addTraverseListener((TraverseListener)new TargetNavigableTraverseListener());
        this.mTargetAggregationBox.addTraverseListener((TraverseListener)new TargetAggregationTraverseListener());
        this.mSourceRoleNameField.addTraverseListener((TraverseListener)new SourceRoleNameTraverseListener());
        this.mSourceCardinalityCombo.addTraverseListener((TraverseListener)new SourceCardinalitiyTraverseListener());
        this.mSourceNavigableBox.addTraverseListener((TraverseListener)new SourceNavigableTraverseListener());
        this.mSourceAggregationBox.addTraverseListener((TraverseListener)new SourceAggregationTraverseListener());
        this.mModelRelationNameField.addTraverseListener((TraverseListener)new ModelRelationNameTraverseListener());
    }

    private void handlePageCompletion() {
        if (this.isValidRelationName() && this.isValidSourceRoleName() && this.isValidTargetRoleName() && this.isValidNavigability()) {
            this.mData.setModelRelationName(this.mModelRelationNameField.getText());
            this.mData.setSourceRoleName(this.mSourceRoleNameField.getText());
            this.mData.setSourceCardinality(this.mSourceCardinalityCombo.getSelectionIndex());
            this.mData.setSourceNavigable(this.mSourceNavigableBox.getSelection());
            this.mData.setSourceAggregation(this.mSourceAggregationBox.getSelection());
            this.mData.setTargetRoleName(this.mTargetRoleNameField.getText());
            this.mData.setTargetModelClass(this.mTargetModelClassCombo.getSelectionIndex());
            this.mData.setTargetCardinality(this.mTargetCardinalityCombo.getSelectionIndex());
            this.mData.setTargetNavigable(this.mTargetNavigableBox.getSelection());
            this.mData.setTargetAggregation(this.mTargetAggregationBox.getSelection());
            this.mDisplayErrorListener.setErrorMessage(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidRelationName() {
        String relationName = this.mModelRelationNameField.getText();
        if (relationName.length() > 0) {
            if (!this.mModelClass.getModel().hasModelRelation(relationName)) return true;
            this.mDisplayErrorListener.setErrorMessage(mTPool.getText(5, (Object)relationName));
            return false;
        } else {
            this.mDisplayErrorListener.setErrorMessage(mTPool.getText(1, (Object)MODEL_RELATION));
        }
        return false;
    }

    private boolean isValidSourceRoleName() {
        String roleName = this.mSourceRoleNameField.getText();
        if (this.mData.getSourceNavigable()) {
            if (roleName.length() > 0) {
                ModelRelationRole role = ModelClassHelper.getTargetRole((ModelClass)this.mData.getTargetModelClass(), (String)roleName);
                if (role != null && (this.mData.getModelRelationInfo() == null || this.mData.getModelRelationInfo() != null && this.mData.getModelRelationInfo().getTargetRole() != role && this.mData.getModelRelationInfo().getSourceRole() != role)) {
                    this.mDisplayErrorListener.setErrorMessage(mTPool.getText(8, (Object)roleName));
                    return false;
                }
            } else {
                this.mDisplayErrorListener.setErrorMessage(mTPool.getText(1, (Object)SOURCE_ROLE));
                return false;
            }
        }
        return true;
    }

    private boolean isValidTargetRoleName() {
        String roleName = this.mTargetRoleNameField.getText();
        if (this.mData.getTargetNavigable()) {
            if (roleName.length() > 0) {
                ModelRelationRole role = ModelClassHelper.getTargetRole((ModelClass)this.mModelClass, (String)roleName);
                if (role != null && (this.mData.getModelRelationInfo() == null || this.mData.getModelRelationInfo() != null && this.mData.getModelRelationInfo().getTargetRole() != role && this.mData.getModelRelationInfo().getSourceRole() != role)) {
                    this.mDisplayErrorListener.setErrorMessage(mTPool.getText(8, (Object)roleName));
                    return false;
                }
            } else {
                this.mDisplayErrorListener.setErrorMessage(mTPool.getText(1, (Object)TARGET_ROLE));
                return false;
            }
        }
        return true;
    }

    private boolean isValidNavigability() {
        if (this.mSourceNavigableBox.getSelection() || this.mTargetNavigableBox.getSelection() || this.mSourceAggregationBox.getSelection() || this.mTargetAggregationBox.getSelection()) {
            return true;
        }
        this.mDisplayErrorListener.setErrorMessage(mTPool.getText(20));
        return false;
    }

    class ModelRelationNameTraverseListener
    implements TraverseListener {
        ModelRelationNameTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mTargetRoleNameField.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                if (RelationEditUI.this.mSourceAggregationBox.isEnabled()) {
                    RelationEditUI.this.mSourceAggregationBox.setFocus();
                } else {
                    RelationEditUI.this.mSourceNavigableBox.setFocus();
                }
                e.doit = false;
            }
        }
    }

    class SourceAggregationTraverseListener
    implements TraverseListener {
        SourceAggregationTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mModelRelationNameField.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mSourceNavigableBox.setFocus();
                e.doit = false;
            }
        }
    }

    class SourceNavigableTraverseListener
    implements TraverseListener {
        SourceNavigableTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                if (RelationEditUI.this.mSourceAggregationBox.isEnabled()) {
                    RelationEditUI.this.mSourceAggregationBox.setFocus();
                } else {
                    RelationEditUI.this.mModelRelationNameField.setFocus();
                }
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mSourceCardinalityCombo.setFocus();
                e.doit = false;
            }
        }
    }

    class SourceCardinalitiyTraverseListener
    implements TraverseListener {
        SourceCardinalitiyTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mSourceNavigableBox.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mSourceRoleNameField.setFocus();
                e.doit = false;
            }
        }
    }

    class SourceRoleNameTraverseListener
    implements TraverseListener {
        SourceRoleNameTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mSourceCardinalityCombo.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                if (RelationEditUI.this.mTargetAggregationBox.isEnabled()) {
                    RelationEditUI.this.mTargetAggregationBox.setFocus();
                } else {
                    RelationEditUI.this.mTargetNavigableBox.setFocus();
                }
                e.doit = false;
            }
        }
    }

    class TargetAggregationTraverseListener
    implements TraverseListener {
        TargetAggregationTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mSourceRoleNameField.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mTargetNavigableBox.setFocus();
                e.doit = false;
            }
        }
    }

    class TargetNavigableTraverseListener
    implements TraverseListener {
        TargetNavigableTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                if (RelationEditUI.this.mTargetAggregationBox.isEnabled()) {
                    RelationEditUI.this.mTargetAggregationBox.setFocus();
                } else {
                    RelationEditUI.this.mSourceRoleNameField.setFocus();
                }
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mTargetCardinalityCombo.setFocus();
                e.doit = false;
            }
        }
    }

    class TargetCardinalityTraverseListener
    implements TraverseListener {
        TargetCardinalityTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mTargetNavigableBox.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mTargetModelClassCombo.setFocus();
                e.doit = false;
            }
        }
    }

    class TargetModelClassTraverseListener
    implements TraverseListener {
        TargetModelClassTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mTargetCardinalityCombo.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mTargetRoleNameField.setFocus();
                e.doit = false;
            }
        }
    }

    class TargetRoleNameTraverseListener
    implements TraverseListener {
        TargetRoleNameTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                RelationEditUI.this.mTargetModelClassCombo.setFocus();
                e.doit = false;
            } else if (e.detail == 8) {
                RelationEditUI.this.mModelRelationNameField.setFocus();
                e.doit = false;
            }
        }
    }

    class TargetCardinalityListener
    implements SelectionListener {
        TargetCardinalityListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            RelationEditUI.this.mData.setTargetCardinality(RelationEditUI.this.mTargetCardinalityCombo.getSelectionIndex());
        }
    }

    class TargetAggregationListener
    implements SelectionListener {
        TargetAggregationListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            boolean checked = RelationEditUI.this.mTargetAggregationBox.getSelection();
            if (checked) {
                RelationEditUI.this.mSourceAggregationBox.setSelection(false);
                RelationEditUI.this.mSourceAggregationBox.setEnabled(false);
            } else {
                RelationEditUI.this.mSourceAggregationBox.setEnabled(true);
            }
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class TargetNavigableListener
    implements SelectionListener {
        TargetNavigableListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class TargetClassListener
    implements SelectionListener {
        TargetClassListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class TargetRoleNameListener
    implements ModifyListener {
        TargetRoleNameListener() {
        }

        public void modifyText(ModifyEvent e) {
            RelationEditUI.this.mModelRelationNameField.setText(RelationEditUI.this.mModelClass.getName() + '.' + RelationEditUI.this.mTargetRoleNameField.getText());
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class SourceCardinalityListener
    implements SelectionListener {
        SourceCardinalityListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            RelationEditUI.this.mData.setSourceCardinality(RelationEditUI.this.mSourceCardinalityCombo.getSelectionIndex());
        }
    }

    class SourceAggregationListener
    implements SelectionListener {
        SourceAggregationListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            boolean checked = RelationEditUI.this.mSourceAggregationBox.getSelection();
            if (checked) {
                RelationEditUI.this.mTargetAggregationBox.setSelection(false);
                RelationEditUI.this.mTargetAggregationBox.setEnabled(false);
            } else {
                RelationEditUI.this.mTargetAggregationBox.setEnabled(true);
            }
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class SourceNavigableListener
    implements SelectionListener {
        SourceNavigableListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class SourceRoleNameListener
    implements ModifyListener {
        SourceRoleNameListener() {
        }

        public void modifyText(ModifyEvent e) {
            RelationEditUI.this.handlePageCompletion();
        }
    }

    class RelationNameListener
    implements ModifyListener {
        RelationNameListener() {
        }

        public void modifyText(ModifyEvent e) {
            RelationEditUI.this.handlePageCompletion();
        }
    }
}

