/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.properties;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.modeleditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.modeleditor.wizards.property.creation.PropertyWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class PropertyEditUI {
    private PropertyWizardData mData;
    private int mMode;
    private Text mNameField;
    private Combo mTypeField;
    private Combo mVisibilityField;
    private Button mReadOnlyCheckBox;
    private Button mTypeSelectionButton;
    private IDisplayErrorListener mDisplayErrorListener;

    public PropertyEditUI(PropertyWizardData data, IDisplayErrorListener displayErrorListener, int mode) {
        this.mDisplayErrorListener = displayErrorListener;
        this.mData = data;
        this.mMode = mode;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(TextPool.getInstance().getText(421));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mVisibilityField = glp.addComboBox(MetamodelServices.getVisibilityEnumNames(), this.mData.getVisibilityName(), true, gd);
        this.mVisibilityField.select(this.mData.getVisibilityAsInt());
        this.mVisibilityField.setEnabled(false);
        this.mVisibilityField.addSelectionListener((SelectionListener)new VisibilitySelectionListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(TextPool.getInstance().getText(419));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(TextPool.getInstance().getText(420));
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] items = this.mData.getTypeNames();
        String defaultItem = this.mData.getTypeName();
        this.mTypeField = glp.addComboBox(items, defaultItem, true, gd);
        this.mTypeField.addSelectionListener((SelectionListener)new TypeSelectionListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        this.mTypeSelectionButton = glp.addPushButton("...", gd);
        this.mTypeSelectionButton.addSelectionListener((SelectionListener)new TypeSelectionButtonListener());
        glp.addPlaceholder();
        gd = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        this.mReadOnlyCheckBox = glp.addCheckBox(TextPool.getInstance().getText(423), false, gd);
        this.mReadOnlyCheckBox.setSelection(this.mData.getIsReadOnly());
        this.mReadOnlyCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyEditUI.this.mData.setIsReadOnly(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mNameField.setFocus();
    }

    public static String isValidPropertyName(String propertyName, AppClass object) {
        if (!CheckServices.isValidIdentifier((String)propertyName)) {
            return CoreTextPool.getInstance().getText(1, (Object)propertyName);
        }
        if (object.hasProperty(propertyName)) {
            return TextPool.getInstance().getText(15, (Object)TextPool.getInstance().getText(417), (Object)propertyName);
        }
        return null;
    }

    private class TypeSelectionButtonListener
    implements SelectionListener {
        private TypeSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)PropertyEditUI.this.mData.getModelClass().getRoot().getMetamodel());
            MetamodelServices.CompoundType type = PropertyEditUI.this.mData.getType();
            JavaNativeType initialType = null;
            if (type != null) {
                Object object = initialType = type.isJavaNativeType() ? type.getJavaNativeType() : type.getSimpleType();
            }
            if ((type = UIHelper.selectType((DtDictionaryRoot)ddicRoot, initialType)) != null) {
                PropertyEditUI.this.mData.setType(type);
                PropertyEditUI.this.mTypeField.setItems(PropertyEditUI.this.mData.getTypeNames());
                PropertyEditUI.this.mTypeField.select(PropertyEditUI.this.mData.getTypeIdx());
                PropertyEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class TypeSelectionListener
    implements SelectionListener {
        private TypeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PropertyEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            PropertyEditUI.this.mData.setType(PropertyEditUI.this.mTypeField.getSelectionIndex());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String error = PropertyEditUI.isValidPropertyName(PropertyEditUI.this.mNameField.getText(), (AppClass)PropertyEditUI.this.mData.getModelClass());
            if (error == null) {
                PropertyEditUI.this.mDisplayErrorListener.setErrorMessage(null);
                PropertyEditUI.this.mData.setName(PropertyEditUI.this.mNameField.getText());
            } else {
                PropertyEditUI.this.mDisplayErrorListener.setErrorMessage(error);
            }
        }
    }

    class VisibilitySelectionListener
    implements SelectionListener {
        VisibilitySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PropertyEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            PropertyEditUI.this.mData.setVisibility(PropertyEditUI.this.mVisibilityField.getSelectionIndex());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

