/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.properties;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.modeleditor.properties.PropertyEditDialog;
import com.sap.ide.webdynpro.modeleditor.wizards.property.creation.PropertyWizard;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceCreation;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class PropertiesTableModel
extends AbstractTableModel {
    public static final int COLUMN_ICON = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_TYPE = 2;
    private static final int COLUMN_FIELD = 3;
    protected ModelClassProperty[] mProperties = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty;
    static /* synthetic */ Class class$java$lang$String;

    public PropertiesTableModel(ModelClass modelClass) {
        super(modelClass);
        if (ModelHelper.getStructureBindingEnabled((ModelClass)this.getModelClass())) {
            this.setNumberOfColumns(4);
            this.setColumnNames(new String[]{AbstractTableModel.mTextPool.getText(327), AbstractTableModel.mTextPool.getText(329), AbstractTableModel.mTextPool.getText(328), AbstractTableModel.mTextPool.getText(356)});
            this.setColumnClasses(new Class[]{class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty == null ? (class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty = PropertiesTableModel.class$("com.sap.ide.metamodel.webdynpro.model.ModelClassProperty")) : class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty, class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String});
        } else {
            this.setNumberOfColumns(3);
            this.setColumnNames(new String[]{AbstractTableModel.mTextPool.getText(327), AbstractTableModel.mTextPool.getText(329), AbstractTableModel.mTextPool.getText(328)});
            this.setColumnClasses(new Class[]{class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty == null ? (class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty = PropertiesTableModel.class$("com.sap.ide.metamodel.webdynpro.model.ModelClassProperty")) : class$com$sap$ide$metamodel$webdynpro$model$ModelClassProperty, class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String});
        }
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mProperties.length) {
            return null;
        }
        return this.mProperties[index];
    }

    public int getRowCount() {
        if (this.mProperties == null) {
            return 0;
        }
        return this.mProperties.length;
    }

    public int[] getColumnWidths() {
        if (this.getModelClass().getModel().getModelType().getStructureBindingEnabled()) {
            return new int[]{18, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        }
        return new int[]{18, Integer.MAX_VALUE, Integer.MAX_VALUE};
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mProperties == null) {
            return AbstractTableModel.ERROR;
        }
        if (rowIndex >= this.mProperties.length) {
            return AbstractTableModel.ERROR;
        }
        if (this.mProperties[rowIndex] == null) {
            return AbstractTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return this.mProperties[rowIndex];
            }
            case 1: {
                if (this.mProperties[rowIndex].getParent().equals(this.getModelClass())) {
                    return this.mProperties[rowIndex].getName();
                }
                return this.mProperties[rowIndex].getName() + " (from " + this.mProperties[rowIndex].getParent().getName() + ")";
            }
            case 2: {
                DevelopmentObject type = ModelClassHelper.getType((ModelClassProperty)this.mProperties[rowIndex]);
                if (type != null) {
                    MetamodelServices.CompoundType compType = new MetamodelServices.CompoundType(type);
                    if (compType.isJavaNativeType()) {
                        return compType.getQualifiedName();
                    }
                    return compType.getName();
                }
                return AbstractTableModel.ERROR;
            }
            case 3: {
                if (this.mProperties[rowIndex].hasStructureElement()) {
                    return this.mProperties[rowIndex].getStructureElement().getName();
                }
                return "";
            }
        }
        return null;
    }

    protected void updateDataTable() {
        if (this.getModelClass().isValid()) {
            this.mProperties = ModelClassHelper.getProperties((ModelClass)this.getModelClass(), (boolean)this.getShowInherited());
            ModelClassHelper.sort((ModelClass)this.getModelClass(), (ModelClassProperty[])this.mProperties);
        }
    }

    protected void doEdit(int index) {
        ModelClassProperty property = this.mProperties[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByPropertyModification((Property)property))) {
            return;
        }
        PropertyEditDialog dialog = new PropertyEditDialog((Property)this.mProperties[index], 1);
        if (dialog.open() == 0) {
            DevelopmentObject type = ModelClassHelper.getType((ModelClassProperty)property);
            if (type != null && !type.equals(dialog.getType())) {
                MetamodelServices.setType((Property)property, (MetamodelServices.CompoundType)dialog.getType());
            }
            if (!property.getVisibility().equals(dialog.getVisibility())) {
                property.setVisibility(dialog.getVisibility());
            }
            if (property.getReadonly() != dialog.getIsReadOnly()) {
                property.setReadonly(dialog.getIsReadOnly());
            }
        }
    }

    protected void doCopy(int index) {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByPropertyCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        PropertyEditDialog dialog = new PropertyEditDialog((Property)this.mProperties[index], 2);
        if (dialog.open() == 0) {
            ModelClassProperty newProperty = null;
            try {
                newProperty = ServiceCreation.createProperty((ModelClass)this.getModelClass(), (String)dialog.getName(), (MetamodelServices.CompoundType)dialog.getType(), (VisibilityEnum)dialog.getVisibility(), (boolean)dialog.getIsReadOnly());
            }
            catch (CreateException e) {
                ModelEditorPlugin.internalError(this.getClass(), "doCopy(int)", e.getMessage(), e, false);
                return;
            }
        }
    }

    protected void doDelete(int index) {
        ModelClassProperty property = this.mProperties[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByPropertyDeletion((Property)property))) {
            return;
        }
        if (UIHelper.askUserToDelete((String)property.getName(), (String)AbstractTableModel.mTextPool.getText(422))) {
            try {
                property.delete();
            }
            catch (DeleteException e) {
                ModelEditorPlugin.internalError(this.getClass(), "doDelete(int)", e.getMessage(), e, false);
            }
        }
    }

    protected void doNew() {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByPropertyCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new PropertyWizard(this.getModelClass()));
        dialog.open();
        dialog.close();
    }

    protected boolean isEditAllowed(int index) {
        return this.mProperties[index].getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassPropertyDeletable((ModelClassProperty)this.mProperties[index]);
    }

    protected boolean isDeleteAllowed(int index) {
        return this.mProperties[index].getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassPropertyDeletable((ModelClassProperty)this.mProperties[index]);
    }

    protected boolean isCopyAllowed(int index) {
        return MetamodelServices.canCreateModelClassProperty((ModelClass)this.getModelClass());
    }

    protected boolean isRefreshNeeded(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ModelClassProperty || event.getModifiedObject() instanceof ModelClass) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    return true;
                }
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

