/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.parameters;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DataStateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.modeleditor.parameters.ParameterEditDialog;
import com.sap.ide.webdynpro.modeleditor.wizards.parameter.creation.ParameterWizard;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public abstract class ParametersTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{AbstractTableModel.mTextPool.getText(317), AbstractTableModel.mTextPool.getText(318)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ParametersTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ParametersTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    protected Parameter[] mParameters = null;
    protected ParameterizedFeature mSelectedParent = null;
    static /* synthetic */ Class class$java$lang$String;

    public ParametersTableModel(ModelClass modelClass) {
        super(modelClass);
        this.setNumberOfColumns(COLUMN_NAMES.length);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mParameters.length) {
            return null;
        }
        return this.mParameters[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
        if (newMasterObject instanceof ParameterizedFeature) {
            this.mSelectedParent = (ParameterizedFeature)newMasterObject;
            this.mSelectionIndex = -1;
            this.updateDataTable();
        }
    }

    protected void updateDataTable() {
        if (this.mSelectedParent == null) {
            this.mParameters = new Parameter[0];
            return;
        }
        this.mSelectionIndex = -1;
        ParameterizedFeature parameterizedFeature = this.mSelectedParent;
        if (parameterizedFeature == null || !parameterizedFeature.isValid()) {
            this.mParameters = new Parameter[0];
            return;
        }
        try {
            this.mParameters = parameterizedFeature.getParameters();
        }
        catch (DataStateException e) {
            this.mParameters = new Parameter[0];
            return;
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.mParameters == null) {
            return 0;
        }
        return this.mParameters.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mParameters == null) {
            return AbstractTableModel.ERROR;
        }
        if (rowIndex >= this.mParameters.length) {
            return AbstractTableModel.ERROR;
        }
        Parameter parameter = this.mParameters[rowIndex];
        if (parameter == null) {
            return AbstractTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return parameter.getName();
            }
            case 1: {
                if (parameter.getType() != null) {
                    MetamodelServices.CompoundType type = new MetamodelServices.CompoundType(parameter.getType());
                    if (type.isJavaNativeType()) {
                        return type.getQualifiedName();
                    }
                    return type.getName();
                }
                return AbstractTableModel.ERROR;
            }
        }
        return AbstractTableModel.ERROR;
    }

    protected void doEdit(int index) {
        Parameter parameter = this.mParameters[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter))) {
            return;
        }
        ParameterEditDialog dialog = new ParameterEditDialog(parameter, 1);
        if (dialog.open() == 0 && dialog.getType() != null) {
            if (parameter.getType() != null) {
                if (!dialog.getType().equals((Object)new MetamodelServices.CompoundType(parameter.getType()))) {
                    MetamodelServices.setType((Parameter)parameter, (MetamodelServices.CompoundType)dialog.getType());
                }
            } else {
                MetamodelServices.setType((Parameter)parameter, (MetamodelServices.CompoundType)dialog.getType());
            }
        }
    }

    protected void doCopy(int index) {
        if (this.mSelectedParent == null) {
            return;
        }
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByParameterCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        ParameterizedFeature object = this.mSelectedParent;
        Parameter parameter = this.mParameters[index];
        ParameterEditDialog dialog = new ParameterEditDialog(parameter, 2);
        if (dialog.open() == 0) {
            Parameter newParameter = null;
            try {
                newParameter = object.createParameter(dialog.getName());
            }
            catch (CreateException e) {
                ModelEditorPlugin.internalError(this.getClass(), "doCopy(int)", e.getMessage(), e, false);
                return;
            }
            MetamodelServices.setType((Parameter)newParameter, (MetamodelServices.CompoundType)dialog.getType());
        }
    }

    protected void doDelete(int index) {
        Parameter parameter = this.mParameters[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByParameterDeletion((Parameter)parameter))) {
            return;
        }
        if (UIHelper.askUserToDelete((String)parameter.getName(), (String)AbstractTableModel.mTextPool.getText(417))) {
            try {
                parameter.delete();
            }
            catch (DeleteException e) {
                ModelEditorPlugin.internalError(this.getClass(), "doDelete(int)", e.getMessage(), e, false);
            }
        }
    }

    protected void doNew() {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByParameterCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new ParameterWizard(this.mSelectedParent));
        dialog.open();
        dialog.close();
        this.refresh();
    }

    protected boolean isEditAllowed(int index) {
        return this.mSelectedParent.getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassMethodDeletable((ModelClassMethod)((ModelClassMethod)this.mSelectedParent));
    }

    protected boolean isDeleteAllowed(int index) {
        return this.mSelectedParent.getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassMethodDeletable((ModelClassMethod)((ModelClassMethod)this.mSelectedParent));
    }

    protected boolean isCopyAllowed(int index) {
        return this.mSelectedParent.getParent().equals(this.getModelClass()) && MetamodelServices.canCreateModelClassMethod((ModelClass)this.getModelClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

