/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.parameters;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.modeleditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.modeleditor.wizards.parameter.creation.ParameterWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ParameterEditUI {
    private ParameterWizardData mData;
    private int mMode;
    private Text mNameField;
    private Combo mTypeField;
    private Button mTypeSelectionButton;
    private IDisplayErrorListener mDisplayErrorListener;

    public ParameterEditUI(ParameterWizardData data, IDisplayErrorListener displayErrorListener, int mode) {
        this.mDisplayErrorListener = displayErrorListener;
        this.mData = data;
        this.mMode = mode;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(TextPool.getInstance().getText(415));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(TextPool.getInstance().getText(416));
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] items = this.mData.getTypeNames();
        String defaultItem = this.mData.getTypeName();
        this.mTypeField = glp.addComboBox(items, defaultItem, true, gd);
        this.mTypeField.select(this.mData.getTypeIdx() == -1 ? 0 : this.mData.getTypeIdx());
        this.mTypeField.addModifyListener((ModifyListener)new TypeModifyListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        this.mTypeSelectionButton = glp.addPushButton("...", gd);
        this.mTypeSelectionButton.addSelectionListener((SelectionListener)new TypeSelectionButtonListener());
    }

    public static String isValidParameterName(String parameterName, ParameterizedFeature object) {
        if (!CheckServices.isValidIdentifier((String)parameterName)) {
            return CoreTextPool.getInstance().getText(1, (Object)parameterName);
        }
        if (object.hasParameter(parameterName)) {
            return TextPool.getInstance().getText(15, (Object)TextPool.getInstance().getText(417), (Object)parameterName);
        }
        return null;
    }

    private class TypeSelectionButtonListener
    implements SelectionListener {
        private TypeSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)ParameterEditUI.this.mData.getProcedure().getRoot().getMetamodel());
            MetamodelServices.CompoundType type = ParameterEditUI.this.mData.getType();
            JavaNativeType initialType = null;
            if (type != null) {
                Object object = initialType = type.isJavaNativeType() ? type.getJavaNativeType() : type.getSimpleType();
            }
            if ((type = UIHelper.selectType((DtDictionaryRoot)ddicRoot, initialType)) != null) {
                ParameterEditUI.this.mData.setType(type);
                ParameterEditUI.this.mTypeField.setItems(ParameterEditUI.this.mData.getTypeNames());
                ParameterEditUI.this.mTypeField.select(ParameterEditUI.this.mData.getTypeIdx());
                ParameterEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class TypeModifyListener
    implements ModifyListener {
        private TypeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ParameterEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            ParameterEditUI.this.mData.setType(ParameterEditUI.this.mTypeField.getSelectionIndex());
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String error = ParameterEditUI.isValidParameterName(ParameterEditUI.this.mNameField.getText(), ParameterEditUI.this.mData.getProcedure());
            if (error == null) {
                ParameterEditUI.this.mDisplayErrorListener.setErrorMessage(null);
                ParameterEditUI.this.mData.setName(ParameterEditUI.this.mNameField.getText());
            } else {
                ParameterEditUI.this.mDisplayErrorListener.setErrorMessage(error);
            }
        }
    }
}

