/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.repository.ModelClassRepositoryManager;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.modeleditor.AbstractSectionForm;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.overview.InterfacesSection;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OverviewForm
extends AbstractSectionForm
implements DisposeListener {
    private Button mBtIsAbstract;
    private Button mBtIsInterface;
    private Combo mComboSuperClass;
    private InterfacesSection mInterfacesSection;
    private DevelopmentObjectObserver mModelObserver = new ModelObserver();
    private Model mModel;

    public OverviewForm(ModelClass modelClass) {
        super(AbstractSectionForm.mTextPool.getText(341), 2, true, modelClass);
        this.mModel = modelClass.getModel();
    }

    public void initSectionForm(IGridLayoutPane glp) {
        glp.setSpacing(5, 5);
        this.getUserAreaGridLayoutPane().addDisposeListener((DisposeListener)this);
        this.mModel.attachObserver(this.mModelObserver, 3);
        IGridLayoutData gld = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        this.mBtIsAbstract = glp.addCheckBox(TextPool.getInstance().getText(430), this.getModelClass().getIsAbstract(), gld);
        this.mBtIsAbstract.setEnabled(false);
        this.mBtIsAbstract.addSelectionListener((SelectionListener)new IsAbstractSelectionListener());
        gld = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        this.mBtIsInterface = glp.addCheckBox(TextPool.getInstance().getText(431), this.getModelClass().getIsInterface(), gld);
        this.mBtIsInterface.setEnabled(false);
        this.mBtIsInterface.addSelectionListener((SelectionListener)new IsInterfaceSelectionListener());
        gld = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        glp.addTextLabel("", gld);
        glp.addHorizontalSeparator();
        gld = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        glp.addTextLabel("", gld);
        if (!this.getModelClass().getIsInterface() && MetamodelServices.supportsInheritance((Model)this.mModel)) {
            glp.addTextLabel(TextPool.getInstance().getText(432));
            gld = glp.createGridLayoutData(4, 4, false, false, 1, 1);
            this.mComboSuperClass = glp.addComboBox(new String[0], "", true, gld);
            this.mComboSuperClass.addSelectionListener((SelectionListener)new SuperNameSelectionListener());
        }
        if (ModelHelper.getStructureBindingEnabled((ModelClass)this.getModelClass())) {
            DevelopmentObject structure = this.getModelClass().getStructure();
            String structureName = "";
            if (structure != null) {
                structureName = structure instanceof MainDevelopmentObject ? ((MainDevelopmentObject)structure).getQualifiedName() : structure.getName();
            }
            glp.addTextLabel(TextPool.getInstance().getText(452));
            gld = glp.createGridLayoutData(4, 4, false, false, 1, 1);
            Text structureField = glp.addTextField(true, gld);
            structureField.setText(structureName);
        }
        gld = glp.createGridLayoutData(4, 4, false, false, 2, 1);
        glp.addTextLabel("", gld);
        if (MetamodelServices.supportsInterfaces((Model)this.getModelClass().getModel())) {
            this.mInterfacesSection = new InterfacesSection(this.getModelClass());
            gld = glp.createGridLayoutData(4, 4, false, true, 2, 1);
            glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.mInterfacesSection, gld);
        }
        this.updateUIInternal();
    }

    public void updateUI() {
        this.updateUIInternal();
        if (MetamodelServices.supportsInterfaces((Model)this.getModelClass().getModel())) {
            ((AbstractTableModel)this.mInterfacesSection.getTableModel()).refresh();
        }
        this.getUserAreaGridLayoutPane().getComposite().update();
        this.getUserAreaGridLayoutPane().getComposite().redraw();
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.mModel.isValid()) {
            this.mModel.detachObserver(this.mModelObserver);
        }
    }

    private void updateUIInternal() {
        ModelClass modelClass = this.getModelClass();
        if (this.mBtIsAbstract.getSelection() != modelClass.getIsAbstract()) {
            this.mBtIsAbstract.setSelection(modelClass.getIsAbstract());
        }
        if (this.mBtIsInterface.getSelection() != modelClass.getIsInterface()) {
            this.mBtIsInterface.setSelection(modelClass.getIsInterface());
        }
        if (!this.getModelClass().getIsInterface() && MetamodelServices.supportsInheritance((Model)this.mModel)) {
            ModelClass superClass = (ModelClass)modelClass.getSuperClass();
            String superClassName = superClass == null ? "" : superClass.getQualifiedName();
            ModelClass[] classes = null;
            classes = modelClass.getIsInterface() ? ModelHelper.getInterfaces((Model)modelClass.getModel(), (boolean)true, (ModelClass[])new ModelClass[]{modelClass}) : ModelHelper.getModelClasses((Model)modelClass.getModel(), (boolean)true, (ModelClass[])new ModelClass[]{modelClass});
            Object[] classNames = ModelHelper.getQualifiedModelClassNames((ModelClass[])classes);
            Arrays.sort(classNames);
            this.mComboSuperClass.setItems((String[])classNames);
            this.mComboSuperClass.add("");
            int idx = OverviewForm.find(superClassName, (String[])classNames);
            if (idx != -1) {
                this.mComboSuperClass.select(idx);
            }
            this.mComboSuperClass.setEnabled(!this.getModelClass().getIsInterface() && MetamodelServices.supportsInheritance((Model)modelClass.getModel()));
        }
        this.mBtIsInterface.setEnabled(false);
        this.mBtIsAbstract.setEnabled(false);
    }

    private static int find(String item, String[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class ModelObserver
    implements DevelopmentObjectObserver {
        private ModelObserver() {
        }

        public void update(MetamodelEvent event) {
            if (event.getEventId() == 1 && event.getModifiedObject() instanceof ModelClass) {
                OverviewForm.this.updateUI();
                OverviewForm.this.getUserAreaGridLayoutPane().getComposite().update();
                OverviewForm.this.getUserAreaGridLayoutPane().getComposite().redraw();
            }
        }

        public void update(MetamodelEvent[] events) {
            if (events.length > 0) {
                this.update(events[0]);
            }
        }
    }

    private class SuperNameSelectionListener
    implements SelectionListener {
        private SuperNameSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int newIdx = OverviewForm.this.mComboSuperClass.getSelectionIndex();
            ModelClass newSuperClass = null;
            if (newIdx >= 0 && newIdx < OverviewForm.this.mComboSuperClass.getItemCount()) {
                newSuperClass = ModelHelper.getModelClass((Model)OverviewForm.super.getModelClass().getModel(), (String)OverviewForm.this.mComboSuperClass.getItem(OverviewForm.this.mComboSuperClass.getSelectionIndex()), (boolean)true);
            }
            if (newSuperClass != OverviewForm.super.getModelClass().getSuperClass()) {
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])new MMRepositoryObject[]{ModelClassRepositoryManager.getRepositioryObject((ModelClass)OverviewForm.super.getModelClass(), (boolean)false)})) {
                    this.restoreSelection();
                } else {
                    List<ModelClass> superClasses = Arrays.asList(ModelClassHelper.getSuperClasses(newSuperClass));
                    if (superClasses.contains(OverviewForm.super.getModelClass())) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TextPool.getInstance().getText(359), (String)TextPool.getInstance().getText(26, (Object)newSuperClass.getName()));
                        this.restoreSelection();
                    } else {
                        OverviewForm.super.getModelClass().setSuperClass((AppClass)newSuperClass);
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        private void restoreSelection() {
            ModelClass superClass = (ModelClass)OverviewForm.super.getModelClass().getSuperClass();
            if (superClass != null) {
                int idx = OverviewForm.find(superClass.getQualifiedName(), OverviewForm.this.mComboSuperClass.getItems());
                if (idx != -1) {
                    OverviewForm.this.mComboSuperClass.select(idx);
                }
            } else {
                OverviewForm.this.mComboSuperClass.select(OverviewForm.this.mComboSuperClass.getItems().length - 1);
            }
        }
    }

    private class IsInterfaceSelectionListener
    implements SelectionListener {
        private IsInterfaceSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (OverviewForm.super.getModelClass().getIsInterface() != ((Button)e.widget).getSelection()) {
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])new MMRepositoryObject[]{ModelClassRepositoryManager.getRepositioryObject((ModelClass)OverviewForm.super.getModelClass(), (boolean)false)})) {
                    return;
                }
                OverviewForm.super.getModelClass().setIsInterface(((Button)e.widget).getSelection());
                if (((Button)e.widget).getSelection()) {
                    OverviewForm.this.mBtIsAbstract.setEnabled(false);
                    OverviewForm.this.mBtIsAbstract.setSelection(true);
                } else {
                    OverviewForm.this.mBtIsAbstract.setEnabled(true);
                    OverviewForm.this.mBtIsAbstract.setSelection(false);
                    OverviewForm.super.getModelClass().setIsAbstract(true);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class IsAbstractSelectionListener
    implements SelectionListener {
        private IsAbstractSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (OverviewForm.super.getModelClass().getIsAbstract() != ((Button)e.widget).getSelection()) {
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])new MMRepositoryObject[]{ModelClassRepositoryManager.getRepositioryObject((ModelClass)OverviewForm.super.getModelClass(), (boolean)false)})) {
                    return;
                }
                OverviewForm.super.getModelClass().setIsAbstract(((Button)e.widget).getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

