/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.repository.ModelClassRepositoryManager;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InterfacesTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{AbstractTableModel.mTextPool.getText(342)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = InterfacesTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int[] COLUMN_WIDTHS = new int[]{Integer.MAX_VALUE};
    protected ModelClass[] mInterfaces = null;
    static /* synthetic */ Class class$java$lang$String;

    public InterfacesTableModel(ModelClass modelClass) {
        super(modelClass);
        this.setNumberOfColumns(COLUMN_NAMES.length);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mInterfaces.length) {
            return null;
        }
        return this.mInterfaces[index];
    }

    public int getRowCount() {
        if (this.mInterfaces == null) {
            return 0;
        }
        return this.mInterfaces.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mInterfaces == null) {
            return AbstractTableModel.ERROR;
        }
        if (rowIndex >= this.mInterfaces.length) {
            return AbstractTableModel.ERROR;
        }
        if (this.mInterfaces[rowIndex] == null) {
            return AbstractTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return this.mInterfaces[rowIndex].getName();
            }
        }
        return null;
    }

    protected void updateDataTable() {
        if (this.getModelClass().isValid()) {
            this.mInterfaces = ModelClassHelper.getInterfaces((ModelClass)this.getModelClass(), (boolean)this.getShowInherited());
            ModelClassHelper.sort((ModelClass)this.getModelClass(), (ModelClass[])this.mInterfaces);
        }
    }

    protected boolean isRefreshNeeded(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ModelClass) {
            switch (event.getEventId()) {
                case 128: 
                case 256: 
                case 512: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void doDelete(int index) {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])new MMRepositoryObject[]{ModelClassRepositoryManager.getRepositioryObject((ModelClass)this.getModelClass(), (boolean)false)})) {
            return;
        }
        ModelClass selInterface = this.mInterfaces[index];
        if (UIHelper.askUserToDelete((String)selInterface.getName(), (String)AbstractTableModel.mTextPool.getText(422))) {
            ModelClassService.removeInterface((ModelClass)this.getModelClass(), (ModelClass)selInterface);
        }
    }

    protected void doNew() {
        Object[] availableInterfaces;
        Object[] selInterfaces;
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])new MMRepositoryObject[]{ModelClassRepositoryManager.getRepositioryObject((ModelClass)this.getModelClass(), (boolean)false)})) {
            return;
        }
        ObjectSelectionDialog dialog = new ObjectSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TextPool.getInstance().getText(this.getModelClass().getIsInterface() ? 345 : 346), TextPool.getInstance().getText(this.getModelClass().getIsInterface() ? 222 : 223));
        dialog.setSingleSelection(false);
        dialog.setBlockOnOpen(true);
        dialog.setLabelProvider((ILabelProvider)new InterfaceLabelProvider());
        dialog.setObjectSorter(new ViewerSorter(){});
        ArrayList<ModelClass> filter = new ArrayList<ModelClass>();
        filter.addAll(Arrays.asList(ModelClassHelper.getInterfaces((ModelClass)this.getModelClass(), (boolean)false)));
        if (this.getModelClass().getIsInterface()) {
            filter.add(this.getModelClass());
        }
        if ((selInterfaces = dialog.openDialog(availableInterfaces = ModelHelper.getInterfaces((Model)this.getModelClass().getModel(), (boolean)true, (ModelClass[])filter.toArray(new ModelClass[filter.size()])))) != null) {
            int i = 0;
            while (i < selInterfaces.length) {
                List<ModelClass> interfaces;
                if (this.getModelClass().getIsInterface() && (interfaces = Arrays.asList(ModelClassHelper.getInterfaces((ModelClass)((ModelClass)selInterfaces[i])))).contains(this.getModelClass())) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TextPool.getInstance().getText(359), (String)TextPool.getInstance().getText(25, (Object)((ModelClass)selInterfaces[i]).getName()));
                } else {
                    this.getModelClass().addInterface((ModelClass)selInterfaces[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isDeleteAllowed(int index) {
        return MetamodelServices.isModelClassDeletable((ModelClass)this.getModelClass()) && this.mInterfaces.length > 0 && this.getModelClass().hasInterface(this.mInterfaces[index]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InterfaceLabelProvider
    extends LabelProvider {
        private InterfaceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ModelClass) {
                return ((ModelClass)element).getName();
            }
            return "";
        }
    }
}

