/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.methods;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.modeleditor.methods.MethodEditDialog;
import com.sap.ide.webdynpro.modeleditor.wizards.method.creation.MethodWizard;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceCreation;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class MethodsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{AbstractTableModel.mTextPool.getText(312), AbstractTableModel.mTextPool.getText(310), AbstractTableModel.mTextPool.getText(313)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$com$sap$ide$metamodel$webdynpro$enum$VisibilityEnum == null ? (class$com$sap$ide$metamodel$webdynpro$enum$VisibilityEnum = MethodsTableModel.class$("com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum")) : class$com$sap$ide$metamodel$webdynpro$enum$VisibilityEnum, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int[] COLUMN_WIDTHS = new int[]{16, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static final int COLUMN_VISIBILITY = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_RETURN_VALUE = 2;
    private ModelClassMethod[] mProcedures = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$enum$VisibilityEnum;
    static /* synthetic */ Class class$java$lang$String;

    public MethodsTableModel(ModelClass modelClass) {
        super(modelClass);
        this.setNumberOfColumns(COLUMN_NAMES.length);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mProcedures.length) {
            return null;
        }
        return this.mProcedures[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.getModelClass().isValid()) {
            this.mProcedures = ModelClassHelper.getMethods((ModelClass)this.getModelClass(), (boolean)this.getShowInherited());
            ModelClassHelper.sort((ModelClass)this.getModelClass(), (ModelClassMethod[])this.mProcedures);
        }
    }

    public int getRowCount() {
        if (this.mProcedures == null) {
            return 0;
        }
        return this.mProcedures.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mProcedures == null || this.mProcedures.length <= rowIndex) {
            return AbstractTableModel.ERROR;
        }
        ModelClassMethod procedure = this.mProcedures[rowIndex];
        if (procedure == null) {
            return AbstractTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return procedure.getVisibility();
            }
            case 1: {
                if (this.mProcedures[rowIndex].getParent().equals(this.getModelClass())) {
                    return this.mProcedures[rowIndex].getName();
                }
                return this.mProcedures[rowIndex].getName() + " (from " + this.mProcedures[rowIndex].getParent().getName() + ")";
            }
            case 2: {
                if (procedure.getReturnType() != null) {
                    MetamodelServices.CompoundType type = new MetamodelServices.CompoundType(procedure.getReturnType());
                    if (type.isJavaNativeType()) {
                        return type.getQualifiedName();
                    }
                    return type.getName();
                }
                return "void";
            }
        }
        return AbstractTableModel.ERROR;
    }

    protected void doCopy(int index) {
        ModelClassMethod procedure = this.mProcedures[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByMethodCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        MethodEditDialog dialog = new MethodEditDialog((Procedure)procedure, 2);
        if (dialog.open() == 0) {
            if (!procedure.getName().equals(dialog.getMethodName())) {
                ModelClassMethod newProcedure = null;
                try {
                    newProcedure = ServiceCreation.createMethod((ModelClass)this.getModelClass(), (String)dialog.getMethodName(), (VisibilityEnum)dialog.getVisibility(), (MetamodelServices.CompoundType)dialog.getReturnType());
                    Parameter[] parameters = procedure.getParameters();
                    int i = 0;
                    while (i < parameters.length) {
                        Parameter parameter = newProcedure.createParameter(parameters[i].getName());
                        parameter.setType(parameters[i].getType());
                        ++i;
                    }
                }
                catch (CreateException e) {
                    ModelEditorPlugin.internalError(this.getClass(), "doCopy(int)", e.getMessage(), e, false);
                    return;
                }
            }
            this.refresh();
        }
    }

    protected void doDelete(int index) {
        ModelClassMethod procedure = this.mProcedures[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByMethodDeletion((Procedure)procedure))) {
            return;
        }
        String typeName = null;
        typeName = AbstractTableModel.mTextPool.getText(414);
        if (UIHelper.askUserToDelete((String)procedure.getName(), (String)typeName)) {
            try {
                procedure.delete();
            }
            catch (DeleteException de) {
                ModelEditorPlugin.internalError(this.getClass(), "doDelete", de.getMessage(), de, false);
            }
        }
    }

    protected void doEdit(int index) {
        ModelClassMethod procedure = this.mProcedures[index];
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByMethodModification((Procedure)procedure))) {
            return;
        }
        MethodEditDialog dialog = new MethodEditDialog((Procedure)procedure, 1);
        if (dialog.open() == 0) {
            if (procedure.getVisibility() != null) {
                if (!procedure.getVisibility().equals(dialog.getVisibility())) {
                    procedure.setVisibility(dialog.getVisibility());
                }
            } else if (dialog.getVisibility() != null) {
                procedure.setVisibility(dialog.getVisibility());
            }
            if (procedure.getReturnType() != null) {
                if (!new MetamodelServices.CompoundType(procedure.getReturnType()).equals((Object)dialog.getReturnType())) {
                    MetamodelServices.setType((Procedure)procedure, (MetamodelServices.CompoundType)dialog.getReturnType());
                }
            } else if (dialog.getReturnType() != null) {
                MetamodelServices.setType((Procedure)procedure, (MetamodelServices.CompoundType)dialog.getReturnType());
            }
        }
    }

    protected void doNew() {
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])ModelRepositoryService.getRepositoryObjectsAffectedByMethodCreation((ModelClass)this.getModelClass()))) {
            return;
        }
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new MethodWizard(this.getModelClass()));
        dialog.open();
        dialog.close();
    }

    protected boolean isRefreshNeeded(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof Method || event.getModifiedObject() instanceof ModelClass) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isEditAllowed(int index) {
        return this.mProcedures[index].getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassMethodDeletable((ModelClassMethod)this.mProcedures[index]);
    }

    protected boolean isDeleteAllowed(int index) {
        return this.mProcedures[index].getParent().equals(this.getModelClass()) && MetamodelServices.isModelClassMethodDeletable((ModelClassMethod)this.mProcedures[index]);
    }

    protected boolean isCopyAllowed(int index) {
        return MetamodelServices.canCreateModelClassMethod((ModelClass)this.getModelClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

