/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.methods;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.modeleditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.modeleditor.wizards.method.creation.MethodWizardData;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.MethodService;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class MethodEditUI {
    private MethodWizardData mData;
    private int mMode;
    private Combo mVisibilityField;
    private Text mNameField;
    private Combo mReturnTypeField;
    private Button mReturnTypeSelectionButton;
    private IDisplayErrorListener mDisplayErrorListener;

    public MethodEditUI(MethodWizardData data, IDisplayErrorListener displayErrorListener, int mode) {
        this.mDisplayErrorListener = displayErrorListener;
        this.mData = data;
        this.mMode = mode;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(TextPool.getInstance().getText(410));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mVisibilityField = glp.addComboBox(MetamodelServices.getVisibilityEnumNames(), this.mData.getVisibilityName(), true, gd);
        this.mVisibilityField.select(this.mData.getVisibilityAsInt());
        this.mVisibilityField.setEnabled(false);
        this.mVisibilityField.addModifyListener((ModifyListener)new VisibilityModifyListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(TextPool.getInstance().getText(411));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(TextPool.getInstance().getText(413));
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] items = this.mData.getTypeNames();
        String defaultItem = this.mData.getTypeName();
        this.mReturnTypeField = glp.addComboBox(items, defaultItem, true, gd);
        this.mReturnTypeField.addSelectionListener((SelectionListener)new ReturnTypeSelectionListener());
        gd = glp.createGridLayoutData(4, 4, false, false);
        this.mReturnTypeSelectionButton = glp.addPushButton("...", gd);
        this.mReturnTypeSelectionButton.addSelectionListener((SelectionListener)new ReturnTypeSelectionButtonListener());
    }

    public void changeMethodType() {
        this.mReturnTypeField.setItems(this.mData.getTypeNames());
    }

    private class ReturnTypeSelectionButtonListener
    implements SelectionListener {
        private ReturnTypeSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)MethodEditUI.this.mData.getModelClass().getRoot().getMetamodel());
            MetamodelServices.CompoundType type = MethodEditUI.this.mData.getType();
            JavaNativeType initialType = null;
            if (type != null) {
                Object object = initialType = type.isJavaNativeType() ? type.getJavaNativeType() : type.getSimpleType();
            }
            if ((type = UIHelper.selectType((DtDictionaryRoot)ddicRoot, initialType)) != null) {
                MethodEditUI.this.mData.setType(type);
                MethodEditUI.this.mReturnTypeField.setItems(MethodEditUI.this.mData.getTypeNames());
                MethodEditUI.this.mReturnTypeField.select(MethodEditUI.this.mData.getTypeIdx());
                MethodEditUI.this.mDisplayErrorListener.setErrorMessage(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    class ReturnTypeSelectionListener
    implements SelectionListener {
        ReturnTypeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            MethodEditUI.this.mData.setType(MethodEditUI.this.mReturnTypeField.getSelectionIndex());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String error = MethodService.isValidMethodName((String)MethodEditUI.this.mNameField.getText(), (AppClass)MethodEditUI.this.mData.getModelClass());
            if (error == null) {
                MethodEditUI.this.mDisplayErrorListener.setErrorMessage(null);
                MethodEditUI.this.mData.setName(MethodEditUI.this.mNameField.getText());
            } else {
                MethodEditUI.this.mDisplayErrorListener.setErrorMessage(error);
            }
        }
    }

    class VisibilityModifyListener
    implements ModifyListener {
        VisibilityModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MethodEditUI.this.mData.setVisibility(MethodEditUI.this.mVisibilityField.getSelectionIndex());
            MethodEditUI.this.mDisplayErrorListener.setErrorMessage(null);
        }
    }
}

