/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.implementation;

import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class ModelEditorResourceChecker
implements IResourceChangeListener,
IResourceDeltaVisitor,
IResourceVisitor {
    private static ModelEditorResourceChecker mInstance = null;

    public static ModelEditorResourceChecker getInstance() {
        if (mInstance == null) {
            mInstance = new ModelEditorResourceChecker();
        }
        return mInstance;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            ServiceModelEditorPlugin.internalError(this.getClass(), (String)"resourceChanged(IResourceChangeEvent)", (String)e.getMessage(), (Throwable)e, (boolean)false);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IProject project = delta.getResource().getProject();
        if (project == null) {
            return true;
        }
        if (!project.isAccessible()) {
            return false;
        }
        if (!(delta.getResource() instanceof IFile)) {
            return true;
        }
        if (!ServicesEclipse.projectHasWebDynproNature((String)project.getName())) {
            return false;
        }
        if (delta.getKind() == 1 || delta.getKind() == 4) {
            this.setEditor(delta.getResource());
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        this.setEditor(resource);
        return true;
    }

    private void setEditor(IResource resource) {
        ModelClass modelClass;
        if (resource instanceof IFile && (modelClass = ModelClassService.getModelClassFromImplementationFile((IFile)((IFile)resource))) != null && MetamodelServices.supportsImplementation((ModelClass)modelClass)) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            registry.setDefaultEditor((IFile)resource, "com.sap.ide.webdynpro.editors.ModelClass");
        }
    }
}

