/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor.implementation;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitJava;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.modeleditor.IPartActivationListener;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPart;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectEditorInput;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorSite;

public class JavaEditor
extends CompilationUnitEditor
implements IMetamodelSaveParticipant,
IPartActivationListener {
    private static final String JAVAEDITOR_RULER_CONTEXT_MENU = "#ImplementationEditorRulerContextMenu";
    private ModelClass mModelClass = null;
    private IProject mProject;
    private String mProjectPath;
    private IFolder mParentFolder;
    private boolean mCurrentlyInJavaSelectionEvent = false;
    private ITextListener mTextListener;
    private KeyListener mWriteRequestListener;
    private boolean mOnActivation = false;
    private IStatusLineManager mStatusLineManager = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IEditorSite editorSite = null;
        editorSite = site instanceof MultiPageEditorSite ? ((MultiPageEditorSite)site).getMultiPageEditor().getEditorSite() : site;
        this.setSite((IWorkbenchPartSite)site);
        this.mModelClass = (ModelClass)((DevelopmentObjectEditorInput)input).getDevelopmentObject();
        this.mProject = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mModelClass);
        this.mProjectPath = this.mProject.getLocation().toFile().getAbsolutePath();
        IFileEditorInput fileEditorInput = this.getFileEditorInput();
        this.mParentFolder = (IFolder)fileEditorInput.getFile().getParent();
        super.init(editorSite, (IEditorInput)fileEditorInput);
        try {
            JavaUI.getWorkingCopyManager().connect((IEditorInput)fileEditorInput);
        }
        catch (CoreException e) {
            new PartInitException("Failed to connect java implementation file to working copy manager", (Throwable)e);
        }
    }

    protected void handleEditorInputChanged() {
    }

    public void dispose() {
        super.dispose();
        this.removeListeners();
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void preSave() {
        this.getSourceViewer().removeTextListener(this.mTextListener);
    }

    public void postSave() {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            this.doRevertToSaved();
        }
        this.getSourceViewer().addTextListener(this.mTextListener);
    }

    public void postRollback() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        if (part instanceof ModelEditorPart && ((ModelEditorPart)part).isActivePart((IEditorPart)this)) {
            this.doGeneration();
        }
    }

    public void partActivated() {
        this.mOnActivation = true;
        this.doGeneration();
        this.addListeners();
        this.mOnActivation = false;
    }

    public Metamodel getMetamodel() {
        if (this.mModelClass != null) {
            this.mModelClass.getRoot().getMetamodel();
        }
        return null;
    }

    public boolean isEditable() {
        return !this.mModelClass.isReadOnly() && super.isEditable();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.mCurrentlyInJavaSelectionEvent) {
            this.doSelectionChanged(event);
        }
    }

    public void synchronizeOutlinePageSelection() {
        this.mCurrentlyInJavaSelectionEvent = true;
        super.synchronizeOutlinePageSelection();
        this.mCurrentlyInJavaSelectionEvent = false;
    }

    protected NamingGenerationUnitJava getNaming(AppClass appClass, NamingService namingService) {
        return namingService.getModelClassNaming(this.mModelClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGeneration() {
        IProgressMonitor monitor = null;
        try {
            monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
            this.doGeneration(monitor, true);
            Object var3_2 = null;
            if (monitor == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void doGeneration(IProgressMonitor monitor, boolean doRevertToSaved) {
        if (doRevertToSaved &= ModelClassService.generateModelClass((ModelClass)this.mModelClass, (IProject)this.mProject, (IProgressMonitor)monitor)) {
            this.doRevertToSaved();
        }
    }

    protected void updateMetadata() {
        String content;
        if (!this.mModelClass.isReadOnly() && (content = this.getEditorContent()) != null) {
            this.mModelClass.setCodeBody(content);
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        if (this.mStatusLineManager == null) {
            IEditorActionBarContributor lActionContributor;
            IEditorPart lActiveEditor;
            IWorkbenchPage lActivePage;
            IWorkbenchWindow lActiveWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (lActiveWindow != null && (lActivePage = lActiveWindow.getActivePage()) != null && (lActiveEditor = lActivePage.getActiveEditor()) != null && (lActionContributor = lActiveEditor.getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
                this.mStatusLineManager = ((EditorActionBarContributor)lActionContributor).getActionBars().getStatusLineManager();
            }
            if (this.mStatusLineManager == null) {
                this.mStatusLineManager = new StatusLineManager();
            }
        }
        return this.mStatusLineManager;
    }

    private IFileEditorInput getFileEditorInput() throws PartInitException {
        FileEditorInput fileEditorInput = null;
        String message = null;
        NamingService lNamingService = new NamingService(this.mProjectPath + GenerationEclipse.getGenerationOutputPathInfix());
        NamingGenerationUnitJava naming = this.getNaming((AppClass)this.mModelClass, lNamingService);
        if (naming != null) {
            Path path = new Path(naming.getAbsoluteFilePath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file == null || !file.exists()) {
                this.doGeneration((IProgressMonitor)new NullProgressMonitor(), false);
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            }
            fileEditorInput = new FileEditorInput(file);
        } else {
            message = "Implementation location cannot be retrieved from naming service";
        }
        if (fileEditorInput == null) {
            throw new PartInitException(message);
        }
        return fileEditorInput;
    }

    private String getEditorContent() {
        StyledText textWidget;
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null && (textWidget = viewer.getTextWidget()) != null) {
            return textWidget.getText();
        }
        return null;
    }

    private void addListeners() {
        if (this.getSourceViewer() != null && this.mTextListener == null) {
            this.mTextListener = new TextListener();
            this.getSourceViewer().addTextListener(this.mTextListener);
            this.mWriteRequestListener = new WriteRequestKeyListener();
            this.getSourceViewer().getTextWidget().addKeyListener(this.mWriteRequestListener);
        }
    }

    private void removeListeners() {
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().removeTextListener(this.mTextListener);
            this.getSourceViewer().getTextWidget().removeKeyListener(this.mWriteRequestListener);
        }
    }

    private class WriteRequestKeyListener
    implements KeyListener {
        private WriteRequestKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (JavaEditor.this.mModelClass.isReadOnly() && (!Character.isISOControl(e.character) || e.character == '\r' || e.character == '\b') && RepositoryUtilities.checkWriteability((MainDevelopmentObject[])new MainDevelopmentObject[]{JavaEditor.this.mModelClass}, (boolean)false)) {
                JavaEditor.super.updateState(JavaEditor.this.getEditorInput());
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        public void textChanged(TextEvent event) {
            if (!JavaEditor.this.mOnActivation) {
                JavaEditor.this.updateMetadata();
            }
        }
    }

    private class IsDirtyPropertyListener
    implements IPropertyListener {
        private IsDirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && JavaEditor.this.isDirty()) {
                JavaEditor.this.updateMetadata();
            }
        }
    }
}

