/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelHelper;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.modeleditor.IPartActivationListener;
import com.sap.ide.webdynpro.modeleditor.ModelEditorContributor;
import com.sap.ide.webdynpro.modeleditor.ModelEditorOutlinePage;
import com.sap.ide.webdynpro.modeleditor.ModelEditorPlugin;
import com.sap.ide.webdynpro.modeleditor.implementation.JavaEditor;
import com.sap.ide.webdynpro.modeleditor.methods.MethodsPage;
import com.sap.ide.webdynpro.modeleditor.overview.OverviewPage;
import com.sap.ide.webdynpro.modeleditor.properties.PropertiesPage;
import com.sap.ide.webdynpro.modeleditor.relations.RelationsPage;
import com.sap.ide.webdynpro.modeleditor.settings.ModelSettingsPropertySource;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectEditorInput;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassEditorInput;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ModelEditorPart
extends MultiPageEditorPart
implements IMetamodelSaveParticipant,
IDevelopmentObjectEditor {
    private ModelClass mModelClass;
    private JavaEditor mJavaEditor;
    private int mJavaEditorPageIndex = -1;
    private int mActivePageIndex = -1;
    private boolean mFocusRequestImplementationPage = false;
    private ModelEditorOutlinePage mOutlinePage;
    private IEditorPart[] mInnerEditors;
    private boolean mCurrentReadonlyState = false;
    private PropertySheetPage mPropertySheetPage;
    private IPartListener mPartListener;
    private RefactorObserver mRefactorObserver;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof ModelClassEditorInput) {
            super.init(site, editorInput);
            this.mModelClass = (ModelClass)((ModelClassEditorInput)editorInput).getDevelopmentObject();
        } else if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            if (fileEditorInput.getFile() == null) {
                throw new PartInitException("Invalid model editor input, implementation file missing");
            }
            if (ModelClassService.isImplementationFile((IFileEditorInput)fileEditorInput)) {
                this.mModelClass = ModelClassService.getModelClassFromImplementationFile((IFileEditorInput)fileEditorInput);
                this.mFocusRequestImplementationPage = true;
            } else {
                try {
                    this.mModelClass = ModelClassService.getModelClassFromMetadataFile((IFileEditorInput)fileEditorInput);
                }
                catch (LoadException e) {
                    ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "init", "Failed to load models from file system", e, true);
                    throw new PartInitException("Failed to load models from file system, description: " + e.getMessage());
                }
            }
            super.init(site, (IEditorInput)new ModelClassEditorInput(this.mModelClass));
        }
        if (this.mModelClass == null) {
            throw new PartInitException("Cannot retrieve model class from editor input");
        }
        this.mCurrentReadonlyState = this.mModelClass.isReadOnly();
        this.setTitle(this.mModelClass.getName());
        if (this.mModelClass.getIsInterface()) {
            this.setTitleImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_MODEL_INTERFACE));
        } else {
            this.setTitleImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_MODEL_CLASS));
        }
        this.mRefactorObserver = new RefactorObserver();
        this.mModelClass.attachObserver((DevelopmentObjectObserver)this.mRefactorObserver, 8256);
        this.mPartListener = new PartListener();
        this.getSite().getPage().addPartListener(this.mPartListener);
        this.closeOpenEditors();
    }

    public void setFocus() {
        super.setFocus();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof ModelEditorContributor) {
            if (this.mModelClass.isReadOnly()) {
                ((ModelEditorContributor)contributor).setReadOnlyText(TextPool.getInstance().getText(500));
            } else {
                ((ModelEditorContributor)contributor).setReadOnlyText(TextPool.getInstance().getText(501));
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        if (marker.getResource().getFileExtension().equals("java") && this.mJavaEditor != null) {
            this.mJavaEditor.gotoMarker(marker);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void postSave() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof IMetamodelSaveParticipant) {
                ((IMetamodelSaveParticipant)editor).postSave();
            }
            --i;
        }
    }

    public void preSave() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof IMetamodelSaveParticipant) {
                ((IMetamodelSaveParticipant)editor).preSave();
            }
            --i;
        }
    }

    public void postRollback() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof IMetamodelSaveParticipant) {
                ((IMetamodelSaveParticipant)editor).postRollback();
            }
            --i;
        }
        if (!this.mModelClass.isValid()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
        }
    }

    public Metamodel getMetamodel() {
        if (this.mModelClass != null) {
            return this.mModelClass.getRoot().getMetamodel();
        }
        return null;
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.mModelClass;
    }

    public void updateUI() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof IDevelopmentObjectEditor) {
                ((IDevelopmentObjectEditor)editor).updateUI();
            }
            --i;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ModelEditorPart.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage();
        }
        if (adapter.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = ModelEditorPart.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public boolean isActivePart(IEditorPart part) {
        return this.getActiveEditor().equals(part);
    }

    public IEditorPart[] getInnerEditors() {
        if (this.mInnerEditors == null) {
            this.mInnerEditors = new IEditorPart[this.getPageCount()];
            int i = 0;
            while (i < this.getPageCount()) {
                this.mInnerEditors[i] = this.getEditor(i);
                ++i;
            }
        }
        return this.mInnerEditors;
    }

    public int getActivePageIndex() {
        return this.getActivePage();
    }

    private boolean shouldUpdateUI(MetamodelEvent event) {
        if (event.getEventId() == 2) {
            return true;
        }
        if (event.getModifiedObject() instanceof ModelClass) {
            ModelClass modifiedModelClass = (ModelClass)event.getModifiedObject();
            Model model = this.mModelClass.getModel();
            if (model.equals(modifiedModelClass.getModel())) {
                return true;
            }
            if (model.getUsedModelCount() > 0) {
                Model[] usedModels = ModelHelper.getUsedModels((Model)modifiedModelClass.getModel(), (boolean)true);
                int i = 0;
                while (i < usedModels.length) {
                    if (usedModels[i].equals(model)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.mOutlinePage == null) {
            this.mOutlinePage = new ModelEditorOutlinePage(this);
        }
        return this.mOutlinePage;
    }

    private IPropertySheetPage getPropertySheetPage() {
        if (this.mPropertySheetPage == null) {
            this.mPropertySheetPage = new PropertySheetPage();
            this.mPropertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new PropertySourceProvider());
        }
        return this.mPropertySheetPage;
    }

    public void dispose() {
        this.mModelClass.detachObserver((DevelopmentObjectObserver)this.mRefactorObserver);
        this.getSite().getPage().removePartListener(this.mPartListener);
        if (this.mOutlinePage != null) {
            this.mOutlinePage.dispose();
        }
        super.dispose();
    }

    protected void createPages() {
        this.createOverviewPage();
        this.createPropertiesPage();
        this.createMethodsPage();
        this.createRelationsPage();
        if (MetamodelServices.supportsImplementation((ModelClass)this.mModelClass)) {
            this.createImplementationPage();
        }
        this.setInitialTab();
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex > 0 && newPageIndex < this.getInnerEditors().length) {
            this.setFocus(newPageIndex);
            if (newPageIndex != this.mActivePageIndex) {
                IEditorActionBarContributor contributor;
                if (this.mOutlinePage != null) {
                    this.mOutlinePage.showActivePage();
                }
                if ((contributor = this.getEditorSite().getActionBarContributor()) instanceof ModelEditorContributor) {
                    ((ModelEditorContributor)contributor).setActivePage(this.getInnerEditors()[newPageIndex]);
                }
                ((IPartActivationListener)this.getInnerEditors()[newPageIndex]).partActivated();
                this.mActivePageIndex = newPageIndex;
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    private void createOverviewPage() {
        OverviewPage page = new OverviewPage();
        try {
            int index = this.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(index, TextPool.getInstance().getText(341));
        }
        catch (PartInitException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createOverviewPage()", "Failed to create overview editor page", e, false);
        }
    }

    private void createPropertiesPage() {
        PropertiesPage page = new PropertiesPage();
        try {
            int index = this.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(index, TextPool.getInstance().getText(325));
        }
        catch (PartInitException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createPropertiesPage()", "Failed to create properties editor page", e, false);
        }
    }

    private void createMethodsPage() {
        MethodsPage page = new MethodsPage();
        try {
            int index = this.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(index, TextPool.getInstance().getText(324));
        }
        catch (PartInitException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createMethodsPage()", "Failed to create method editor page", e, false);
        }
    }

    private void createRelationsPage() {
        RelationsPage page = new RelationsPage();
        try {
            int index = this.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(index, TextPool.getInstance().getText(334));
        }
        catch (PartInitException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createRelationsPage()", "Failed to create relation editor page", e, false);
        }
    }

    private void createImplementationPage() {
        this.mJavaEditor = new JavaEditor();
        try {
            this.mJavaEditorPageIndex = this.addPage((IEditorPart)this.mJavaEditor, this.getEditorInput());
            this.setPageText(this.mJavaEditorPageIndex, TextPool.getInstance().getText(308));
        }
        catch (PartInitException e) {
            ModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createImplementationPage()", "Failed to create java implementation editor page", e, false);
        }
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
        } else {
            Control control = this.getControl(pageIndex);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    private void setInitialTab() {
        if (this.mFocusRequestImplementationPage) {
            this.pageChange(this.mJavaEditorPageIndex);
            this.setActivePage(this.mJavaEditorPageIndex);
        }
    }

    private void closeOpenEditors() {
        IMetamodelSaveParticipant[] allEditors = MetamodelHelper.getAllActiveMetamodelEditors((Metamodel)this.mModelClass.getRoot().getMetamodel());
        int i = 0;
        while (i < allEditors.length) {
            DevelopmentObjectEditorInput input;
            IEditorPart part;
            if (allEditors[i] instanceof IEditorPart && (part = (IEditorPart)allEditors[i]) != this && part.getEditorInput() instanceof DevelopmentObjectEditorInput && (input = (DevelopmentObjectEditorInput)part.getEditorInput()).getDevelopmentObject() == this.mModelClass) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            ModelEditorPart.this.getPropertySheetPage().selectionChanged((IWorkbenchPart)ModelEditorPart.this, (ISelection)new StructuredSelection((Object)ModelEditorPart.this.mModelClass));
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class ModelObserver
    implements DevelopmentObjectObserver {
        private ModelObserver() {
        }

        public void update(MetamodelEvent event) {
            ModelEditorPart.this.updateUI();
        }

        public void update(MetamodelEvent[] events) {
            if (events.length > 0) {
                this.update(events[0]);
            }
        }
    }

    private class ModelClassObserver
    implements DevelopmentObjectObserver {
        private ModelClassObserver() {
        }

        public void update(MetamodelEvent event) {
            ModelEditorPart.this.updateUI();
        }

        public void update(MetamodelEvent[] events) {
            if (events.length > 0) {
                this.update(events[0]);
            }
        }
    }

    private class RefactorObserver
    implements DevelopmentObjectObserver {
        private RefactorObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            ModelEditorPart.super.setTitle(ModelEditorPart.this.mModelClass.getName());
        }
    }

    class PropertySourceProvider
    implements IPropertySourceProvider {
        PropertySourceProvider() {
        }

        public IPropertySource getPropertySource(Object object) {
            if (object instanceof ModelClass) {
                return new ModelSettingsPropertySource((ModelClass)object);
            }
            return null;
        }
    }
}

