/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor;

import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.AbstractTableSection;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.glpc.section.IMenuProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ContextMenuProvider
implements IMenuProvider,
SelectionListener {
    private AbstractTableSection mTableSection = null;
    private MenuItem mItemEdit = null;
    private MenuItem mItemCopy = null;
    private MenuItem mItemDelete = null;
    private String mItemDeleteText = CoreTextPool.getInstance().getText(156);

    public ContextMenuProvider(AbstractTableSection tableSection) {
        this.mTableSection = tableSection;
    }

    public void addItems(Menu menu) {
        int index = this.mTableSection.getTableViewer().getTable().getSelectionIndex();
        this.mItemEdit = new MenuItem(menu, 0);
        this.mItemEdit.setText(CoreTextPool.getInstance().getText(153));
        this.mItemEdit.addSelectionListener((SelectionListener)this);
        new MenuItem(menu, 2);
        if (index < 0 || !((AbstractTableModel)this.mTableSection.getTableModel()).isEditable(index)) {
            this.mItemEdit.setEnabled(false);
        }
        this.mItemCopy = new MenuItem(menu, 0);
        this.mItemCopy.setText(CoreTextPool.getInstance().getText(154));
        this.mItemCopy.addSelectionListener((SelectionListener)this);
        if (index < 0 || !((AbstractTableModel)this.mTableSection.getTableModel()).isCopyable(index)) {
            this.mItemCopy.setEnabled(false);
        }
        this.mItemDelete = new MenuItem(menu, 0);
        this.mItemDelete.setText(this.mItemDeleteText);
        this.mItemDelete.addSelectionListener((SelectionListener)this);
        if (index < 0 || !((AbstractTableModel)this.mTableSection.getTableModel()).isDeleteable(index)) {
            this.mItemDelete.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int index = this.mTableSection.getSelectionIndex();
        if (e.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)e.widget;
            if (item.equals(this.mItemEdit)) {
                ((AbstractTableModel)this.mTableSection.getTableModel()).doEdit(index);
            } else if (item.equals(this.mItemCopy)) {
                ((AbstractTableModel)this.mTableSection.getTableModel()).doCopy(index);
            } else if (item.equals(this.mItemDelete)) {
                ((AbstractTableModel)this.mTableSection.getTableModel()).doDelete(index);
            }
        }
    }

    public void setItemDeleteText(String text) {
        this.mItemDeleteText = text;
    }
}

