/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.modeleditor.AbstractTableModel;
import com.sap.ide.webdynpro.modeleditor.ContextMenuProvider;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.TableSection;
import com.tssap.util.ui.pane.IGridLayoutPane;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractTableSection
extends TableSection
implements SelectionListener,
IButtonClickedListener,
DevelopmentObjectObserver {
    protected static final TextPool mTextPool = TextPool.getInstance();
    protected static final int BUTTON_INDEX_NEW = 0;
    protected static final String[] BUTTONS_STANDARD = new String[]{CoreTextPool.getInstance().getText(152)};
    protected static final boolean[] BUTTONS_STANDARD_ENABLED = new boolean[]{true};
    protected static final boolean[] BUTTONS_STANDARD_DISABLED = new boolean[]{false};
    private ContextMenuProvider mContextMenuProvider = null;
    private Button mBtShowInherited;
    private boolean mSupportInheritance = false;
    private boolean mRegisterObserver = false;

    public AbstractTableSection(AbstractTableModel tableModel, String title, String description, String[] buttons, boolean supportInheritance) {
        this(tableModel, title, description, buttons, null, supportInheritance);
    }

    public AbstractTableSection(AbstractTableModel tableModel, String title, String description, String[] buttons, boolean[] buttonsEnabled, boolean supportInheritance) {
        super((TableModel)tableModel, ServiceCorePlugin.WIDGET_FACTORY, title, description, buttons, buttonsEnabled);
        this.mSupportInheritance = supportInheritance;
        this.mContextMenuProvider = new ContextMenuProvider(this);
        this.addMenuProvider(this.mContextMenuProvider);
    }

    public ContextMenuProvider getContextMenuProvider() {
        return this.mContextMenuProvider;
    }

    public void update(DevelopmentObject newMasterObject) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget instanceof Table) {
            Table table = (Table)e.widget;
            ((AbstractTableModel)this.getTableModel()).selectionChanged(table.getSelectionIndex());
        }
    }

    public void buttonClicked(ButtonClickedEvent e) {
        switch (e.getIndex()) {
            case 0: {
                ((AbstractTableModel)this.getTableModel()).doNew();
            }
        }
    }

    public void update(MetamodelEvent event) {
        if (event.getModifiedObject().isValid() && event.getEventId() != 32768) {
            if (this.mSupportInheritance && event.getEventId() == 128) {
                this.showInherited(this.getModelClass().getSuperClass() != null);
            }
            ((AbstractTableModel)this.getTableModel()).refresh();
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    protected void changedReadonlyState(boolean readonly) {
        int i = 0;
        while (i < BUTTONS_STANDARD.length) {
            this.setButtonEnabled(i, !readonly);
            ++i;
        }
    }

    protected void preInitSection(IGridLayoutPane glp) {
        if (this.mSupportInheritance) {
            this.mBtShowInherited = glp.addCheckBox(TextPool.getInstance().getText(433), this.getModelClass().getSuperClass() != null);
            this.mBtShowInherited.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((AbstractTableModel)AbstractTableSection.this.getTableModel()).showInherited(((Button)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.showInherited(this.getModelClass().getSuperClass() != null);
        }
    }

    protected void postInitSection(IGridLayoutPane glp) {
        super.postInitSection(glp);
        this.addButtonClickedListener(this);
        this.addSelectionListener(this);
        if (this.mRegisterObserver || this.mSupportInheritance) {
            this.getModelClass().attachChildrenObserver((DevelopmentObjectObserver)this, 0x7FFFFFC7);
        }
        this.getUserAreaGridLayoutPane().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractTableSection.this.mRegisterObserver || AbstractTableSection.this.mSupportInheritance) {
                    AbstractTableSection.this.getModelClass().detachChildrenObserver((DevelopmentObjectObserver)AbstractTableSection.this);
                    AbstractTableSection.this.disposed(e);
                }
            }
        });
    }

    protected ModelClass getModelClass() {
        return ((AbstractTableModel)this.getTableModel()).getModelClass();
    }

    protected void disposed(DisposeEvent e) {
    }

    protected void registerDevelopmentObjectObserver() {
        this.mRegisterObserver = true;
    }

    private void showInherited(boolean state) {
        if (this.mBtShowInherited != null) {
            this.mBtShowInherited.setEnabled(state);
            this.mBtShowInherited.setSelection(state);
        }
        ((AbstractTableModel)this.getTableModel()).showInherited(state);
    }
}

