/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.modeleditor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.modeleditor.AbstractTableSection;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractTableModel
extends javax.swing.table.AbstractTableModel {
    protected static final TextPool mTextPool = TextPool.getInstance();
    public static final String ERROR = mTextPool.getText(14);
    ModelClass mModelClass;
    private int mNumberOfColumns = 0;
    private String[] mColumnNames = new String[0];
    private Class[] mColumnClasses = new Class[0];
    private HashMap mDetailTableModels = new HashMap();
    protected int mSelectionIndex = -1;
    private AbstractTableSection mTableSection = null;
    private boolean mShowInherited = true;

    public AbstractTableModel(ModelClass modelClass) {
        this.mModelClass = modelClass;
    }

    public ModelClass getModelClass() {
        return this.mModelClass;
    }

    public void setTableSection(AbstractTableSection tableSection) {
        this.mTableSection = tableSection;
    }

    public void addDetailTableModel(AbstractTableModel tableModel) {
        if (this.mDetailTableModels.get(tableModel.getInternalName()) == null) {
            this.mDetailTableModels.put(tableModel.getInternalName(), tableModel);
        }
    }

    public void removeDetailTableModel(AbstractTableModel tableModel) {
        this.mDetailTableModels.remove(tableModel.getInternalName());
    }

    public void selectionChanged(int newSelection) {
        if (newSelection > -2 && newSelection < this.getRowCount()) {
            this.mSelectionIndex = newSelection;
            DevelopmentObject selectedObject = null;
            if (this.mSelectionIndex > -1) {
                selectedObject = this.getDataTableEntry(this.mSelectionIndex);
            }
            Iterator it = this.mDetailTableModels.values().iterator();
            while (it.hasNext()) {
                AbstractTableModel tableModel = (AbstractTableModel)it.next();
                tableModel.masterObjectChanged(selectedObject);
            }
        }
    }

    public abstract DevelopmentObject getDataTableEntry(int var1);

    public int getColumnCount() {
        return this.mNumberOfColumns;
    }

    public String getColumnName(int columnIndex) {
        return this.mColumnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.mColumnClasses[columnIndex];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public boolean isEditable(int index) {
        return this.isEditAllowed(index);
    }

    public boolean isCopyable(int index) {
        return this.isCopyAllowed(index);
    }

    public boolean isDeleteable(int index) {
        return this.isDeleteAllowed(index);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditCellAllowed(rowIndex, columnIndex);
    }

    public abstract int getRowCount();

    public abstract Object getValueAt(int var1, int var2);

    protected String getInternalName() {
        return this.getClass().getName();
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        this.mSelectionIndex = -1;
        this.updateDataTable();
        this.fireTableDataChanged();
        this.mTableSection.update(newMasterObject);
    }

    protected boolean getShowInherited() {
        return this.mShowInherited;
    }

    protected void showInherited(boolean state) {
        if (this.mShowInherited != state) {
            this.mShowInherited = state;
            if (this.getModelClass().getSuperClass() != null) {
                this.refresh();
            }
        }
    }

    protected abstract void updateDataTable();

    protected void doNew() {
    }

    protected void doEdit(int index) {
    }

    protected void doCopy(int index) {
    }

    protected void doDelete(int index) {
    }

    protected void setNumberOfColumns(int numberOfColumns) {
        this.mNumberOfColumns = numberOfColumns;
    }

    protected void setColumnNames(String[] columnNames) {
        this.mColumnNames = columnNames;
    }

    protected void setColumnClasses(Class[] columnClasses) {
        this.mColumnClasses = columnClasses;
    }

    protected abstract boolean isRefreshNeeded(MetamodelEvent var1);

    protected boolean isEditAllowed(int index) {
        return false;
    }

    protected boolean isCopyAllowed(int index) {
        return false;
    }

    protected boolean isDeleteAllowed(int index) {
        return false;
    }

    protected boolean isEditCellAllowed(int rowIndex, int columnIndex) {
        return false;
    }

    public void refresh() {
        this.updateDataTable();
        if (this.mSelectionIndex >= this.getRowCount()) {
            this.mSelectionIndex = -1;
            DevelopmentObject selectedObject = null;
            Iterator it = this.mDetailTableModels.values().iterator();
            while (it.hasNext()) {
                AbstractTableModel tableModel = (AbstractTableModel)it.next();
                tableModel.masterObjectChanged(selectedObject);
            }
        }
        this.fireTableDataChanged();
    }
}

