/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.scanner;

import com.tssap.selena.internal.java.scanner.JavaScannerException;
import java.util.Arrays;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public final class JavaScanner {
    public static final int LEFT_BRACE = 110;
    public static final int SEMICOLON = 64;
    public static final int IDENTIFIER = 5;
    private final IScanner myScannerImpl = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
    private int myCurrentToken;
    private boolean myHasCurrent;
    private static int[] MODIFIERS = new int[]{98, 94, 103, 101, 102, 99, 100, 85, 105, 106, 104};
    private static int[] PRIMITIVE_TYPES = new int[]{23, 20, 18, 19, 24, 21, 22, 25};

    public JavaScanner(String source) {
        this.myScannerImpl.setSource(source.toCharArray());
        this.myHasCurrent = false;
    }

    public String getSource() {
        return new String(this.myScannerImpl.getSource());
    }

    public int getCurrentToken() {
        if (this.myHasCurrent) {
            return this.myCurrentToken;
        }
        throw new IllegalStateException("call getNextToken prior to getCurrentToken()");
    }

    public int getNextToken() throws JavaScannerException {
        try {
            this.myCurrentToken = this.myScannerImpl.getNextToken();
            this.myHasCurrent = true;
            return this.myCurrentToken;
        }
        catch (InvalidInputException ex) {
            throw new JavaScannerException("getNextToken()", (Exception)((Object)ex));
        }
    }

    public int getCurrentTokenStartPosition() {
        return this.myScannerImpl.getCurrentTokenStartPosition();
    }

    public int getCurrentTokenEndPosition() {
        return this.myScannerImpl.getCurrentTokenEndPosition();
    }

    public String getSource(int start) {
        return new String(this.myScannerImpl.getSource(), start, this.getCurrentTokenEndPosition() + 1 - start);
    }

    public String getSource(int start, int end) {
        return new String(this.myScannerImpl.getSource(), start, end + 1 - start);
    }

    public String getCurrentTokenSourceAsString() {
        return this.getSource(this.getCurrentTokenStartPosition());
    }

    public void runTo(int lastToken) throws JavaScannerException {
        while (this.getNextToken() != lastToken) {
            this.checkNotEof();
        }
    }

    public void checkNotEof() throws JavaScannerException {
        if (this.myCurrentToken == 158) {
            throw new JavaScannerException("Unexpected EOF", null);
        }
    }

    public boolean isFieldOrMethodStart() {
        return this.isModifier() || this.isPrimitiveType() || this.myCurrentToken == 26 || this.myCurrentToken == 5;
    }

    public boolean isEOF() {
        return this.myCurrentToken == 158;
    }

    public boolean isSemicolon() {
        return this.myCurrentToken == 64;
    }

    public boolean isOpenBrace() {
        return this.myCurrentToken == 110;
    }

    public boolean isCloseBrace() {
        return this.myCurrentToken == 95;
    }

    public boolean isClassOrInterface() {
        return this.myCurrentToken == 165 || this.myCurrentToken == 180;
    }

    public boolean isAssignOperator() {
        return this.myCurrentToken == 167;
    }

    public boolean isLeftParen() {
        return this.myCurrentToken == 7;
    }

    public boolean isRightParen() {
        return this.myCurrentToken == 86;
    }

    public boolean isBareComment() {
        if (this.myCurrentToken == 1001) {
            return true;
        }
        if (this.myCurrentToken == 1002) {
            return !this.isDesignComment();
        }
        return false;
    }

    public boolean isModifier() {
        return Arrays.binarySearch(MODIFIERS, this.myCurrentToken) >= 0;
    }

    public boolean isPrimitiveType() {
        return Arrays.binarySearch(PRIMITIVE_TYPES, this.myCurrentToken) >= 0;
    }

    public boolean isJavadoc() {
        return this.myCurrentToken == 1003;
    }

    public boolean isDesignComment() {
        if (this.myCurrentToken == 1002) {
            return this.getCurrentTokenSourceAsString().startsWith("/*#");
        }
        return false;
    }

    public boolean isImport() {
        return this.myCurrentToken == 191;
    }

    public boolean isPackage() {
        return this.myCurrentToken == 214;
    }

    public boolean isIdentifier() {
        return this.myCurrentToken == 5;
    }

    static {
        Arrays.sort(MODIFIERS);
        Arrays.sort(PRIMITIVE_TYPES);
    }
}

